/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real.impl2;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraManager;
import android.os.Handler;
import android.os.Looper;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.HandlerThreadHandler;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.DeviceManager;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerFactory;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.capture.impl.real.impl2.Camera2CapabilitiesUtils;
import com.microsoft.dl.video.capture.impl.real.impl2.RealCamera2Impl;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RealCamera2ManagerImpl
implements com.microsoft.dl.video.capture.api.CameraManager {
    private final Object capabilitiesLock = new Object();
    private Map<String, CameraCapabilities> capabilities;
    private static final int REFRESH_DEVICE_TIME_DELAY = 10;
    private final HandlerThreadHandler refreshDevicesHandler = HandlerThreadHandler.createHandler((String)"RefreshCameraDevicesHandler");
    private final CameraManager.AvailabilityCallback availabilityCallback = new CameraManager.AvailabilityCallback(){

        public void onCameraAvailable(String cameraId) {
            super.onCameraAvailable(cameraId);
            Log.i((String)"Video", (String)("RealCamera2ManagerImpl: onCameraAvailable cameraId: " + cameraId));
            RealCamera2ManagerImpl.this.refreshCameraDevice(cameraId, true);
        }

        public void onCameraUnavailable(String cameraId) {
            super.onCameraUnavailable(cameraId);
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("RealCamera2ManagerImpl: onCameraUnavailable cameraId: " + cameraId));
            }
            RealCamera2ManagerImpl.this.refreshCameraDevice(cameraId, false);
        }
    };

    @Override
    public void refreshCameraDevice(String id, boolean available) {
        if (available) {
            this.refreshDevicesHandler.post((Runnable)new RefreshDeviceRunnable(id, available));
        } else {
            this.refreshDevicesHandler.postDelayed((Runnable)new RefreshDeviceRunnable(id, available), 10L);
        }
    }

    private RealCamera2ManagerImpl() {
        Context ctx = Platform.getInfo().getAppContext();
        CameraManager cameraManager = (CameraManager)ctx.getSystemService("camera");
        if (cameraManager == null) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"ERROR: cameraManager is null");
            }
            return;
        }
        cameraManager.registerAvailabilityCallback(this.availabilityCallback, new Handler(Looper.getMainLooper()));
    }

    @Override
    public final String[] getCameraIds() throws CaptureException {
        Context ctx;
        CameraManager cameraManager;
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("CAMERA2:getCameraIds starts with instance: " + this));
        }
        if ((cameraManager = (CameraManager)(ctx = Platform.getInfo().getAppContext()).getSystemService("camera")) == null) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"ERROR: cameraManager is null");
            }
            throw new CaptureException("android.hardware.camera2.CameraManager null", ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
        }
        try {
            return cameraManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught ", (Throwable)e);
            }
            throw new CaptureException(e, ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
        }
    }

    @Override
    public final Camera openCamera(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("CAMERA2:openCamera: " + id));
        }
        return new RealCamera2Impl(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CameraCapabilities getCameraCapabilities(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"CAMERA2:getCameraCapabilities");
        }
        Object object = this.capabilitiesLock;
        synchronized (object) {
            if (this.capabilities == null) {
                this.capabilities = Camera2CapabilitiesUtils.obtain();
            }
            if (this.capabilities != null && !this.capabilities.containsKey(id)) {
                this.collectCameraCapabilities(id);
            }
            if (this.capabilities == null || !this.capabilities.containsKey(id)) {
                throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_CAMERA_INVALID_ID);
            }
            return this.capabilities.get(id).clone();
        }
    }

    @Override
    public final StaticCameraCapabilities getStaticCameraCapabilities(String id) throws CaptureException {
        return this.getCameraCapabilities(id);
    }

    @Override
    public void close() {
        block4: {
            Context ctx = Platform.getInfo().getAppContext();
            CameraManager cameraManager = (CameraManager)ctx.getSystemService("camera");
            if (cameraManager != null) {
                cameraManager.unregisterAvailabilityCallback(this.availabilityCallback);
            }
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"CAMERA2:close");
            }
            try {
                this.refreshDevicesHandler.getLooper().quit();
            }
            catch (Exception e) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block4;
                Log.e((String)"Video", (String)"refreshDevicesHandler.getLooper exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectCameraCapabilities(String cameraId) throws CaptureException {
        CameraCapabilities availableCameraCap = Camera2CapabilitiesUtils.getCameraCapabilities(cameraId);
        Object object = this.capabilitiesLock;
        synchronized (object) {
            if (this.capabilities != null && !this.capabilities.containsKey(cameraId)) {
                this.capabilities.put(cameraId, availableCameraCap);
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("RealCamera2ManagerImpl collection camera capabilities: " + availableCameraCap.toString()));
                }
            }
        }
    }

    private static class CollectCapabilitiesThread
    extends Thread {
        private final WeakReference<RealCamera2ManagerImpl> reference;
        private final String cameraId;

        public CollectCapabilitiesThread(RealCamera2ManagerImpl impl, String cameraId) {
            this.reference = new WeakReference<RealCamera2ManagerImpl>(impl);
            this.cameraId = cameraId;
        }

        @Override
        public void run() {
            RealCamera2ManagerImpl impl;
            RealCamera2ManagerImpl realCamera2ManagerImpl = impl = this.reference == null ? null : (RealCamera2ManagerImpl)this.reference.get();
            if (impl != null) {
                try {
                    impl.collectCameraCapabilities(this.cameraId);
                }
                catch (CaptureException exception) {
                    Log.log((int)6, (String)"Video", (String)"Error: ", (Throwable)exception);
                }
            }
        }
    }

    public static class Factory
    implements CameraManagerFactory {
        @Override
        public final com.microsoft.dl.video.capture.api.CameraManager createCameraManager() {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"CAMERA2:createCameraManager");
            }
            return new RealCamera2ManagerImpl();
        }
    }

    private class RefreshDeviceRunnable
    implements Runnable {
        private String cameraId;
        private boolean available = false;

        RefreshDeviceRunnable(String id, boolean available) {
            this.cameraId = id;
            this.available = available;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("RefreshDeviceRunnable, camera = " + this.cameraId + " available: " + this.available));
                }
                try {
                    if (this.cameraId == null) {
                        return;
                    }
                    if (this.available) {
                        if (DeviceManager.getInstance().isDeviceListed(this.cameraId)) {
                            return;
                        }
                        RealCamera2ManagerImpl.this.getCameraCapabilities(this.cameraId);
                        DeviceManager.getInstance().notifyDeviceChanged(this.cameraId, true);
                        break block9;
                    }
                    List<String> ids = Arrays.asList(RealCamera2ManagerImpl.this.getCameraIds());
                    if (ids.contains(this.cameraId) || RealCamera2ManagerImpl.this.capabilities == null) break block9;
                    Object object = RealCamera2ManagerImpl.this.capabilitiesLock;
                    synchronized (object) {
                        RealCamera2ManagerImpl.this.capabilities.remove(this.cameraId);
                    }
                    DeviceManager.getInstance().notifyDeviceChanged(this.cameraId, false);
                }
                catch (CaptureException e) {
                    if (!Log.isLoggable((String)"Video", (int)6)) break block9;
                    Log.e((String)"Video", (String)"ERROR: RefreshDeviceRunnable cause exception.", (Throwable)e);
                }
            }
        }
    }
}

