/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl;

import android.os.Handler;
import android.os.Looper;
import com.microsoft.dl.utils.Log;
import java.lang.reflect.Method;
import java.util.Arrays;

public class OptionalControlUnit {
    private static final Method ON_STATE_CHANGED_METHOD = OptionalControlUnit.resolveMethod("com.skype.android.video.ControlUnit", "onStateChanged", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final String FULL_METHOD_NAME = ON_STATE_CHANGED_METHOD != null ? ON_STATE_CHANGED_METHOD.getDeclaringClass().getCanonicalName() + "." + ON_STATE_CHANGED_METHOD.getName() : null;
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    private static Class<?> resolveClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Could not find class " + name));
            }
            return null;
        }
    }

    private static Method resolveMethod(String className, String methodName, Class<?> ... params) {
        Class<?> clazz = OptionalControlUnit.resolveClass(className);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(methodName, params);
        }
        catch (Exception e) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Could not find method " + className + '.' + methodName + '(' + Arrays.deepToString(params) + ')'), (Throwable)e);
            }
            return null;
        }
    }

    public static void onStateChanged(int what, int arg1, int arg2) {
        if (ON_STATE_CHANGED_METHOD == null) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Could not call " + FULL_METHOD_NAME + '(' + what + ", " + arg1 + ", " + arg2 + ')'));
            }
            return;
        }
        HANDLER.post((Runnable)new OnStateChangedCmd(what, arg1, arg2));
    }

    private static class OnStateChangedCmd
    implements Runnable {
        private final int what;
        private final int arg1;
        private final int arg2;

        protected OnStateChangedCmd(int what, int arg1, int arg2) {
            this.what = what;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public void run() {
            block3: {
                try {
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Calling " + FULL_METHOD_NAME + '(' + this.what + ", " + this.arg1 + ", " + this.arg2 + ')'));
                    }
                    ON_STATE_CHANGED_METHOD.invoke(null, this.what, this.arg1, this.arg2);
                }
                catch (Exception e) {
                    if (!Log.isLoggable((String)"Video", (int)5)) break block3;
                    Log.w((String)"Video", (String)"Exception caught", (Throwable)e);
                }
            }
        }
    }
}

