/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CameraManager;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import java.util.ArrayList;
import java.util.List;

public final class DeviceManager {
    private static DeviceManager instance;
    private final String simpleClassName = this.getClass().getSimpleName();
    private final List<CameraInfo> cameras = new ArrayList<CameraInfo>();
    private final Object camerasLock = new Object();
    private final long nativeContext;

    public static native void notifyNativeDeviceChanged(long var0, boolean var2);

    private DeviceManager(long nativeContext) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"Java DeviceManager ctor");
        }
        this.nativeContext = nativeContext;
        this.refreshCameraList();
    }

    public static synchronized void reset() {
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCameraList() throws CaptureException {
        CameraManager cameraManager = CameraManagerSingleton.getInstance();
        Object object = this.camerasLock;
        synchronized (object) {
            this.cameras.clear();
            for (String cameraId : cameraManager.getCameraIds()) {
                StaticCameraCapabilities caps = cameraManager.getStaticCameraCapabilities(cameraId);
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("DeviceManager: cameraId: " + cameraId));
                }
                this.cameras.add(new CameraInfo("/" + caps.getFacing().name() + "/" + cameraId, caps));
            }
        }
    }

    public static synchronized DeviceManager getInstance() throws CaptureException {
        if (instance == null) {
            throw new CaptureException("DeviceManager not initialized.", ErrorCode.ANDROID_CAMERA_MANAGER_NOT_SET);
        }
        return instance;
    }

    public static synchronized DeviceManager getInstance(long nativeContext) {
        if (instance == null) {
            try {
                instance = new DeviceManager(nativeContext);
            }
            catch (CaptureException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"Could not instantiate DeviceManager", (Throwable)e);
                }
                return null;
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
                }
                return null;
            }
        }
        return instance;
    }

    public int getNumCameras() {
        try {
            return this.cameras.size();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public int getCameraFacing(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getFacing().ordinal();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return -1;
        }
    }

    public String getCameraName(int index) {
        try {
            return this.cameras.get(index).getName();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return null;
        }
    }

    public int getCameraOrientation(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getOrientation();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return -1;
        }
    }

    public String getFriendlyName(int index) {
        try {
            String fName = this.cameras.get(index).getStaticCameraCapabilities().getFriendlyName();
            return fName != null ? fName : this.cameras.get(index).getName();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getFriendlyName: Exception caught", (Throwable)e);
            }
            return null;
        }
    }

    public String getManufacturer(int index) {
        try {
            String manuf = this.cameras.get(index).getStaticCameraCapabilities().getManufacturer();
            return manuf != null ? manuf : "Unknown";
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getManufacturer: Exception caught", (Throwable)e);
            }
            return null;
        }
    }

    public String getModel(int index) {
        try {
            String model = this.cameras.get(index).getStaticCameraCapabilities().getModel();
            return model != null ? model : "Unknown";
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getModel: Exception caught", (Throwable)e);
            }
            return null;
        }
    }

    public int getPid(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getPid();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getPid: Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public int getVid(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getVid();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"getVid: Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public int getSmartCameraType(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getSmartCameraType().ordinal();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public int getSmartCameraIntelliFrameIndex(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getSmartCameraIntelliFrameIndex();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public int getSmartCameraExtensionVersion(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getSmartCameraExtensionVersion();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public int getSmartCameraDriverVersion(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getSmartCameraDriverVersion();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public String getCameraId(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getCameraId();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return null;
        }
    }

    public synchronized boolean isDeviceListed(String cameraId) {
        for (CameraInfo info : this.cameras) {
            if (!info.getStaticCameraCapabilities().getCameraId().equals(cameraId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyDeviceChanged(String cameraId, boolean available) {
        block6: {
            try {
                block8: {
                    CameraManager cameraManager = CameraManagerSingleton.getInstance();
                    Object object = this.camerasLock;
                    synchronized (object) {
                        block7: {
                            if (!available) break block7;
                            StaticCameraCapabilities caps = cameraManager.getStaticCameraCapabilities(cameraId);
                            this.cameras.add(new CameraInfo("/" + caps.getFacing().name() + "/" + cameraId, caps));
                            if (!Log.isLoggable((String)"Video", (int)4)) break block8;
                            Log.i((String)"Video", (String)("DeviceManager notifyDeviceChanged for camera: " + cameraId + ", available: " + available));
                            break block8;
                        }
                        for (CameraInfo info : this.cameras) {
                            if (!info.getStaticCameraCapabilities().getCameraId().equals(cameraId)) continue;
                            this.cameras.remove(info);
                            break;
                        }
                    }
                }
                DeviceManager.notifyNativeDeviceChanged(this.nativeContext, available);
            }
            catch (CaptureException | RuntimeException exception) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block6;
                Log.e((String)"Video", (String)"ERROR: DeviceManager notifyDeviceChanged() got error.", (Throwable)exception);
            }
        }
    }

    public String toString() {
        return this.simpleClassName + " [cameras=" + this.cameras + "]";
    }

    private static class CameraInfo {
        private final String name;
        private final StaticCameraCapabilities capabilities;
        private final String simpleClassName = this.getClass().getSimpleName();

        public CameraInfo(String name, StaticCameraCapabilities capabilities) {
            this.name = name;
            this.capabilities = capabilities;
        }

        public String getName() {
            return this.name;
        }

        public StaticCameraCapabilities getStaticCameraCapabilities() {
            return this.capabilities;
        }

        public String toString() {
            return this.simpleClassName + " [Capabilities=" + this.capabilities + ", name=" + this.name + "]";
        }
    }
}

