/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class Log {
    private static final int CALL_STACK_LEVEL = 4;
    private static final StackTraceElement EMPTY_STACK_TRACE_ELEMENT = new StackTraceElement("<unknown>", "<unknown>", "<unknown>", 0);
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static final int loggingLevel = Log.getLogLevel();

    public static int v(String tag, String msg) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 2, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
        return 0;
    }

    public static int v(String tag, String msg, Throwable t) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 2, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
        return 0;
    }

    public static int d(String tag, String msg) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 3, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
        return 0;
    }

    public static int d(String tag, String msg, Throwable t) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 3, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
        return 0;
    }

    public static int i(String tag, String msg) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 4, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
        return 0;
    }

    public static int i(String tag, String msg, Throwable t) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 4, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
        return 0;
    }

    public static int w(String tag, String msg) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 5, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
        return 0;
    }

    public static int w(String tag, Throwable t) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 5, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), null, Log.getStackTraceString(t), null);
        return 0;
    }

    public static int w(String tag, String msg, Throwable t) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 5, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
        return 0;
    }

    public static int e(String tag, String msg) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 6, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, null);
        return 0;
    }

    public static int e(String tag, String msg, Throwable t) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 6, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), null);
        return 0;
    }

    public static int wfile(String tag, String msg) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 7, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, null, Log.getStackTraceString());
        return 0;
    }

    public static int wfile(String tag, Throwable t) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 7, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), null, Log.getStackTraceString(t), Log.getStackTraceString());
        return 0;
    }

    public static int wfile(String tag, String msg, Throwable t) {
        StackTraceElement ste = Log.getStackTrace();
        Log.log(tag, 7, ste.getFileName(), ste.getClassName(), ste.getMethodName(), ste.getLineNumber(), msg, Log.getStackTraceString(t), Log.getStackTraceString());
        return 0;
    }

    public static int println(int priority, String tag, String msg) {
        return android.util.Log.println((int)priority, (String)tag, (String)msg);
    }

    public static boolean isLoggable(String tag, int level) {
        return loggingLevel >= 0 && level >= loggingLevel;
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter writer = new StringWriter();
        try {
            ((Writer)writer).append(t.toString());
            ((Writer)writer).append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        t.printStackTrace(new PrintWriter(writer));
        return ((Object)writer).toString();
    }

    private static StackTraceElement getStackTrace() {
        StackTraceElement[] stackDump = Thread.currentThread().getStackTrace();
        if (stackDump != null && stackDump.length > 4) {
            return stackDump[4];
        }
        return EMPTY_STACK_TRACE_ELEMENT;
    }

    private static String getStackTraceString() {
        StringBuilder str = new StringBuilder();
        StackTraceElement[] stackDump = Thread.currentThread().getStackTrace();
        for (int i = 4; i < stackDump.length; ++i) {
            StackTraceElement ste = stackDump[i];
            if (str.length() > 0) {
                str.append('\n');
            }
            str.append("\t");
            str.append(ste.getClassName());
            str.append('.');
            str.append(ste.getMethodName());
            str.append('(');
            if (ste.isNativeMethod()) {
                str.append("Native method");
            } else {
                str.append(ste.getFileName());
                str.append(':');
                if (ste.getLineNumber() > 0) {
                    str.append(ste.getLineNumber());
                } else {
                    str.append("?");
                }
            }
            str.append(')');
        }
        return str.toString();
    }

    private static native void log(String var0, int var1, String var2, String var3, String var4, int var5, String var6, String var7, String var8);

    private static native int getLogLevel();
}

