/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.utils;

import com.skype.android.video.hw.utils.Log;

public class FrameRateController {
    private float tsDeltaTarget;
    private float targetFps;
    private long tsLast;
    private float tsError;
    boolean curFrameDropFlag;
    private boolean isInit = false;
    private static String simpleClassNameStatic = FrameRateController.class.getSimpleName();

    public FrameRateController(float targetFps) {
        this.Reset(targetFps, 0L, true);
    }

    public void Reset(float targetFps, long tsCurr, boolean resetTsLast) {
        this.targetFps = targetFps;
        this.tsDeltaTarget = 1000.0f / targetFps;
        if (resetTsLast) {
            this.tsLast = tsCurr;
            this.tsError = 0.0f;
            this.curFrameDropFlag = false;
        }
    }

    public float GetTargetFps() {
        return this.targetFps;
    }

    public boolean GetDropFlag(long tsCurr) {
        if (!this.isInit) {
            this.isInit = true;
            this.tsLast = tsCurr;
            this.curFrameDropFlag = false;
            this.tsError = 0.0f;
            return false;
        }
        boolean bl = this.curFrameDropFlag = tsCurr != this.tsLast;
        if (tsCurr < this.tsLast) {
            if (Long.signum(tsCurr) == -1) {
                this.tsLast = tsCurr;
            }
            return this.curFrameDropFlag;
        }
        float timePassed = (float)(tsCurr - this.tsLast) + this.tsError;
        if (this.tsDeltaTarget - 5.0f < timePassed) {
            this.curFrameDropFlag = false;
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassNameStatic + " timePassed " + timePassed + " tsDeltaTarget " + this.tsDeltaTarget + " tsError " + this.tsError);
        }
        return this.curFrameDropFlag;
    }

    public void Update(long tsCurr) {
        if (!this.curFrameDropFlag && tsCurr != this.tsLast) {
            float timePassed = tsCurr - this.tsLast;
            this.tsError += timePassed - this.tsDeltaTarget;
            if (this.tsError > 100.0f || this.tsError < -100.0f) {
                this.tsError = 0.0f;
            }
            this.tsLast = tsCurr;
        }
    }
}

