/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.format;

import java.io.Serializable;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolution
implements Comparable<Resolution>,
Serializable {
    private static final long serialVersionUID = 19636167696232418L;
    private static final Pattern SPLIT_REGEX = Pattern.compile("x");
    private final int width;
    private final int height;

    public Resolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Resolution(String resolution) {
        String[] dimensions = SPLIT_REGEX.split(resolution);
        this.width = Integer.parseInt(dimensions[0]);
        this.height = Integer.parseInt(dimensions[1]);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Resolution other = (Resolution)obj;
        return this.width == other.width && this.height == other.height;
    }

    @Override
    public int compareTo(Resolution another) {
        return this.width > another.width ? 1 : (this.width < another.width ? -1 : (this.height > another.height ? 1 : (this.height < another.height ? -1 : 0)));
    }
}

