/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.extension.encoder;

import com.skype.android.video.hw.codec.encoder.camera.VideoCameraEncoder;
import com.skype.android.video.hw.extension.encoder.AbstractVideoEncoderExtension;
import com.skype.android.video.hw.extension.encoder.VideoEncoderExtension;
import com.skype.android.video.hw.extension.encoder.VideoEncoderExtensionFactory;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.utils.DebugUtils;
import com.skype.android.video.hw.utils.EncoderAttributes;
import com.skype.android.video.hw.utils.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoCameraEncoderExtension
extends AbstractVideoEncoderExtension<VideoCameraEncoder> {
    protected VideoCameraEncoderExtension(int encoderIndex) {
        super(encoderIndex);
    }

    @Override
    protected VideoCameraEncoder doCreateEncoder(String encoderName) {
        return new VideoCameraEncoder(encoderName);
    }

    @Override
    protected void doCloseEncoder() {
        ((VideoCameraEncoder)this.getEncoder()).close();
    }

    @Override
    protected OutputFrame doEncodeFrame(long timeoutUs, long nativeFrameContext, long ts, boolean drainOnly) {
        return ((VideoCameraEncoder)this.getEncoder()).encode(timeoutUs);
    }

    public static VideoCameraEncoderExtension createStatic(int encoderIndex) {
        return new VideoCameraEncoderExtension(encoderIndex);
    }

    @Override
    public int init(String attr, boolean isReinitializing) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() called");
            Log.d("SLIQ", attr);
        }
        try {
            EncoderAttributes attributes = new EncoderAttributes(attr);
            boolean isFastAsyncMode = attributes.getInteger("android-fast-async-mode") != 0;
            Object userData = attributes.getPointer("java-object", null);
            return super.initInternal(attributes, isReinitializing, isFastAsyncMode, userData);
        }
        catch (EncoderAttributes.AttributeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Illegal attribute value", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_INCORRECT_PARAM");
            }
            return -9;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
    }

    public static class Factory
    implements VideoEncoderExtensionFactory {
        public VideoEncoderExtension create(int encoderIndex) {
            return new VideoCameraEncoderExtension(encoderIndex);
        }
    }
}

