/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec;

import android.os.IBinder;
import com.skype.android.jipc.inout.OutBoolean;
import com.skype.android.jipc.inout.OutInt32;
import com.skype.android.jipc.inout.OutMayBe;
import com.skype.android.jipc.inout.OutStatus;
import com.skype.android.jipc.omx.OmxFacade;
import com.skype.android.jipc.omx.OmxInventory;
import com.skype.android.jipc.omx.OmxObserver;
import com.skype.android.jipc.omx.data.ExtendedIndex;
import com.skype.android.jipc.omx.data.OmxStruct;
import com.skype.android.jipc.omx.data.SkypeExtendedIndex;
import com.skype.android.jipc.omx.data.config.BaseLayerPidConfig;
import com.skype.android.jipc.omx.data.config.FrameRateConfig;
import com.skype.android.jipc.omx.data.config.MarkLtrFrameConfig;
import com.skype.android.jipc.omx.data.config.QpConfig;
import com.skype.android.jipc.omx.data.config.TemporalLayerCountConfig;
import com.skype.android.jipc.omx.data.config.UseLtrFrameConfig;
import com.skype.android.jipc.omx.data.embedded.EncoderCap;
import com.skype.android.jipc.omx.data.embedded.EncoderSetting;
import com.skype.android.jipc.omx.data.param.AVCParam;
import com.skype.android.jipc.omx.data.param.BitrateParam;
import com.skype.android.jipc.omx.data.param.DecoderCapParam;
import com.skype.android.jipc.omx.data.param.DecoderSettingParam;
import com.skype.android.jipc.omx.data.param.DriverVerParam;
import com.skype.android.jipc.omx.data.param.EncoderCapParam;
import com.skype.android.jipc.omx.data.param.EncoderSettingParam;
import com.skype.android.jipc.omx.data.param.PortDefinitionParam;
import com.skype.android.jipc.omx.data.param.VideoPortFormatParam;
import com.skype.android.jipc.omx.enums.OmxVideo;
import com.skype.android.video.hw.HWFeatureSelectiveFields;
import com.skype.android.video.hw.codec.AbstractOmxWrapper;
import com.skype.android.video.hw.utils.CodecUtils;
import com.skype.android.video.hw.utils.Log;
import java.io.IOException;
import java.nio.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpcOmxWrapper
extends AbstractOmxWrapper {
    static final boolean checkConfigWritten = true;
    static final OutStatus UNKNOWN_ERROR = new OutStatus();
    private int ownNodeId = -1;
    private boolean hasEncCapability;
    private final IBinder omx = this.facade().getOMX();
    private final OmxObserver observer = OmxInventory.obtainObserver();
    private final ThreadLocal<Locals> tls = new ThreadLocal<Locals>(){

        @Override
        protected Locals initialValue() {
            return new Locals(IpcOmxWrapper.this.facade().refStatus());
        }
    };

    private OmxFacade facade() {
        return OmxInventory.obtainFacade();
    }

    private Locals locals() {
        return this.tls.get();
    }

    public IpcOmxWrapper(String codecName, String dummyComponentName) {
        super(codecName, dummyComponentName);
    }

    @Override
    protected int incrementAndGetNodeId() {
        int nodeId = this.allocateNode();
        if (nodeId != -1) {
            this.facade().freeNode(this.omx, nodeId, this.observer);
        }
        return nodeId;
    }

    @Override
    public int connectForQueriesOnly() {
        if (this.isNodeIdKnown()) {
            throw new IllegalStateException("Node already owned!");
        }
        this.ownNodeId = this.allocateNode();
        return this.ownNodeId;
    }

    private int allocateNode() {
        OutMayBe<Void, OutInt32> result = this.facade().allocateNode(this.omx, this.observer, this.dummyName);
        return result.status.isOk() ? ((OutInt32)result.value).value() : -1;
    }

    @Override
    protected int doSetQp(int nodeId, int qp) {
        QpConfig qpConfig = this.locals().qpConfig;
        qpConfig.port.set(1);
        qpConfig.qp.set(qp);
        return this.facade().setConfig(this.omx, nodeId, qpConfig).value();
    }

    @Override
    protected int doSetNumTempLayers(int nodeId, int numTempLayers) {
        TemporalLayerCountConfig tlc = this.locals().numTempLayers;
        tlc.port.set(1);
        tlc.tempLayerCount.set(numTempLayers);
        return this.facade().setConfig(this.omx, nodeId, tlc).value();
    }

    @Override
    protected int doSetBaseLayerPID(int nodeId, int baseLayerPID) {
        BaseLayerPidConfig blp = this.locals().blpConfig;
        blp.port.set(1);
        blp.tempLayerCount.set(baseLayerPID);
        return this.facade().setConfig(this.omx, nodeId, blp).value();
    }

    @Override
    protected int doMarkLtrFrame(int nodeId, int longTermFrameIdx) {
        MarkLtrFrameConfig blp = this.locals().markLtr;
        blp.port.set(1);
        blp.longTermFrame.set(longTermFrameIdx);
        return this.facade().setConfig(this.omx, nodeId, blp).value();
    }

    @Override
    protected int doUseLTRFrame(int nodeId, int useLTRFrameIdxBitMap) {
        UseLtrFrameConfig blp = this.locals().useLtr;
        blp.port.set(1);
        blp.useLtrFrameBitMap.set((short)useLTRFrameIdxBitMap);
        return this.facade().setConfig(this.omx, nodeId, blp).value();
    }

    @Override
    public int setRcFrameRate(float fps) {
        FrameRateConfig rc = this.locals().rcConfig;
        rc.port.set(0);
        rc.frameRate.set((int)(fps * 65536.0f));
        return this.facade().setConfig(this.omx, this.getNodeId(), rc).value();
    }

    @Override
    public int configureDecoderLowLatency() {
        DecoderSettingParam setting = this.locals().dsParam;
        setting.port.set(0);
        setting.stDecParam_bLowLatency.set(true);
        return this.setAndGetOmxParam((int)this.getNodeId(), setting, this.locals().dsCheck).status.value();
    }

    private <P extends OmxStruct> OutMayBe<Void, OutBoolean> setAndGetOmxParam(int nodeId, P value, P check) {
        OutMayBe<Void, OutBoolean> checkResult = this.locals().checkResult;
        OutStatus status = this.facade().setParameter(this.omx, nodeId, value);
        if (status.isOk()) {
            check.reset();
            this.facade().getParameter(this.omx, nodeId, check);
            if (status.isOk()) {
                boolean valid = value.equals(check);
                ((OutBoolean)checkResult.value).setDefaultValue(valid);
                if (valid) {
                    IpcOmxWrapper.info("SUCCESS: getParameter return OK, and setting did take effect");
                } else {
                    IpcOmxWrapper.info("FAIL: getParameter return OK, but setting did not take effect");
                }
            } else {
                IpcOmxWrapper.info("FAIL: getParameter returned " + status);
            }
        } else {
            IpcOmxWrapper.info("FAIL: setParameter returned " + status);
        }
        return checkResult;
    }

    private static void info(String log) {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", log);
        }
    }

    private static void warn(String log) {
        if (Log.isLoggable("SLIQ", 5)) {
            Log.w("SLIQ", log);
        }
    }

    private static void error(String log) {
        if (Log.isLoggable("SLIQ", 6)) {
            Log.e("SLIQ", log);
        }
    }

    OutStatus configureVideoPortFormat(int nodeId, String codecName, int port, int colorFormat, OmxVideo.OMX_VIDEO_CODINGTYPE compressionFormat) {
        OutStatus status;
        VideoPortFormatParam format = this.locals().pfParam;
        format.index.set(0);
        format.port.set(port);
        boolean foundFormat = false;
        IpcOmxWrapper.info(String.format("nodeId %d, codecName %s", nodeId, codecName));
        for (int i = 0; !foundFormat && i <= 100; ++i) {
            format.index.set(i);
            status = this.facade().getParameter(this.omx, nodeId, format);
            if (status.isOk()) {
                IpcOmxWrapper.info(String.format("colorFormat %d, format.eColorFormat %d, compressionFormat %s, format.eCompressionFormat %d", colorFormat, format.colorFormat.get(), compressionFormat, format.compressionFormat.get()));
                if ("OMX.TI.Video.encoder".equals(codecName)) {
                    if (colorFormat == format.colorFormat.get() && 0 == port) {
                        foundFormat = true;
                        continue;
                    }
                    if (format.compressionFormat.get() != compressionFormat.value() || 1 != port) continue;
                    foundFormat = true;
                    continue;
                }
                if (colorFormat != format.colorFormat.get() || compressionFormat.value() != format.compressionFormat.get()) continue;
                foundFormat = true;
                continue;
            }
            IpcOmxWrapper.warn(String.format("Error %s while querying OMX_IndexParamVideoPortFormat", status));
            return UNKNOWN_ERROR;
        }
        if (!foundFormat) {
            IpcOmxWrapper.warn(String.format("Encoder doesn't support colorFormat %d, compressionFormat %s", colorFormat, compressionFormat));
            return UNKNOWN_ERROR;
        }
        status = this.facade().setParameter(this.omx, nodeId, format);
        return status;
    }

    OutStatus configurePort(int nodeId, int portId, int width, int height, float frameRate, int colorFormat, OmxVideo.OMX_VIDEO_CODINGTYPE compressionFormat) {
        PortDefinitionParam portDefinition = this.locals().pdParam;
        portDefinition.port.set(portId);
        OutStatus status = this.facade().getParameter(this.omx, nodeId, portDefinition);
        if (status.isOk()) {
            portDefinition.format.frameWidth.set(width);
            portDefinition.format.frameHeight.set(height);
            portDefinition.format.stride.set(width);
            portDefinition.format.sliceHeight.set(height);
            portDefinition.format.frameRate.set(portId == 0 ? (int)(frameRate * 65536.0f) : 0);
            portDefinition.format.compression.set(compressionFormat);
            portDefinition.format.colorFormat.set(colorFormat);
            if (0 == portId) {
                portDefinition.bufferSize.set(portDefinition.format.stride.get() * portDefinition.format.sliceHeight.get() * 3 / 2);
            }
            status = this.facade().setParameter(this.omx, nodeId, portDefinition);
        }
        if (!status.isOk()) {
            IpcOmxWrapper.error(String.format("configurePort (%s) failed! Error %s", portId == 0 ? "input" : "output", status));
        }
        return status;
    }

    OutStatus setH264CodingTools(int nodeId, int profile, int level, float frameRate, int iFrameInterval, boolean useCabac, boolean useWeightedPrediction, int sliceSize) {
        AVCParam configH264 = this.locals().avcParam;
        configH264.port.set(1);
        OutStatus status = this.facade().getParameter(this.omx, nodeId, configH264);
        if (status.isOk()) {
            int pFrames = iFrameInterval < 0 ? -1 : (iFrameInterval == 0 ? 0 : (int)(frameRate * (float)iFrameInterval));
            configH264.nSliceHeaderSpacing.set(sliceSize);
            configH264.bUseHadamard.set(true);
            configH264.nRefFrames.set(1);
            configH264.nBFrames.set(0);
            configH264.nPFrames.set(pFrames);
            configH264.nRefIdx10ActiveMinus1.set(0);
            configH264.nRefIdx11ActiveMinus1.set(0);
            configH264.bEntropyCodingCABAC.set(useCabac);
            configH264.bWeightedPPrediction.set(useWeightedPrediction);
            configH264.bconstIpred.set(false);
            configH264.bDirect8x8Inference.set(false);
            configH264.bDirectSpatialTemporal.set(false);
            configH264.nCabacInitIdc.set(0);
            configH264.bEnableUEP.set(false);
            configH264.bEnableFMO.set(false);
            configH264.bEnableASO.set(false);
            configH264.bEnableRS.set(false);
            configH264.bFrameMBsOnly.set(true);
            configH264.bMBAFF.set(false);
            configH264.eLoopFilterMode.set(OmxVideo.OMX_VIDEO_AVCLOOPFILTERTYPE.OMX_VIDEO_AVCLoopFilterEnable);
            configH264.nAllowedPictureTypes.set(configH264.nPFrames.get() == 0 ? 1 : 3);
            configH264.eProfile.set(profile);
            configH264.eLevel.set(level);
            status = this.facade().setParameter(this.omx, nodeId, configH264);
        }
        return status;
    }

    OutStatus setEncodingMode(int nodeId, int refCount, int profile, int numTempLayers, int baseLayerPriorityId, OmxVideo.OMX_VIDEO_SliceControlMode sliceControlMode, boolean svcAlways) {
        int nLtrFrames = 0;
        if (this.hasEncCapability) {
            EncoderCapParam encCapability = this.locals().encCapParam;
            int maxLtrFramesCap = encCapability.cap.nMaxLTRFrames.get();
            if (encCapability.cap.nMaxRefFrames.get() > maxLtrFramesCap && maxLtrFramesCap > 0) {
                nLtrFrames = CodecUtils.clip(maxLtrFramesCap, 0, refCount - 1);
            }
        }
        EncoderSettingParam encSetting = this.locals().esParam;
        EncoderSettingParam encSettingCheck = this.locals().esCheck;
        EncoderSetting param = encSetting.stEncParam;
        EncoderSetting paramCheck = encSettingCheck.stEncParam;
        param.bUseExtendedProfile.set(false);
        if (profile == OmxVideo.OMX_VIDEO_AVCPROFILETYPE.OMX_VIDEO_AVCProfileBaseline.value()) {
            param.bUseExtendedProfile.set(true);
            param.eProfile.set(OmxVideo.OMX_VIDEO_EXTENSION_AVCPROFILETYPE.OMX_VIDEO_EXT_AVCProfileConstrainedBaseline);
        }
        if (profile == OmxVideo.OMX_VIDEO_AVCPROFILETYPE.OMX_VIDEO_AVCProfileHigh.value()) {
            param.bUseExtendedProfile.set(true);
            param.eProfile.set(OmxVideo.OMX_VIDEO_EXTENSION_AVCPROFILETYPE.OMX_VIDEO_EXT_AVCProfileConstrainedHigh);
        }
        param.bLowLatency.set(true);
        param.nLTRFrames.set(nLtrFrames);
        param.eSliceControlMode.set(sliceControlMode);
        param.nSarIndex.set(0);
        param.nSarWidth.set(0);
        param.nSarHeight.set(0);
        param.nMaxTemporalLayerCount.set(numTempLayers > 1 ? numTempLayers : (svcAlways ? 2 : 0));
        if (numTempLayers > 1 || svcAlways) {
            param.eHierarType.set(OmxVideo.OMX_VIDEO_HierarType.OMX_VIDEO_HierarType_P);
        }
        encSettingCheck = encSetting;
        OutMayBe<Void, OutBoolean> result = this.setAndGetOmxParam(nodeId, encSetting, encSettingCheck);
        OutStatus status = result.status;
        if (!((OutBoolean)result.value).isTrue()) {
            IpcOmxWrapper.info(String.format("Tried to set: \nbLowLatency %d, bUseExtendedProfile %d, eProfile %d, nLTRFrames %d, eSliceControlMode %d, nSarIndex %d, nSarWidth %d, nSarHight %d, nMaxTemporalLayerCount %d, eHierarType %d, bSequenceHeaderWithIDR %d", param.bLowLatency.get(), param.bUseExtendedProfile.get(), param.eProfile.get(), param.nLTRFrames.get(), param.eSliceControlMode.get(), param.nSarIndex.get(), param.nSarWidth.get(), param.nSarHeight.get(), param.nMaxTemporalLayerCount.get(), param.eHierarType.get(), param.bSequenceHeaderWithIDR.get()));
        }
        IpcOmxWrapper.info(String.format("setting return code: %s | nSize %d, nVersion %d, nPortIndex %d \nbLowLatency %d, bUseExtendedProfile %d, eProfile %d, nLTRFrames %d, eSliceControlMode %d, nSarIndex %d, nSarWidth %d, nSarHight %d, nMaxTemporalLayerCount %d, eHierarType %d, bSequenceHeaderWithIDR %d", status, encSetting.sizeHdr.get(), encSetting.version.get(), encSetting.port.get(), paramCheck.bLowLatency.get(), paramCheck.bUseExtendedProfile.get(), paramCheck.eProfile.get(), paramCheck.nLTRFrames.get(), paramCheck.eSliceControlMode.get(), paramCheck.nSarIndex.get(), paramCheck.nSarWidth.get(), paramCheck.nSarHeight.get(), paramCheck.nMaxTemporalLayerCount.get(), paramCheck.eHierarType.get(), paramCheck.bSequenceHeaderWithIDR.get()));
        if (numTempLayers > 1 || svcAlways) {
            this.setTemporalLayout(nodeId, numTempLayers, baseLayerPriorityId);
        }
        return status;
    }

    OutStatus setTemporalLayout(int nodeId, int numTempLayers, int baseLayerPriorityId) {
        IpcOmxWrapper.info(String.format("setTemporalLayout(totalLayers %d, baseLayerPID %d)", numTempLayers, baseLayerPriorityId));
        OutStatus refStatus = this.locals().status;
        refStatus.setDefaultValue(0);
        this.doSetNumTempLayers(nodeId, numTempLayers);
        if (refStatus.isOk()) {
            this.doSetBaseLayerPID(nodeId, baseLayerPriorityId);
        }
        return refStatus;
    }

    private OutStatus setBitrateAndRcMode(int nodeId, int bitrate, OmxVideo.OMX_VIDEO_CONTROLRATETYPE bitrateMode) {
        BitrateParam bitrateType = this.locals().bitrateParam;
        bitrateType.port.set(1);
        OutStatus status = this.facade().getParameter(this.omx, nodeId, bitrateType);
        if (status.isOk()) {
            bitrateType.controlRate.set(bitrateMode);
            bitrateType.bitrate.set(bitrate);
            status = this.facade().setParameter(this.omx, nodeId, bitrateType);
        }
        return status;
    }

    @Override
    protected int configureEncoder(int rcMode, int refCount, int numChannels, int baseLayerPriorityId, int minNumSlices, boolean svcAlways, int colorFormat, int width, int height, int bitrate, int frameRate, int iFrameInterval, int profile, int level, int hwMode) {
        int sliceSize;
        OutStatus status = this.locals().status;
        status.resetError();
        int nodeId = this.getNodeId();
        boolean useCabac = profile == OmxVideo.OMX_VIDEO_AVCPROFILETYPE.OMX_VIDEO_AVCProfileHigh.value();
        boolean useWeightedPrediction = false;
        int numTempLayers = numChannels;
        boolean hwModeSkypeExtension = HWFeatureSelectiveFields.Skype_OMX_Extension.isSet(hwMode);
        if (hwModeSkypeExtension) {
            this.getEncCapabilityBuffer();
            if (!this.hasEncCapability) {
                status.resetError();
            }
        }
        OmxVideo.OMX_VIDEO_CONTROLRATETYPE controlRateType = OmxVideo.OMX_VIDEO_CONTROLRATETYPE.OMX_Video_ControlRateConstantSkipFrames;
        if (rcMode == OmxVideo.ANDROID_RC.AR_AUTO.value() || rcMode == OmxVideo.ANDROID_RC.AR_SLIQ.value()) {
            if (hwModeSkypeExtension) {
                if (this.locals().drvVerIndex.getQueriedOnNodeId() == nodeId && this.isQpSupported()) {
                    controlRateType = OmxVideo.OMX_VIDEO_CONTROLRATETYPE.OMX_Video_ControlRateDisable;
                    IpcOmxWrapper.info("Sliq RC, set OMX_Video_ControlRateDisable");
                } else {
                    controlRateType = OmxVideo.OMX_VIDEO_CONTROLRATETYPE.OMX_Video_ControlRateConstant;
                    IpcOmxWrapper.info("Generic RC, set OMX_Video_ControlRateConstant");
                }
            } else {
                controlRateType = OmxVideo.OMX_VIDEO_CONTROLRATETYPE.OMX_Video_ControlRateConstant;
                IpcOmxWrapper.info("Generic RC, set OMX_Video_ControlRateConstant");
            }
        } else if (rcMode == OmxVideo.ANDROID_RC.AR_INTERNAL.value()) {
            controlRateType = OmxVideo.OMX_VIDEO_CONTROLRATETYPE.OMX_Video_ControlRateConstantSkipFrames;
            IpcOmxWrapper.info("HW internal RC, set OMX_Video_ControlRateConstantSkipFrames");
        } else if (rcMode == OmxVideo.ANDROID_RC.AR_GENERIC.value()) {
            controlRateType = OmxVideo.OMX_VIDEO_CONTROLRATETYPE.OMX_Video_ControlRateConstant;
            IpcOmxWrapper.info("Generic RC, set OMX_Video_ControlRateConstant");
        } else {
            IpcOmxWrapper.warn("invalid RC type");
        }
        boolean lower = true;
        int upper = 15;
        minNumSlices = CodecUtils.clip(minNumSlices, 1, 15);
        EncoderCap capability = this.hasEncCapability ? this.locals().encCapParam.cap : null;
        OmxVideo.OMX_VIDEO_SliceControlMode sliceControlMode = minNumSlices > 1 && capability != null && (capability.nSliceControlModesBM.get() & OmxVideo.OMX_VIDEO_SliceControlMode.OMX_VIDEO_SliceControlModeMB.value()) != 0 ? OmxVideo.OMX_VIDEO_SliceControlMode.OMX_VIDEO_SliceControlModeMB : OmxVideo.OMX_VIDEO_SliceControlMode.OMX_VIDEO_SliceControlModeNone;
        int n = sliceSize = minNumSlices > 1 && sliceControlMode == OmxVideo.OMX_VIDEO_SliceControlMode.OMX_VIDEO_SliceControlModeMB ? ((width + 15 >> 4) * (height + 15 >> 4) + minNumSlices - 1) / minNumSlices : 0;
        if (status.isOk() && (status = this.configureVideoPortFormat(nodeId, this.hwCodecName, 0, colorFormat, OmxVideo.OMX_VIDEO_CODINGTYPE.OMX_VIDEO_CodingUnused)).isOk()) {
            status = this.configurePort(nodeId, 0, width, height, frameRate, colorFormat, OmxVideo.OMX_VIDEO_CODINGTYPE.OMX_VIDEO_CodingUnused);
        }
        if (status.isOk() && (status = this.configureVideoPortFormat(nodeId, this.hwCodecName, 1, OmxVideo.OMX_COLOR_FORMATTYPE.OMX_COLOR_FormatUnused.value(), OmxVideo.OMX_VIDEO_CODINGTYPE.OMX_VIDEO_CodingAVC)).isOk()) {
            status = this.configurePort(nodeId, 1, width, height, frameRate, OmxVideo.OMX_COLOR_FORMATTYPE.OMX_COLOR_FormatUnused.value(), OmxVideo.OMX_VIDEO_CODINGTYPE.OMX_VIDEO_CodingAVC);
        }
        if (status.isOk() && (status = this.setH264CodingTools(nodeId, profile, level, frameRate, iFrameInterval, useCabac, false, sliceSize)).isOk()) {
            status = this.setBitrateAndRcMode(nodeId, bitrate, controlRateType);
        }
        if (this.hasEncCapability && status.isOk() && hwModeSkypeExtension) {
            this.setEncodingMode(nodeId, refCount, profile, numTempLayers, baseLayerPriorityId, sliceControlMode, svcAlways);
        }
        return status.value();
    }

    @Override
    protected int doQueryDriverVersion(int nodeId) {
        return this.doQueryDriverVersion(nodeId, false);
    }

    @Override
    protected int doQueryDriverVersionAndCheckVerSystem(int nodeId) {
        return this.doQueryDriverVersion(nodeId, true);
    }

    private int doQueryDriverVersion(int nodeId, boolean checkVersionSystem) {
        ExtendedIndex drvVerIndex = this.locals().drvVerIndex;
        drvVerIndex.queryValueOnce(this.facade(), this.omx, nodeId);
        if (drvVerIndex.isSupported()) {
            DriverVerParam driverParam = this.locals().driverVerParam;
            if (checkVersionSystem) {
                this.testOMXVersionControlOnDriverVersion(nodeId, driverParam);
            }
            driverParam.resetOmxVersion();
            driverParam.port.set(1);
            OutStatus status = this.facade().getParameter(this.omx, nodeId, driverParam);
            if (status.isOk()) {
                this.setDriverVersion(driverParam.driverVersion.get());
                return 1;
            }
        }
        return 0;
    }

    private void testOMXVersionControlOnDriverVersion(int nodeId, DriverVerParam driverParam) {
        driverParam.resetOmxVersion();
        int supportCount = 0;
        boolean trueVerSupported = false;
        for (int majorV = 1; majorV < 4; ++majorV) {
            for (int minorV = 0; minorV < 10; ++minorV) {
                driverParam.setOmxVersion(majorV, minorV);
                OutStatus status = this.facade().getParameter(this.omx, nodeId, driverParam);
                supportCount += status.isOk() ? 1 : 0;
                if (1 == majorV && 0 == minorV) {
                    trueVerSupported = status.isOk();
                }
                IpcOmxWrapper.info(String.format("OMX version %d.%d is%s supported, return status:%s", driverParam.getVersionMajor(), driverParam.getVersionMinor(), status.isOk() ? " " : " not", status));
            }
        }
        boolean success = trueVerSupported && 1 == supportCount;
        String diagnostic = String.format("Device supports %d OMX version(s), expected single version %d.%d, which is%s supported", supportCount, 1, 0, trueVerSupported ? " " : " not");
        if (success) {
            IpcOmxWrapper.info(diagnostic);
        } else {
            IpcOmxWrapper.error(diagnostic);
        }
        driverParam.resetOmxVersion();
    }

    @Override
    public boolean isQpSupported() {
        ExtendedIndex qpIndex = this.locals().qParamIndex;
        qpIndex.queryValueOnce(this.facade(), this.omx, this.getNodeId());
        return qpIndex.isSupported();
    }

    @Override
    public long getEncCapability() {
        throw new UnsupportedOperationException("This implementation returns a direct buffer");
    }

    @Override
    public long getDecCapability() {
        throw new UnsupportedOperationException("This implementation returns a direct buffer");
    }

    @Override
    public Buffer getEncCapabilityBuffer() {
        if (this.hasSkypeOmxExtension()) {
            boolean result;
            EncoderCapParam encoderCapParam = this.locals().encCapParam;
            this.hasEncCapability = result = this.facade().getParameter(this.omx, this.getNodeId(), encoderCapParam).isOk();
            return result ? encoderCapParam.asBuffer(true) : null;
        }
        this.hasEncCapability = false;
        return null;
    }

    @Override
    public Buffer getDecCapabilityBuffer() {
        DecoderCapParam decoderCapParam = this.locals().decCapParam;
        return this.facade().getParameter(this.omx, this.getNodeId(), decoderCapParam).isOk() ? decoderCapParam.asBuffer(true) : null;
    }

    @Override
    public boolean isNodeIdKnown() {
        return this.ownNodeId != -1 || super.isNodeIdKnown();
    }

    @Override
    public int getNodeId() {
        return this.ownNodeId != -1 ? this.ownNodeId : super.getNodeId();
    }

    @Override
    public void close() throws IOException {
        if (this.ownNodeId != -1) {
            this.facade().freeNode(this.omx, this.getNodeId(), this.observer);
            this.ownNodeId = -1;
        }
    }

    static {
        UNKNOWN_ERROR.setDefaultValue(0x800000);
    }

    private static class Locals {
        final OutStatus status;
        final ExtendedIndex encCapIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.encodercapability");
        final ExtendedIndex decCapIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.decodercapability");
        final ExtendedIndex qParamIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.qp");
        final ExtendedIndex lcConfig = new SkypeExtendedIndex("OMX.microsoft.skype.index.temporallayercount");
        final ExtendedIndex markLtrIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.markltrframe");
        final ExtendedIndex useLtrIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.useltrframe");
        final ExtendedIndex blpIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.basepid");
        final ExtendedIndex encSetIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.encodersetting");
        final ExtendedIndex decSetIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.decodersetting");
        final ExtendedIndex drvVerIndex = new SkypeExtendedIndex("OMX.microsoft.skype.index.driverversion");
        final BitrateParam bitrateParam = new BitrateParam();
        final EncoderCapParam encCapParam = new EncoderCapParam(this.encCapIndex);
        final DecoderCapParam decCapParam = new DecoderCapParam(this.decCapIndex);
        final QpConfig qpConfig = new QpConfig(this.qParamIndex);
        final TemporalLayerCountConfig numTempLayers = new TemporalLayerCountConfig(this.lcConfig);
        final MarkLtrFrameConfig markLtr = new MarkLtrFrameConfig(this.markLtrIndex);
        final UseLtrFrameConfig useLtr = new UseLtrFrameConfig(this.useLtrIndex);
        final FrameRateConfig rcConfig = new FrameRateConfig();
        final BaseLayerPidConfig blpConfig = new BaseLayerPidConfig(this.blpIndex);
        final DecoderSettingParam dsParam = new DecoderSettingParam(this.decSetIndex);
        final DecoderSettingParam dsCheck = new DecoderSettingParam(this.decSetIndex);
        final EncoderSettingParam esParam = new EncoderSettingParam(this.encSetIndex);
        final EncoderSettingParam esCheck = new EncoderSettingParam(this.encSetIndex);
        final DriverVerParam driverVerParam = new DriverVerParam(this.drvVerIndex);
        final PortDefinitionParam pdParam = new PortDefinitionParam();
        final VideoPortFormatParam pfParam = new VideoPortFormatParam();
        final AVCParam avcParam = new AVCParam();
        final OutBoolean check = new OutBoolean();
        final OutMayBe<Void, OutBoolean> checkResult;

        Locals(OutStatus status) {
            this.status = status;
            this.checkResult = new OutMayBe(this.status, this.check);
        }
    }
}

