/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.view.Surface;
import com.skype.android.video.hw.HWFeatureSelectiveFields;
import com.skype.android.video.hw.codec.IpcOmxWrapper;
import com.skype.android.video.hw.codec.OmxWrapper;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.frame.OutputFramePool;
import com.skype.android.video.hw.utils.CodecUtils;
import com.skype.android.video.hw.utils.Log;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;

public abstract class AbstractMediaCodec
implements Closeable {
    private static final int OUTPUT_FRAME_POOL_SIZE = 4;
    private final String simpleClassName = this.getClass().getSimpleName();
    protected final OutputFramePool outputFramePool;
    protected ByteBuffer[] outputBuffers;
    protected MediaFormat format;
    private boolean isOpen = true;
    private boolean isEncoder = true;
    protected boolean isTextureDecoder = false;
    private String extPrefix;
    protected OmxWrapper omxWrapper = null;
    protected boolean useQCExtension = false;
    protected boolean useQCDecoderExtension = false;
    protected boolean useQCAfterNougatExtension = false;
    protected boolean useQCAfterNougatDecoderExtension = false;
    protected MediaCodec mediaCodec;
    protected final MediaCodec.BufferInfo outputBufferInfo = new MediaCodec.BufferInfo();

    protected abstract void doConfigureMediaFormat(MediaFormat var1, VideoFormat var2);

    protected abstract void doConfigureDynamic(VideoFormat var1);

    protected abstract int doGetMediaCodecFlags();

    protected AbstractMediaCodec(String name, boolean isEncoder) {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Creating MediaCodec " + isEncoder + " by name " + name);
        }
        this.isEncoder = isEncoder;
        this.useQCExtension = isEncoder && CodecUtils.getHWMode().contains((Object)HWFeatureSelectiveFields.QC_OMX_Extension) && CodecUtils.getEncoderCapabilities(name).isQCExtensionSupported();
        this.useQCAfterNougatExtension = isEncoder && CodecUtils.getHWMode().contains((Object)HWFeatureSelectiveFields.QC_OMX_Extension) && CodecUtils.getEncoderCapabilities(name).isQCAfterNougatExtensionsSupported();
        this.useQCDecoderExtension = !isEncoder && CodecUtils.getDecoderCapabilities(name).isQCExtensionSupported();
        boolean bl = this.useQCAfterNougatDecoderExtension = !isEncoder && CodecUtils.getDecoderCapabilities(name).isQCAfterNougatExtensionsSupported();
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + " useQCExtension " + this.useQCExtension + " useQCAfterNougatExtension " + this.useQCAfterNougatExtension + " useQCDecoderExtension " + this.useQCDecoderExtension + " useQCAfterNougatDecoderExtension " + this.useQCAfterNougatDecoderExtension);
        }
        if (Build.VERSION.SDK_INT <= 25 && (!isEncoder || !this.useQCExtension && !this.useQCAfterNougatExtension && CodecUtils.getHWMode().contains((Object)HWFeatureSelectiveFields.Android_OMX))) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", this.simpleClassName + ": OMXwrapper path " + name);
            }
            this.omxWrapper = new IpcOmxWrapper(name, name);
            this.mediaCodec = this.omxWrapper.createTracked();
            if (this.omxWrapper.isNodeIdKnown() && Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", "!!! Got nodeId: " + this.omxWrapper.getNodeId());
            }
        } else {
            try {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", this.simpleClassName + ": MediaCodec path " + name);
                }
                this.mediaCodec = MediaCodec.createByCodecName((String)name);
                this.extPrefix = name.toLowerCase(Locale.ROOT).contains("qcom") ? "vendor.qti" : "vendor.rtc";
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.outputFramePool = new OutputFramePool(4, this.mediaCodec);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": " + this.mediaCodec + " by name " + name + " created");
        }
    }

    public OmxWrapper getOmxWrapper() {
        return this.omxWrapper;
    }

    public MediaFormat getMediaFormat() {
        return this.format;
    }

    public String getExtPrefix() {
        return this.extPrefix;
    }

    public Boolean isUseQCAfterNougatExtension() {
        return this.useQCAfterNougatExtension;
    }

    public void configure(Object userData, VideoFormat videoFormat, boolean testHwApiVersioning) {
        if (!this.isOpen) {
            throw new IllegalStateException("closed");
        }
        this.format = this.createMediaFormat(videoFormat);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Configuring " + this.mediaCodec + " with " + this.format.toString());
        }
        if (this.doGetMediaCodecFlags() == 0 && userData != null) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", this.simpleClassName + ": Configuring mediaCodec with Surface: " + (Surface)userData);
            }
            this.mediaCodec.configure(this.format, (Surface)userData, null, this.doGetMediaCodecFlags());
            this.isTextureDecoder = true;
            this.outputFramePool.setDecoderType(this.isTextureDecoder);
        } else {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", this.simpleClassName + ": Configuring mediaCodec without Surface");
            }
            this.mediaCodec.configure(this.format, null, null, this.doGetMediaCodecFlags());
        }
        if (!this.useQCExtension && !this.useQCAfterNougatExtension && this.omxWrapper != null && this.omxWrapper.isNodeIdKnown()) {
            if (testHwApiVersioning) {
                this.omxWrapper.queryDriverVersionAndCheckVerSystem();
            }
            if (this.isEncoder) {
                int ret = this.omxWrapper.configureEncoder(this.format, videoFormat.getRCMode().ordinal(), videoFormat.getRefCount(), videoFormat.getNumLayers(), videoFormat.getBaseLayerPriorityId(), videoFormat.getMinNumSlices(), videoFormat.getSvcAlways());
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", "configureEncoder returned " + ret);
                }
            } else if (!this.useQCDecoderExtension) {
                int ret = this.omxWrapper.configureDecoderLowLatency();
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", "configureDecoderLowLatency returned " + ret);
                }
            }
        }
    }

    public void configureDynamic(VideoFormat videoFormat) {
        this.doConfigureDynamic(videoFormat);
    }

    public void setReconfigFlag(boolean rec) {
        this.outputFramePool.setReconfigFlag(rec);
    }

    public void start() {
        if (!this.isOpen) {
            throw new IllegalStateException("closed");
        }
        if (Log.isLoggable("SLIQ", 5)) {
            Log.w("SLIQ", this.simpleClassName + ": Starting " + this.mediaCodec);
        }
        this.mediaCodec.start();
        this.outputBuffers = this.mediaCodec.getOutputBuffers();
    }

    public void stop() {
        block4: {
            if (!this.isOpen) {
                throw new IllegalStateException("closed");
            }
            if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", this.simpleClassName + ": Stopping " + this.mediaCodec);
            }
            try {
                this.mediaCodec.stop();
            }
            catch (Exception e) {
                if (!Log.isLoggable("SLIQ", 6)) break block4;
                Log.e("SLIQ", "Exception caught!", e);
            }
        }
    }

    public void close() {
        block6: {
            if (!this.isOpen) {
                throw new IllegalStateException("closed");
            }
            if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", this.simpleClassName + ": Releasing " + this.mediaCodec);
            }
            this.mediaCodec.release();
            if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", this.simpleClassName + ": Released " + this.mediaCodec);
            }
            try {
                if (this.omxWrapper != null) {
                    Log.i("SLIQ", this.simpleClassName + ": OMXWrapper Closing");
                    this.omxWrapper.close();
                }
                this.outputFramePool.close();
            }
            catch (IOException e) {
                if (!Log.isLoggable("SLIQ", 6)) break block6;
                Log.e("SLIQ", "Exception caught!", e);
            }
        }
        this.isOpen = false;
    }

    /*
     * Exception decompiling
     */
    protected OutputFrame drainCodec(long timeoutUs, boolean isGapFillerNalu) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean copyFrame(OutputFrame frame, int outputBufferIndex) {
        ByteBuffer data = null;
        if (!this.isTextureDecoder) {
            data = this.outputBuffers[outputBufferIndex];
        }
        if (data == null || this.outputBufferInfo.size <= 0) {
            return false;
        }
        frame.pushBuffer(outputBufferIndex, data, this.outputBufferInfo.offset, this.outputBufferInfo.size);
        return true;
    }

    protected boolean isOpen() {
        return this.isOpen;
    }

    private MediaFormat createMediaFormat(VideoFormat format) {
        int width = format.getResolution().getWidth();
        int height = format.getResolution().getHeight();
        int orgwidth = format.getOrgResolution().getWidth();
        int orgheight = format.getOrgResolution().getHeight();
        if (orgwidth == 0 && orgheight == 0) {
            orgwidth = width;
            orgheight = height;
        }
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)orgwidth, (int)orgheight);
        if (this.isEncoder && orgwidth > width && orgheight > height) {
            String strHeight;
            String strWidth;
            if (Build.VERSION.SDK_INT > 25) {
                strWidth = this.extPrefix + "-ext-down-scalar.output-width";
                strHeight = this.extPrefix + "-ext-down-scalar.output-height";
            } else {
                strWidth = "vt-down-scalar.output-width";
                strHeight = "vt-down-scalar.output-height";
            }
            mediaFormat.setInteger(strWidth, width);
            mediaFormat.setInteger(strHeight, height);
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", "Set input and output resolution: " + orgwidth + "x" + orgheight + " " + width + "x" + height);
            }
        }
        this.doConfigureMediaFormat(mediaFormat, format);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", "Created MediaFormat: " + mediaFormat.toString());
        }
        return mediaFormat;
    }
}

