/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc.omx.message;

import android.os.Build;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.skype.android.jipc.omx.message.OmxMessageData;
import com.skype.android.jipc.omx.message.OmxMessageType;

public class OmxMessage {
    private int nodeId;
    private ParcelFileDescriptor fence;
    private OmxMessageType type;
    private OmxMessageData data = new OmxMessageData();

    public int getNodeId() {
        return this.nodeId;
    }

    public ParcelFileDescriptor getFence() {
        return this.fence;
    }

    public OmxMessageType getType() {
        return this.type;
    }

    public OmxMessageData getData() {
        return this.data;
    }

    public static final int getSize() {
        return 8 + OmxMessage.getFenceSize() + OmxMessageType.getSize();
    }

    private static int getFenceSize() {
        return OmxMessage.hasFence() ? 4 : 0;
    }

    private static boolean hasFence() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public void fill(int nodeId, boolean hasFence, Parcel data) {
        this.nodeId = nodeId;
        this.fence = hasFence ? data.readFileDescriptor() : null;
        this.type = OmxMessageType.values()[data.readInt()];
        this.data.parse(data);
    }

    public void fill(int nodeId, Parcel data) {
        this.fill(nodeId, OmxMessage.hasFence(), data);
    }
}

