/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.mock;

import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManager;
import com.microsoft.dl.video.capture.api.CameraManagerFactory;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.capture.impl.mock.MockCamera;
import com.microsoft.dl.video.capture.impl.mock.MockCameraImpl;
import com.microsoft.dl.video.capture.impl.mock.MockCameraManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MockCameraManagerImpl
implements CameraManager,
MockCameraManager {
    private final Map<String, CameraCapabilities> capabilities = new HashMap<String, CameraCapabilities>();
    private final Map<String, MockCameraImpl> openCameras = new HashMap<String, MockCameraImpl>();
    private int maxOpenCameras;

    @Override
    public final String[] getCameraIds() {
        String[] ids = new String[this.capabilities.size()];
        this.capabilities.keySet().toArray(ids);
        return ids;
    }

    @Override
    public final Camera openCamera(String id) throws CaptureException {
        CameraCapabilities cap = this.capabilities.get(id);
        if (cap == null) {
            throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
        }
        if (this.openCameras.get(id) != null) {
            throw new CaptureException("Camera " + id + " is already open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
        }
        if (this.openCameras.size() >= this.maxOpenCameras) {
            throw new CaptureException("Can not open more than " + this.maxOpenCameras + " cameras", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
        }
        MockCameraImpl camera = new MockCameraImpl(cap);
        this.openCameras.put(id, camera);
        return camera;
    }

    @Override
    public final CameraCapabilities getCameraCapabilities(String id) throws CaptureException {
        CameraCapabilities cap = this.capabilities.get(id);
        if (cap == null) {
            throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
        }
        return cap.clone();
    }

    @Override
    public final StaticCameraCapabilities getStaticCameraCapabilities(String id) throws CaptureException {
        StaticCameraCapabilities cap = this.capabilities.get(id);
        if (cap == null) {
            throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
        }
        return cap.clone();
    }

    @Override
    public final void setMockCameraConfigs(Collection<CameraCapabilities> capabilities, int maxOpenCameras) {
        this.maxOpenCameras = maxOpenCameras;
        for (CameraCapabilities cap : capabilities) {
            this.capabilities.put(cap.getCameraId(), cap.clone());
        }
    }

    @Override
    public final MockCamera getOpenCamera(String id) {
        return this.openCameras.get(id);
    }

    @Override
    public void close() {
    }

    public static class Factory
    implements CameraManagerFactory {
        @Override
        public final CameraManager createCameraManager() {
            return new MockCameraManagerImpl();
        }
    }
}

