/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CameraManagerFactory;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.impl.real.impl.RealCameraManagerImpl;
import com.microsoft.dl.video.capture.impl.real.impl2.RealCamera2ManagerImpl;

public final class VideoPlatform {
    private VideoPlatform() {
    }

    public static synchronized void initialize(int useCameraImplVer) {
        block7: {
            Log.refreshMinLogLevelIfNeed();
            try {
                String str = VideoPlatform.getCameraManagerFactoryName();
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)("VideoPlatform::intialize " + str + " with useCameraImplVer: " + useCameraImplVer));
                }
                switch (useCameraImplVer) {
                    case 2: {
                        CameraManagerSingleton.setFactory(VideoPlatform.getCameraManagerFactory(CameraManagerFactoryType.REAL_CAMERA_v2));
                        break;
                    }
                    case 3: {
                        CameraManagerSingleton.setFactory(VideoPlatform.getCameraManagerFactory(CameraManagerFactoryType.REAL_CAMERA_X));
                        break;
                    }
                    default: {
                        CameraManagerSingleton.setFactory(VideoPlatform.getCameraManagerFactory(CameraManagerFactoryType.REAL_CAMERA_v1));
                        break;
                    }
                }
            }
            catch (CaptureException | RuntimeException e) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block7;
                Log.e((String)"Video", (String)"Exception caught ", (Throwable)e);
            }
        }
    }

    private static CameraManagerFactory getCameraManagerFactory(CameraManagerFactoryType type) throws CaptureException {
        switch (type) {
            case REAL_CAMERA_v1: {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)"CameraManagerFactory: REAL_CAMERA_v1");
                }
                return new RealCameraManagerImpl.Factory();
            }
            case REAL_CAMERA_v2: {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)"CameraManagerFactory: REAL_CAMERA_v2");
                }
                return new RealCamera2ManagerImpl.Factory();
            }
            case REAL_CAMERA_X: {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)"CameraManagerFactory: REAL_CAMERA_X");
                }
                try {
                    Class<?> cls = Class.forName("com.microsoft.dl.video.capture.impl.real.impl3.RealCameraXManagerImpl$Factory");
                    Object obj = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Log.i((String)"Video", (String)("CameraX camera manager factory: " + obj));
                    return (CameraManagerFactory)obj;
                }
                catch (Exception e) {
                    Log.e((String)"Video", (String)("CameraX implementation not found, falling back to Camera2: " + e));
                    return new RealCamera2ManagerImpl.Factory();
                }
            }
        }
        throw new CaptureException("Unknown CameraManagerFactoryType " + (Object)((Object)type), ErrorCode.ANDROID_CAMERA_MANAGER_INVALID_TYPE);
    }

    private static native String getCameraManagerFactoryName();

    private static enum CameraManagerFactoryType {
        REAL_CAMERA_v1,
        REAL_CAMERA_v2,
        REAL_CAMERA_X;

    }
}

