/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.media;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.microsoft.media.RtcPalConfig;
import com.microsoft.media.ifaddrs;
import com.skype.rt.RtContext;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;

public class NetworkPal
extends RtContext {
    private static final String TAG = "NetworkPal";
    private static ConnectivityManager m_conMan = null;

    public static boolean initialize(Context ctx) {
        if (ctx == null) {
            ctx = NetworkPal.getContext();
        }
        return (m_conMan = (ConnectivityManager)ctx.getSystemService("connectivity")) != null;
    }

    private static int getNetworkType() {
        NetworkInfo netInfo = m_conMan.getActiveNetworkInfo();
        if (netInfo != null) {
            return netInfo.getType();
        }
        return -1;
    }

    public static ifaddrs[] getNetworkInterfaceAddresses() {
        ifaddrs[] result;
        block6: {
            result = null;
            Enumeration<NetworkInterface> deviceIntfs = null;
            int index = -1;
            ArrayList<ifaddrs> resultArrayList = new ArrayList<ifaddrs>();
            try {
                deviceIntfs = NetworkInterface.getNetworkInterfaces();
                while (deviceIntfs != null && deviceIntfs.hasMoreElements()) {
                    NetworkInterface nwIntf = deviceIntfs.nextElement();
                    ++index;
                    try {
                        if (nwIntf.isLoopback() || !nwIntf.isUp()) continue;
                        for (InterfaceAddress intfAddr : nwIntf.getInterfaceAddresses()) {
                            Inet6Address inet6Addr;
                            InetAddress inetAddress = intfAddr.getAddress();
                            if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isAnyLocalAddress() || inetAddress instanceof Inet6Address && (inet6Addr = (Inet6Address)inetAddress).isIPv4CompatibleAddress()) continue;
                            ifaddrs addr = new ifaddrs(nwIntf.getName(), 0, inetAddress, intfAddr.getNetworkPrefixLength(), index, NetworkPal.getNetworkType());
                            resultArrayList.add(addr);
                            if (!RtcPalConfig.isLogcatEnabled()) continue;
                            Log.v((String)TAG, (String)String.format("addr=%s, siteLocal:%b, anyLocal:%b", addr.toString(), inetAddress.isSiteLocalAddress(), inetAddress.isLoopbackAddress()));
                        }
                    }
                    catch (SocketException socketException) {
                    }
                }
                result = resultArrayList.toArray(new ifaddrs[resultArrayList.size()]);
            }
            catch (SocketException e) {
                if (!RtcPalConfig.isLogcatEnabled()) break block6;
                Log.e((String)TAG, (String)"getNetworkInterfaceAddresses failed", (Throwable)e);
            }
        }
        return result;
    }
}

