/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.azure.android.communication.calling.DeviceManager;
import com.azure.android.communication.calling.Log;
import java.util.ArrayList;
import java.util.Random;

class VideoOrientationManager {
    private static final String TAG = "VideoOrientationManager";
    private static final Random random = new Random();
    private static VideoOrientationManager instance;
    private boolean isEnabled;
    private int displayOrientation = -1;
    private OrientationEventListener orientationEventListener;
    private final WindowManager windowManager;
    private DeviceManager deviceManager;
    private final ArrayList<OrientationChangedCallback> orientationChangedCallbacks;

    public static VideoOrientationManager getInstance(Context context) {
        if (instance == null) {
            instance = new VideoOrientationManager(context);
        }
        return instance;
    }

    private VideoOrientationManager(Context context) {
        this.windowManager = (WindowManager)context.getSystemService("window");
        if (this.windowManager != null) {
            this.orientationEventListener = new OrientationEventListener(context, 3){

                public void onOrientationChanged(int orientation) {
                    int causeId = random.nextInt();
                    if (orientation != VideoOrientationManager.this.displayOrientation) {
                        Log.debug6(VideoOrientationManager.TAG, "onOrientationChanged %d causeId: 0x%08x", orientation, causeId);
                        VideoOrientationManager.this.updateVideoRotation(causeId);
                    }
                }
            };
        } else {
            Log.error(TAG, "Could not get WindowManager for WINDOW_SERVICE", new Object[0]);
        }
        this.orientationChangedCallbacks = new ArrayList();
    }

    public void addCallback(OrientationChangedCallback orientationChangedCallback) {
        this.orientationChangedCallbacks.add(orientationChangedCallback);
    }

    public void removeCallback(OrientationChangedCallback orientationChangedCallback) {
        this.orientationChangedCallbacks.remove(orientationChangedCallback);
    }

    public void start() {
        int causeId = random.nextInt();
        if (this.orientationEventListener != null && this.orientationEventListener.canDetectOrientation()) {
            if (!this.isEnabled) {
                this.orientationEventListener.enable();
                Log.debug1(TAG, "enable orientation event listener", new Object[0]);
                this.isEnabled = true;
                this.fireOrientationChangedCallback(causeId);
            } else {
                Log.debug1(TAG, "Orientation event listener already enabled causeId: 0x%08x", causeId);
            }
        } else {
            Log.warn(TAG, "can not detect orientation events causeId: 0x%08x", causeId);
        }
    }

    public void stop() {
        if (this.isEnabled && this.orientationChangedCallbacks.isEmpty()) {
            this.orientationEventListener.disable();
            this.isEnabled = false;
            Log.debug1(TAG, "enable orientation event listener", new Object[0]);
        }
    }

    private void fireOrientationChangedCallback(int causeId) {
        for (OrientationChangedCallback callback : this.orientationChangedCallbacks) {
            callback.onOrientationChanged(causeId);
        }
    }

    private void updateVideoRotation(int causeId) {
        int rotation = this.windowManager.getDefaultDisplay().getRotation() * 90;
        if (this.displayOrientation == rotation) {
            return;
        }
        Log.debug1(TAG, "updateVideoRotation %d causeId: 0x%08x", rotation, causeId);
        this.displayOrientation = rotation;
        if (this.deviceManager != null) {
            this.deviceManager.setDeviceOrientation((360 - rotation) % 360);
        }
        this.fireOrientationChangedCallback(causeId);
    }

    void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public int getDisplayOrientation() {
        return this.displayOrientation;
    }

    public static interface OrientationChangedCallback {
        public void onOrientationChanged(int var1);
    }
}

