/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.AddPhoneNumberOptions;
import com.azure.android.communication.calling.CallDirection;
import com.azure.android.communication.calling.CallEndReason;
import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.CallFeatureFactory;
import com.azure.android.communication.calling.CallState;
import com.azure.android.communication.calling.CallerInfo;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.DtmfTone;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.HangUpOptions;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.LocalVideoStreamsUpdatedEvent;
import com.azure.android.communication.calling.LocalVideoStreamsUpdatedListener;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ParticipantsUpdatedEvent;
import com.azure.android.communication.calling.ParticipantsUpdatedListener;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import com.azure.android.communication.calling.RecordingCallFeature;
import com.azure.android.communication.calling.RemoteParticipant;
import com.azure.android.communication.calling.TranscriptionCallFeature;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class Call {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;
    private List<PropertyChangedListener> OnIdChangedListeners = new ArrayList<PropertyChangedListener>();
    private List<PropertyChangedListener> OnStateChangedListeners = new ArrayList<PropertyChangedListener>();
    private List<ParticipantsUpdatedListener> OnRemoteParticipantsUpdatedListeners = new ArrayList<ParticipantsUpdatedListener>();
    private List<LocalVideoStreamsUpdatedListener> OnLocalVideoStreamsUpdatedListeners = new ArrayList<LocalVideoStreamsUpdatedListener>();
    private List<PropertyChangedListener> OnIsMutedChangedListeners = new ArrayList<PropertyChangedListener>();

    Call(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    Call(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_release(this.handle));
        this.handle = 0L;
    }

    public List<RemoteParticipant> getRemoteParticipants() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_remote_participants(this.handle, result, result_length));
        ArrayList<RemoteParticipant> resultList = new ArrayList<RemoteParticipant>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(RemoteParticipant.getInstance(resultArray[i], true));
        }
        List<RemoteParticipant> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public String getId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_id(this.handle, result));
        return (String)result.value;
    }

    public CallState getState() {
        Out<CallState> result = new Out<CallState>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_state(this.handle, result));
        return (CallState)((Object)result.value);
    }

    public CallEndReason getCallEndReason() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_call_end_reason(this.handle, result_handle));
        CallEndReason result_object = (Long)result_handle.value != 0L ? CallEndReason.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallDirection getDirection() {
        Out<CallDirection> result = new Out<CallDirection>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_direction(this.handle, result));
        return (CallDirection)((Object)result.value);
    }

    public boolean isMuted() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_is_muted(this.handle, result));
        return (Boolean)result.value;
    }

    public CallerInfo getCallerInfo() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_caller_info(this.handle, result_handle));
        CallerInfo result_object = (Long)result_handle.value != 0L ? CallerInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public List<LocalVideoStream> getLocalVideoStreams() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_local_video_streams(this.handle, result, result_length));
        ArrayList<LocalVideoStream> resultList = new ArrayList<LocalVideoStream>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(LocalVideoStream.getInstance(resultArray[i], true));
        }
        List<LocalVideoStream> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private CallFeature getRecordingCallFeature() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_recording_call_feature(this.handle, result_handle));
        CallFeature result_object = (Long)result_handle.value != 0L ? Factories.CallFeatureFactory((Long)result_handle.value, true) : null;
        return result_object;
    }

    private CallFeature getTranscriptionCallFeature() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_get_transcription_call_feature(this.handle, result_handle));
        CallFeature result_object = (Long)result_handle.value != 0L ? Factories.CallFeatureFactory((Long)result_handle.value, true) : null;
        return result_object;
    }

    private static void OnIdChangedStaticHandler(long cookie, long args) {
        Call instance = Call.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnIdChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnIdChangedListener(PropertyChangedListener listener) {
        this.OnIdChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIdChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_id_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIdChangedListener(PropertyChangedListener listener) {
        this.OnIdChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIdChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_id_changed(this.handle, 0L, null));
        }
    }

    private static void OnStateChangedStaticHandler(long cookie, long args) {
        Call instance = Call.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnStateChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnStateChangedListener(PropertyChangedListener listener) {
        this.OnStateChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnStateChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_state_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnStateChangedListener(PropertyChangedListener listener) {
        this.OnStateChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnStateChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_state_changed(this.handle, 0L, null));
        }
    }

    private static void OnRemoteParticipantsUpdatedStaticHandler(long cookie, long args) {
        Call instance = Call.getInstance(cookie);
        if (instance != null) {
            ParticipantsUpdatedEvent args_converted = args != 0L ? ParticipantsUpdatedEvent.getInstance(args, false) : null;
            for (ParticipantsUpdatedListener listener : instance.OnRemoteParticipantsUpdatedListeners) {
                listener.onParticipantsUpdated(args_converted);
            }
        }
    }

    public void addOnRemoteParticipantsUpdatedListener(ParticipantsUpdatedListener listener) {
        this.OnRemoteParticipantsUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnRemoteParticipantsUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_remote_participants_updated(this.handle, this.getHandle(), this));
    }

    public void removeOnRemoteParticipantsUpdatedListener(ParticipantsUpdatedListener listener) {
        this.OnRemoteParticipantsUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnRemoteParticipantsUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_remote_participants_updated(this.handle, 0L, null));
        }
    }

    private static void OnLocalVideoStreamsUpdatedStaticHandler(long cookie, long args) {
        Call instance = Call.getInstance(cookie);
        if (instance != null) {
            LocalVideoStreamsUpdatedEvent args_converted = args != 0L ? LocalVideoStreamsUpdatedEvent.getInstance(args, false) : null;
            for (LocalVideoStreamsUpdatedListener listener : instance.OnLocalVideoStreamsUpdatedListeners) {
                listener.onLocalVideoStreamsUpdated(args_converted);
            }
        }
    }

    public void addOnLocalVideoStreamsUpdatedListener(LocalVideoStreamsUpdatedListener listener) {
        this.OnLocalVideoStreamsUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnLocalVideoStreamsUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_local_video_streams_updated(this.handle, this.getHandle(), this));
    }

    public void removeOnLocalVideoStreamsUpdatedListener(LocalVideoStreamsUpdatedListener listener) {
        this.OnLocalVideoStreamsUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnLocalVideoStreamsUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_local_video_streams_updated(this.handle, 0L, null));
        }
    }

    private static void OnIsMutedChangedStaticHandler(long cookie, long args) {
        Call instance = Call.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnIsMutedChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnIsMutedChangedListener(PropertyChangedListener listener) {
        this.OnIsMutedChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsMutedChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_is_muted_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsMutedChangedListener(PropertyChangedListener listener) {
        this.OnIsMutedChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsMutedChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_set_on_is_muted_changed(this.handle, 0L, null));
        }
    }

    private CompletableFuture<Void> muteInternal() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_mute_internal(handle));
            }
        }, (Executor)executor);
    }

    private CompletableFuture<Void> unmuteInternal() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_unmute_internal(handle));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> sendDtmf(final DtmfTone tone) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_send_dtmf(handle, tone));
            }
        }, (Executor)executor);
    }

    private CompletableFuture<Void> startVideoInternal(final LocalVideoStream stream) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long stream_converted = stream != null ? stream.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_start_video_internal(handle, stream_converted));
            }
        }, (Executor)executor);
    }

    private CompletableFuture<Void> stopVideoInternal(final LocalVideoStream stream) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long stream_converted = stream != null ? stream.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_stop_video_internal(handle, stream_converted));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> hangUp(final HangUpOptions options) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long options_converted = options != null ? options.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_hang_up(handle, options_converted));
            }
        }, (Executor)executor);
    }

    private RemoteParticipant addParticipant(String participant) {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_add_participant_string_participant(this.handle, participant, result_handle));
        RemoteParticipant result_object = (Long)result_handle.value != 0L ? RemoteParticipant.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    private RemoteParticipant addParticipant(String participant, AddPhoneNumberOptions options) {
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_add_participant_string_participant_add_phone_number_options_options(this.handle, participant, options_converted, result_handle));
        RemoteParticipant result_object = (Long)result_handle.value != 0L ? RemoteParticipant.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CompletableFuture<Void> removeParticipant(final RemoteParticipant participant) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long participant_converted = participant != null ? participant.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_remove_participant(handle, participant_converted));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> hold() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_hold(handle));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> resume() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_resume(handle));
            }
        }, (Executor)executor);
    }

    static Call getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.Call, Call.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.Call, Call.class, false);
    }

    private static Call getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.Call, Call.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIdChanged")) {
            this.addOnIdChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnStateChanged")) {
            this.addOnStateChangedListener((PropertyChangedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnRemoteParticipantsUpdated")) {
            this.addOnRemoteParticipantsUpdatedListener((ParticipantsUpdatedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnLocalVideoStreamsUpdated")) {
            this.addOnLocalVideoStreamsUpdatedListener((LocalVideoStreamsUpdatedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsMutedChanged")) {
            this.addOnIsMutedChangedListener((PropertyChangedListener)eventListener);
        }
    }

    public RemoteParticipant addParticipant(CommunicationIdentifier participant) {
        String participantString = IdentifierHelpers.toMRI(participant);
        return this.addParticipant(participantString);
    }

    public RemoteParticipant addParticipant(PhoneNumberIdentifier participant, AddPhoneNumberOptions addPhoneNumberOptions) {
        String participantString = IdentifierHelpers.toMRI((CommunicationIdentifier)participant);
        return this.addParticipant(participantString, addPhoneNumberOptions);
    }

    public CompletableFuture<Void> hangUp() {
        return this.hangUp(new HangUpOptions());
    }

    public CompletableFuture<Void> mute(Context context) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, true, false);
        return this.muteInternal();
    }

    public CompletableFuture<Void> unmute(Context context) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, true, false);
        return this.unmuteInternal();
    }

    public CompletableFuture<Void> startVideo(Context context, LocalVideoStream stream) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, false, true);
        return this.startVideoInternal(stream);
    }

    public CompletableFuture<Void> stopVideo(Context context, LocalVideoStream stream) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, false, true);
        return this.stopVideoInternal(stream);
    }

    public <TCallFeature extends CallFeature> TCallFeature feature(CallFeatureFactory<TCallFeature> factory) {
        return this.feature(factory.getCallFeatureImpl());
    }

    private <TCallFeature extends CallFeature> TCallFeature feature(Class<TCallFeature> featureClass) {
        if (featureClass == RecordingCallFeature.class) {
            return (TCallFeature)this.getRecordingCallFeature();
        }
        if (featureClass == TranscriptionCallFeature.class) {
            return (TCallFeature)this.getTranscriptionCallFeature();
        }
        throw new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, "Call feature extension not found");
    }
}

