/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.utils;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.skype.android.video.hw.utils.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;

public class DummyMediaCodec
extends MediaCodec.Callback {
    public final CountDownLatch callbackCountDown = new CountDownLatch(1);
    private static final int BITRATE = 2000000;
    private static final int FRAME_RATE = 30;
    private static final int IFRAME_INTERVAL = 1;
    private static final int ExynosDecoderDriver = 180315;
    private MediaCodec mEnc;
    private MediaCodec mDec;
    private boolean mDecConfigured;
    private boolean mIsEncoderOnly;
    private HandlerThread callbackThread;
    private Handler callbackhandler;
    private MediaFormat mInputFormat;
    public MediaFormat mEncOutputFormat = null;
    public MediaFormat mDecOutputFormat = null;
    private long pts = 0L;
    private long mInFrameCount = 0L;
    private long mOutFrameCount = 0L;
    private boolean mDone = false;
    private String extPrefix;
    private boolean mIsExynos;
    private static final String KEY_ENC_VER = "-ext-enc-caps-vt-driver-version.number";
    private static final String KEY_ENC_TLYER = "-ext-enc-caps-temporal-layers.max-p-count";
    private static final String KEY_ENC_MAXLTR = "-ext-enc-caps-ltr.max-count";
    private static final String KEY_ENC_MAXDS = "-ext-enc-caps-preprocess.max-downscale-factor";
    private static final String KEY_ENC_ROT = "-ext-enc-caps-preprocess.rotation";
    private static final String KEY_DEC_VER = "-ext-dec-caps-vt-driver-version.number";

    DummyMediaCodec(boolean isEncoder, boolean isExynos) {
        this.mIsEncoderOnly = isEncoder;
        this.mIsExynos = isExynos;
    }

    public void init(int width, int height, String prefix) throws Exception {
        Log.d("SLIQ", "Build: BOARD=" + Build.BOARD);
        Log.d("SLIQ", "Build: Device=" + Build.DEVICE);
        Log.d("SLIQ", "Build: PROD=" + Build.PRODUCT);
        Log.d("SLIQ", "init encoder");
        MediaFormat encFormat = this.mInputFormat == null ? MediaFormat.createVideoFormat((String)"video/avc", (int)width, (int)height) : MediaFormat.createVideoFormat((String)"video/avc", (int)this.mInputFormat.getInteger("width"), (int)this.mInputFormat.getInteger("height"));
        encFormat.setInteger("bitrate", 2000000);
        int fps = 30;
        if (this.mInputFormat != null) {
            fps = this.mInputFormat.getInteger("frame-rate");
        }
        encFormat.setInteger("frame-rate", fps);
        encFormat.setInteger("i-frame-interval", 1);
        encFormat.setInteger("color-format", 21);
        this.extPrefix = prefix;
        encFormat.setInteger(this.extPrefix + KEY_ENC_VER, 0);
        encFormat.setInteger(this.extPrefix + KEY_ENC_TLYER, 0);
        encFormat.setInteger(this.extPrefix + KEY_ENC_MAXLTR, 0);
        encFormat.setInteger(this.extPrefix + KEY_ENC_MAXDS, 0);
        encFormat.setInteger(this.extPrefix + KEY_ENC_ROT, 0);
        Log.d("SLIQ", "Encoder format : " + this.mInputFormat);
        this.mEnc = MediaCodec.createEncoderByType((String)"video/avc");
        this.callbackThread = new HandlerThread("MediaCodecCallbackThread");
        this.callbackThread.start();
        this.callbackhandler = new Handler(this.callbackThread.getLooper());
        this.mEnc.setCallback((MediaCodec.Callback)this, this.callbackhandler);
        Log.d("SLIQ", "configure encoder");
        this.mEnc.configure(encFormat, null, null, 1);
        Log.d("SLIQ", "configure encoder done");
        this.mEncOutputFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)width, (int)height);
        this.mDec = MediaCodec.createDecoderByType((String)"video/avc");
        this.mDecConfigured = false;
    }

    public void start() {
        Log.d("SLIQ", "start encoder");
        this.mEnc.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stop() {
        if (this.mEnc != null) {
            MediaCodec mediaCodec = this.mEnc;
            synchronized (mediaCodec) {
                try {
                    Log.d("SLIQ", "stopping encoder");
                    this.mEnc.stop();
                    this.mEnc.release();
                    this.mEnc = null;
                    Log.d("SLIQ", "stopped encoder");
                    this.callbackThread.quitSafely();
                    this.callbackThread.join();
                }
                catch (Exception e) {
                    Log.d("SLIQ", "Exception caught: " + e);
                }
            }
        }
    }

    public void stop() {
        this.mDone = true;
        if (this.mOutFrameCount == this.mInFrameCount) {
            this._stop();
        }
    }

    public void onInputBufferAvailable(MediaCodec codec, int index) {
        if (this.mDone) {
            return;
        }
        ByteBuffer inBuf = this.mEnc.getInputBuffer(index);
        this.mEnc.queueInputBuffer(index, 0, inBuf.capacity(), this.pts, 0);
        Log.d("SLIQ", "input: TS=" + this.pts + " size=" + inBuf.capacity());
        ++this.mInFrameCount;
        this.pts += 33000L;
        if (this.mDecConfigured) {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int status = this.mDec.dequeueOutputBuffer(info, 10000L);
            if (status == -2) {
                this.mDecOutputFormat = this.mDec.getOutputFormat();
                Log.d("SLIQ", this.mIsExynos + " " + Build.VERSION.SDK_INT + " " + !this.mDecOutputFormat.containsKey(this.extPrefix + KEY_ENC_VER) + " " + !this.mDecOutputFormat.containsKey(this.extPrefix + KEY_DEC_VER));
                if (!(!this.mIsExynos || Build.VERSION.SDK_INT != 26 && Build.VERSION.SDK_INT != 27 || this.mDecOutputFormat.containsKey(this.extPrefix + KEY_ENC_VER) || this.mDecOutputFormat.containsKey(this.extPrefix + KEY_DEC_VER))) {
                    Log.i("SLIQ", "Exynos decoder workaround, manually set version number");
                    this.mDecOutputFormat.setInteger(this.extPrefix + KEY_DEC_VER, 180315);
                }
                this.callbackCountDown.countDown();
                Log.d("SLIQ", "Decoder: output format = " + this.mDecOutputFormat);
                Log.d("SLIQ", "stopping decoder");
                this.mDec.stop();
                this.mDec.release();
                Log.d("SLIQ", "stopped decoder");
                this.mDec = null;
                this.mDecConfigured = false;
                this.stop();
            } else if (status > 0) {
                Log.d("SLIQ", "Decoder: got output");
                this.mDec.releaseOutputBuffer(status, false);
            }
        }
    }

    public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
        int bufId;
        Log.d("SLIQ", "output: TS=" + info.presentationTimeUs + " flags=" + info.flags + " len=" + info.size);
        ByteBuffer outBuf = this.mEnc.getOutputBuffer(index);
        if (!this.mIsEncoderOnly && this.mDecConfigured && (info.flags & 2) == 0 && (bufId = this.mDec.dequeueInputBuffer(10L)) >= 0) {
            ByteBuffer inBuf = this.mDec.getInputBuffer(bufId);
            Log.d("SLIQ", "Decoder: got input");
            inBuf.clear();
            inBuf.put(outBuf);
            this.mDec.queueInputBuffer(bufId, 0, info.size, info.presentationTimeUs, info.flags);
            Log.d("SLIQ", "Decoder: queued input ts=" + info.presentationTimeUs + " len=" + info.size);
        }
        this.mEnc.releaseOutputBuffer(index, false);
        ++this.mOutFrameCount;
        if (this.mDone && this.mOutFrameCount == this.mInFrameCount) {
            this._stop();
        }
    }

    public void onError(MediaCodec codec, MediaCodec.CodecException e) {
        Log.e("SLIQ", "ERROR : " + e.toString());
        this.callbackCountDown.countDown();
    }

    public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
        this.mEncOutputFormat = format;
        Log.d("SLIQ", "enc output format : " + format);
        if (!this.mIsEncoderOnly) {
            format.setInteger(this.extPrefix + "-ext-dec-picture-order.enable", 1);
            format.setInteger(this.extPrefix + "-ext-dec-low-latency.enable", 1);
            format.setInteger(this.extPrefix + KEY_DEC_VER, 0);
            if (this.mIsExynos && (Build.VERSION.SDK_INT == 26 || Build.VERSION.SDK_INT == 27)) {
                format.setInteger(this.extPrefix + KEY_ENC_VER, 0);
            }
            this.mDec.configure(format, null, null, 0);
            this.mDec.start();
            this.mDecConfigured = true;
            Log.d("SLIQ", "Decoder: configured");
        } else {
            this.mDone = true;
            this.callbackCountDown.countDown();
        }
    }
}

