/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.extension.encoder;

import android.view.Surface;
import com.skype.android.video.hw.codec.encoder.camera.SurfaceObserver;
import com.skype.android.video.hw.codec.encoder.camera.VideoTextureEncoder;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerException;
import com.skype.android.video.hw.extension.encoder.AbstractVideoEncoderExtension;
import com.skype.android.video.hw.extension.encoder.VideoEncoderExtension;
import com.skype.android.video.hw.extension.encoder.VideoEncoderExtensionFactory;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.utils.DebugUtils;
import com.skype.android.video.hw.utils.EncoderAttributes;
import com.skype.android.video.hw.utils.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoTextureEncoderExtension
extends AbstractVideoEncoderExtension<VideoTextureEncoder> {
    private Surface mInputSurface;
    private Resolution mResolution;
    private boolean mFirstFrame = true;
    private long nativeAid = 0L;
    private final String simpleClassName = this.getClass().getSimpleName();

    public static native long createNativeAid();

    public static native void destroyNativeAid(long var0);

    public static native void fillInputFrameSurface(long var0, long var2, Surface var4, int var5, int var6, boolean var7);

    protected VideoTextureEncoderExtension(int encoderIndex) {
        super(encoderIndex);
    }

    @Override
    protected VideoTextureEncoder doCreateEncoder(String encoderName) {
        Log.i("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called: " + this.mInputSurface + " at " + this.mResolution);
        this.nativeAid = VideoTextureEncoderExtension.createNativeAid();
        return new VideoTextureEncoder(encoderName, new SurfaceObserver(){

            public void attachSurface(Object surface, Resolution resolution) {
                VideoTextureEncoderExtension.this.mInputSurface = (Surface)surface;
                VideoTextureEncoderExtension.this.mResolution = resolution;
                VideoTextureEncoderExtension.this.mFirstFrame = true;
                Log.i("SLIQ", VideoTextureEncoderExtension.this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called: " + VideoTextureEncoderExtension.this.mInputSurface + " at " + VideoTextureEncoderExtension.this.mResolution);
            }

            public void detachSurface() {
                Log.i("SLIQ", VideoTextureEncoderExtension.this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
            }

            public void setTargetFrameRate(float fps) {
            }

            public float getTargetFrameRate() {
                return 30.0f;
            }

            public boolean pushFrame() throws CapturerException {
                return true;
            }
        });
    }

    @Override
    protected void doCloseEncoder() {
        ((VideoTextureEncoder)this.getEncoder()).close();
        VideoTextureEncoderExtension.destroyNativeAid(this.nativeAid);
    }

    @Override
    protected OutputFrame doEncodeFrame(long timeoutUs, long nativeFrameContext, long ts, boolean drainOnly) {
        if (this.mFirstFrame) {
            Log.i("SLIQ", this.simpleClassName + ": doEncodeFrame");
        }
        if (!drainOnly) {
            VideoTextureEncoderExtension.fillInputFrameSurface(this.nativeAid, nativeFrameContext, this.mInputSurface, this.mResolution.getWidth(), this.mResolution.getHeight(), this.mFirstFrame);
            this.mFirstFrame = false;
        }
        return ((VideoTextureEncoder)this.getEncoder()).encode(timeoutUs);
    }

    public static VideoTextureEncoderExtension createStatic(int encoderIndex) {
        return new VideoTextureEncoderExtension(encoderIndex);
    }

    @Override
    public int init(String attr, boolean isReinitializing) {
        Log.i("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called: isReinitializing " + isReinitializing);
        Log.i("SLIQ", attr);
        try {
            EncoderAttributes attributes = new EncoderAttributes(attr);
            boolean isFastAsyncMode = attributes.getInteger("android-fast-async-mode") != 0;
            Object userData = attributes.getPointer("java-object", null);
            return super.initInternal(attributes, isReinitializing, isFastAsyncMode, userData);
        }
        catch (EncoderAttributes.AttributeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Illegal attribute value", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_INCORRECT_PARAM");
            }
            return -9;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
    }

    public static class Factory
    implements VideoEncoderExtensionFactory {
        public VideoEncoderExtension create(int encoderIndex) {
            return new VideoTextureEncoderExtension(encoderIndex);
        }
    }
}

