/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.extension.decoder;

import android.graphics.SurfaceTexture;
import android.media.MediaFormat;
import android.view.Surface;
import com.skype.android.video.hw.codec.IpcOmxWrapper;
import com.skype.android.video.hw.codec.decoder.VideoSampleDecoder;
import com.skype.android.video.hw.extension.JniCodecUtils;
import com.skype.android.video.hw.extension.decoder.VideoDecoderExtension;
import com.skype.android.video.hw.extension.decoder.VideoDecoderExtensionFactory;
import com.skype.android.video.hw.format.Capabilities;
import com.skype.android.video.hw.format.ColorFormat;
import com.skype.android.video.hw.format.H264Level;
import com.skype.android.video.hw.format.H264Profile;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.frame.InputFrame;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.utils.CodecUtils;
import com.skype.android.video.hw.utils.DebugUtils;
import com.skype.android.video.hw.utils.EncoderAttributes;
import com.skype.android.video.hw.utils.Log;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class VideoSampleDecoderExtension
implements VideoDecoderExtension {
    private static final H264Level DEFAULT_H264_LEVEL = H264Level.L31;
    private static final H264Profile DEFAULT_H264_PROFILE = H264Profile.BASELINE;
    private static final int DEFAULT_FRAMERATE = 30;
    private static final int DEFAULT_I_FRAME_INTERVAL = 420;
    private static final int COMPRESSION_RATIO_ESTIMATION = 10;
    private static final int INPUT_FRAME_POOL_SIZE = 10;
    private static final int OUTPUT_FRAME_POOL_SIZE = 10;
    private static final int MAX_CONSECUTIVE_TIMEOUT_COUNT = 4;
    private static final int MAX_TOTAL_TIMEOUT_COUNT = 3;
    private final String decoderName;
    private VideoSampleDecoder decoder;
    private long initialTimestamp;
    private int rawFrameSize;
    VideoFormat videoFormat;
    private final Object lock = new Object();
    boolean firstFrame = false;
    boolean isRunning = false;
    private int consecutiveTimeoutCount = 0;
    private int totaltimeoutCount = 0;
    private long lastTs = 0L;
    private Surface decoderSurface = null;
    private SurfaceTexture rendererSurfaceTexture = null;
    private boolean isTextureDecoder = false;

    private static native void frameReady(long var0, long var2, int var4, ByteBuffer var5, int var6, int var7, long var8, boolean var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18);

    private static native void textureDecoderFrameReady(long var0, long var2, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private VideoSampleDecoderExtension(int decoderIndex) {
        this.decoderName = CodecUtils.enumDecoders()[decoderIndex];
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.getClass().getCanonicalName() + " with h/w decoder #" + decoderIndex + " (" + this.decoderName + ") created");
        }
    }

    public static VideoSampleDecoderExtension createStatic(int decoderIndex) {
        try {
            return new VideoSampleDecoderExtension(decoderIndex);
        }
        catch (Exception e) {
            Log.e("SLIQ", "Exception caught: ", e);
            return null;
        }
    }

    public static boolean getCapabilities(String decoderName, long capabilitiesNativeObj) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", VideoSampleDecoderExtension.class.getCanonicalName() + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            VideoSampleDecoderExtension.passCapabilitiesToNative(capabilitiesNativeObj, CodecUtils.getDecoderCapabilities(decoderName));
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", VideoSampleDecoderExtension.class.getCanonicalName() + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return true;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", VideoSampleDecoderExtension.class.getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed");
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void passCapabilitiesToNative(long capabilitiesNativeObj, Capabilities capabilities) {
        void var7_13;
        int[] nArray;
        int maxLevel;
        int[] profiles;
        block11: {
            MediaFormat extCaps;
            profiles = new int[capabilities.getProfiles().size()];
            int i = 0;
            for (H264Profile h264Profile : capabilities.getProfiles()) {
                profiles[i++] = h264Profile.getSliqValue();
            }
            maxLevel = -1;
            for (H264Level h264Level : capabilities.getLevels()) {
                maxLevel = Math.max(maxLevel, h264Level.getSliqValue());
            }
            nArray = new int[capabilities.getColorFormats().size()];
            i = 0;
            for (ColorFormat cf : capabilities.getColorFormats()) {
                nArray[i++] = cf.getSliqValue();
            }
            Object var7_11 = null;
            if (capabilities.isQCExtensionSupported()) {
                extCaps = capabilities.getExtCapabilities();
                Log.d("SLIQ", "getExtCapabilities: " + (extCaps == null ? "null" : extCaps));
                if (extCaps != null) {
                    Log.d("SLIQ", "!!!!!!!!!!!!!!");
                    Log.d("SLIQ", "getVersion() =>                     " + extCaps.getString("vt-version"));
                    Log.d("SLIQ", "isLowLatencySupported() =>          " + extCaps.getString("vt-low-latency"));
                    Log.d("SLIQ", "getMaxInstances() =>                " + extCaps.getString("vt-max-instances"));
                    Log.d("SLIQ", "getMaxLevel() =>                    " + extCaps.getString("vt-max-level"));
                    Log.d("SLIQ", "getMaxMacroblockProcessingRate() => " + extCaps.getString("vt-max-macroblock-processing-rate"));
                }
            } else if (capabilities.isQCAfterNougatExtensionsSupported()) {
                extCaps = capabilities.getExtCapabilities();
                Log.d("SLIQ", "getExtCapabilities: " + (extCaps == null ? "null" : extCaps));
            } else {
                IpcOmxWrapper omxWrapper = new IpcOmxWrapper(capabilities.getCodecName(), capabilities.getCodecName());
                omxWrapper.connectForQueriesOnly();
                if (omxWrapper.isNodeIdKnown()) {
                    Log.i("SLIQ", "!!! Got nodeId: " + omxWrapper.getNodeId());
                    Buffer buffer = omxWrapper.getDecCapabilityBuffer();
                }
                try {
                    omxWrapper.close();
                }
                catch (IOException e) {
                    if (!Log.isLoggable("SLIQ", 6)) break block11;
                    Log.e("SLIQ", "Unexpected IOexception caught", e);
                }
            }
        }
        JniCodecUtils.returnCapabilitiesBuffer(capabilitiesNativeObj, capabilities.getCodecName(), profiles, maxLevel, nArray, (Buffer)var7_13, 0L, false, 0, 0, 0, 0, 0, 0, 0, false, 0, false);
    }

    public int configure(long spsAddr, int spsLen, long ppsAddr, int ppsLen) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() called");
        }
        ByteBuffer sps = ByteBuffer.allocateDirect(spsLen);
        ByteBuffer pps = ByteBuffer.allocateDirect(ppsLen);
        ByteBuffer spspps = ByteBuffer.allocateDirect(spsLen + ppsLen);
        this.consecutiveTimeoutCount = 0;
        this.totaltimeoutCount = 0;
        JniCodecUtils.fillInputFrameBuffer(spsAddr, sps, spsLen, false);
        JniCodecUtils.fillInputFrameBuffer(ppsAddr, pps, ppsLen, false);
        sps.position(0);
        spspps.put(sps);
        pps.position(0);
        spspps.put(pps);
        spspps.position(0);
        try {
            if (this.isRunning) {
                this.decoder.setReconfigFlag(true);
                this.decoder.stop();
                this.isRunning = false;
            }
            this.videoFormat.setSpsPps(spspps);
            this.decoder.configure(this.decoderSurface, this.videoFormat, false);
            if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", this.getClass().getCanonicalName() + '#' + " configuring  decoder with Surface=" + this.decoderSurface);
            }
            this.decoder.start();
            this.isRunning = true;
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            this.firstFrame = true;
            return 0;
        }
        catch (Exception e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Exception caught!", e);
            }
            this.isRunning = false;
            return -1;
        }
    }

    public int init(Object v, String attr) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            EncoderAttributes attributes = new EncoderAttributes(attr);
            this.videoFormat = VideoSampleDecoderExtension.createDecoderVideoFormat(attributes);
            this.rawFrameSize = this.videoFormat.getMaxResolution().getWidth() * this.videoFormat.getMaxResolution().getHeight() * this.videoFormat.getColorFormat().getBitsPerPixel() / 8;
            this.initialTimestamp = 132L;
            this.lastTs = 0L;
            this.isRunning = false;
            if (v != null) {
                this.rendererSurfaceTexture = (SurfaceTexture)v;
                this.decoderSurface = new Surface(this.rendererSurfaceTexture);
                if (this.decoderSurface != null) {
                    this.isTextureDecoder = true;
                    if (Log.isLoggable("SLIQ", 5)) {
                        Log.w("SLIQ", this.getClass().getCanonicalName() + '#' + " Init with texture decoder");
                    }
                } else {
                    Log.e("SLIQ", this.getClass().getCanonicalName() + '#' + " decoderSurface instance failed. Falling back to buffer decoder");
                }
            } else if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", this.getClass().getCanonicalName() + '#' + " Init with buffer decoder");
            }
            this.decoder = new VideoSampleDecoder(this.decoderName);
            return 0;
        }
        catch (EncoderAttributes.AttributeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Illegal attribute value", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_INCORRECT_PARAM");
            }
            return -9;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
    }

    public int uninit() {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            if (this.decoder != null) {
                this.decoder.stop();
                this.isRunning = false;
                this.decoder.close();
                this.decoder = null;
                if (this.decoderSurface != null) {
                    this.decoderSurface.release();
                    this.decoderSurface = null;
                }
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            this.isRunning = false;
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processFrame(long timeoutUs, long nativeCallbackObj, long encodedData, int dataLen, long ts, boolean isGapFillerNalu) {
        Object object = this.lock;
        synchronized (object) {
            int ret = 0;
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() called");
            }
            if (this.isRunning) {
                try {
                    OutputFrame outputFrame;
                    InputFrame inputFrame = this.decoder.getInputFrame(timeoutUs);
                    if (Log.isLoggable("SLIQ", 3)) {
                        Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() deocder.getInputFrame() done");
                    }
                    inputFrame.setTimestamp(this.initialTimestamp);
                    this.initialTimestamp += 33333L;
                    inputFrame.setSize(dataLen);
                    JniCodecUtils.fillInputFrameBuffer(encodedData, inputFrame.getData(), dataLen, false);
                    if (Log.isLoggable("SLIQ", 3)) {
                        Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() JniCodecUtils.fillInputFrameBuffer done");
                    }
                    if (this.firstFrame) {
                        timeoutUs *= 10L;
                    }
                    if ((outputFrame = this.decoder.decode(inputFrame, timeoutUs, isGapFillerNalu)).isTimedOut()) {
                        ++this.consecutiveTimeoutCount;
                        ++this.totaltimeoutCount;
                    } else {
                        this.consecutiveTimeoutCount = 0;
                    }
                    if (Log.isLoggable("SLIQ", 3)) {
                        Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() decoder.decode() done !totalTimeoutCount " + this.totaltimeoutCount);
                    }
                    this.firstFrame = false;
                    this.lastTs = ts;
                    if (this.isTextureDecoder) {
                        this.textureDecoderFrameReady(nativeCallbackObj, ts, outputFrame);
                    } else {
                        this.frameReady(nativeCallbackObj, ts, outputFrame);
                    }
                    outputFrame.close();
                    if (this.consecutiveTimeoutCount >= 4) {
                        return -23;
                    }
                    if (this.totaltimeoutCount >= 3) {
                        if (Log.isLoggable("SLIQ", 3)) {
                            Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() start to flush frames");
                        }
                        int maxNumOfFlushframe = this.totaltimeoutCount;
                        for (int i = 0; i < maxNumOfFlushframe; ++i) {
                            OutputFrame abandonOutputFrame = this.decoder.flushOneFrame(timeoutUs);
                            if (abandonOutputFrame.isTimedOut()) {
                                ++this.consecutiveTimeoutCount;
                            }
                            if (abandonOutputFrame != null && !abandonOutputFrame.isTimedOut() && !abandonOutputFrame.isEndOfStream()) {
                                this.frameReady(nativeCallbackObj, ts, abandonOutputFrame);
                                --this.totaltimeoutCount;
                                if (Log.isLoggable("SLIQ", 3)) {
                                    Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() flush succeeded, now " + this.totaltimeoutCount + " frames remain");
                                }
                                abandonOutputFrame.close();
                                continue;
                            }
                            abandonOutputFrame.close();
                        }
                    }
                    if (Log.isLoggable("SLIQ", 3)) {
                        Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() succeeded");
                    }
                }
                catch (RuntimeException e) {
                    if (Log.isLoggable("SLIQ", 6)) {
                        Log.e("SLIQ", "Unexpected exception caught", e);
                    }
                    if (Log.isLoggable("SLIQ", 6)) {
                        Log.e("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_ANDROID_FAILED");
                    }
                    this.isRunning = false;
                    ret = -23;
                }
                return ret;
            }
            return -1;
        }
    }

    public int flushFrames(long nativeCallbackObj, long timeoutUs) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (!this.isRunning) {
            Log.e("SLIQ", "can't flushFrame because decoder is not running!");
            return 0;
        }
        this.decoder.signalEOS(this.initialTimestamp, timeoutUs);
        boolean stop = false;
        do {
            OutputFrame outputFrame;
            if ((outputFrame = this.decoder.flushOneFrame(timeoutUs)) != null && !outputFrame.isTimedOut() && !outputFrame.isEndOfStream()) {
                outputFrame.close();
                continue;
            }
            stop = true;
        } while (!stop);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() succeeded");
        }
        return 0;
    }

    private static VideoFormat createDecoderVideoFormat(EncoderAttributes attributes) throws EncoderAttributes.AttributeException {
        int width = 1920;
        int height = 1080;
        VideoFormat format = new VideoFormat();
        format.setResolution(new Resolution(width, height));
        format.setOrgResolution(new Resolution(width, height));
        format.setMaxResolution(new Resolution(width, height));
        format.setColorFormat(ColorFormat.I420);
        return format;
    }

    private void textureDecoderFrameReady(long nativeCallbackObj, long ts, OutputFrame outputFrame) {
        int cropL = 0;
        int cropT = 0;
        int cropR = 0;
        int cropB = 0;
        if (this.decoder.getMediaFormat().containsKey("crop-left")) {
            cropL = this.decoder.getMediaFormat().getInteger("crop-left");
            cropT = this.decoder.getMediaFormat().getInteger("crop-top");
            cropR = this.decoder.getMediaFormat().getInteger("crop-right");
            cropB = this.decoder.getMediaFormat().getInteger("crop-bottom");
        }
        VideoSampleDecoderExtension.textureDecoderFrameReady(nativeCallbackObj, ts, outputFrame.isTimedOut(), this.decoder.getMediaFormat().getInteger("width"), this.decoder.getMediaFormat().getInteger("height"), cropL, cropT, cropR, cropB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frameReady(long nativeCallbackObj, long ts, OutputFrame outputFrame) {
        int cropL = 0;
        int cropT = 0;
        int cropR = 0;
        int cropB = 0;
        if (this.decoder.getMediaFormat().containsKey("crop-left")) {
            cropL = this.decoder.getMediaFormat().getInteger("crop-left");
            cropT = this.decoder.getMediaFormat().getInteger("crop-top");
            cropR = this.decoder.getMediaFormat().getInteger("crop-right");
            cropB = this.decoder.getMediaFormat().getInteger("crop-bottom");
        }
        while (outputFrame.hasBuffers()) {
            OutputFrame.FrameBuffer frameBuffer = outputFrame.popBuffer();
            try {
                int stride = this.decoder.getMediaFormat().getInteger("stride");
                stride += stride % 16 == 0 ? 0 : 16 - stride % 16;
                if (Log.isLoggable("SLIQ", 3)) {
                    Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() outputFrame.popBuffer() done colorformat " + this.decoder.getMediaFormat().getInteger("color-format"));
                }
                VideoSampleDecoderExtension.frameReady(nativeCallbackObj, outputFrame.getNativeLockingObj(), frameBuffer.getId(), frameBuffer.getData(), frameBuffer.getOffset(), frameBuffer.getSize(), ts, outputFrame.isTimedOut(), this.decoder.getMediaFormat().getInteger("width"), this.decoder.getMediaFormat().getInteger("height"), ColorFormat.fromOmx(this.decoder.getMediaFormat().getInteger("color-format")).getSliqValue(), stride, cropL, cropT, cropR, cropB);
                if (!Log.isLoggable("SLIQ", 3)) continue;
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() frameReady() native call done");
            }
            finally {
                frameBuffer.close();
            }
        }
    }

    public static class Factory
    implements VideoDecoderExtensionFactory {
        public VideoSampleDecoderExtension create(int decoderIndex) {
            try {
                return new VideoSampleDecoderExtension(decoderIndex);
            }
            catch (Exception e) {
                Log.e("SLIQ", "Exception caught: ", e);
                return null;
            }
        }
    }
}

