/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.utils;

import java.io.Serializable;
import java.util.regex.Pattern;

public class Resolution
implements Comparable<Resolution>,
Serializable {
    private static final long serialVersionUID = 9064060424044615056L;
    private static final Pattern SPLIT_REGEX = Pattern.compile("x");
    private final int width;
    private final int height;

    public Resolution(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("invalid parameters width=" + width + ", height=" + height);
        }
        this.width = width;
        this.height = height;
    }

    public Resolution(String resolution) {
        String[] dimensions = SPLIT_REGEX.split(resolution);
        this.width = Integer.parseInt(dimensions[0]);
        this.height = Integer.parseInt(dimensions[1]);
        if (this.width < 0 || this.height < 0) {
            throw new IllegalArgumentException("invalid parameters width=" + this.width + ", height=" + this.height);
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumPixels() {
        return this.width * this.height;
    }

    public final String toString() {
        return this.width + "x" + this.height;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Resolution other = (Resolution)obj;
        return this.width == other.width && this.height == other.height;
    }

    @Override
    public final int compareTo(Resolution another) {
        return this.width > another.width ? 1 : (this.width < another.width ? -1 : (this.height > another.height ? 1 : (this.height < another.height ? -1 : 0)));
    }
}

