/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCallback;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CameraParameters;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.capture.impl.CaptureWorker;
import com.microsoft.dl.video.capture.impl.real.impl.CameraCapabilitiesUtils;
import java.io.IOException;

public class RealCameraImpl
implements Camera {
    private final String cameraId;
    private int degrees;
    private final android.hardware.Camera hwCamera;
    private volatile boolean isFaceDetectionEnabled = false;
    private volatile boolean isPreviewStarted = false;
    private volatile Matrix matrix;

    public RealCameraImpl(String cameraId) throws CaptureException {
        this.cameraId = cameraId;
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Opening camera " + cameraId));
        }
        try {
            try {
                int cameraIdInt = Integer.parseInt(cameraId);
                this.hwCamera = android.hardware.Camera.open((int)cameraIdInt);
            }
            catch (NumberFormatException exception) {
                throw new CaptureException("No such camera " + cameraId, ErrorCode.ANDROID_CAMERA_INVALID_ID);
            }
            if (this.hwCamera == null) {
                throw new CaptureException("Could not open camera " + cameraId, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
            }
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not open camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera " + cameraId + " is opened"));
        }
    }

    @Override
    public final void close() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Closing camera " + this.cameraId));
        }
        if (this.hwCamera != null) {
            try {
                this.hwCamera.release();
            }
            catch (RuntimeException e) {
                throw new CaptureException("Could not close camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_CLOSE_FAILED);
            }
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Camera " + this.cameraId + " is closed"));
        }
    }

    @Override
    public final CameraParameters getParameters() throws CaptureException {
        Camera.Parameters hwParameters = null;
        int imageFormat = 0;
        Camera.Size resolution = null;
        int[] fpsRange = new int[2];
        String focusMode = null;
        try {
            hwParameters = this.hwCamera.getParameters();
            imageFormat = hwParameters.getPreviewFormat();
            resolution = hwParameters.getPreviewSize();
            hwParameters.getPreviewFpsRange(fpsRange);
            focusMode = hwParameters.getFocusMode();
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not get parameters of the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_GET_PARAMETERS_FAILED);
        }
        CameraParameters parameters = new CameraParameters();
        parameters.setImageFormat(CameraCapabilitiesUtils.mapImageFormat(imageFormat));
        parameters.setResolution(CameraCapabilitiesUtils.mapResolution(resolution));
        parameters.setFpsRange(CameraCapabilitiesUtils.mapFpsRange(fpsRange));
        parameters.setFocusMode(focusMode);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera " + this.cameraId + " returned " + parameters));
        }
        return parameters;
    }

    @Override
    public final void setParameters(CameraParameters parameters) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting " + parameters + " to the camera " + this.cameraId));
        }
        try {
            Camera.Parameters hwParameters = this.hwCamera.getParameters();
            hwParameters.setPreviewFormat(CameraCapabilitiesUtils.mapImageFormat(parameters.getImageFormat()));
            hwParameters.setPreviewSize(parameters.getResolution().getWidth(), parameters.getResolution().getHeight());
            if (CameraCapabilitiesUtils.isPictureSizeSupported(parameters.getResolution(), hwParameters)) {
                hwParameters.setPictureSize(parameters.getResolution().getWidth(), parameters.getResolution().getHeight());
            }
            hwParameters.setPreviewFpsRange(parameters.getFpsRange().getMin(), parameters.getFpsRange().getMax());
            if (parameters.getFocusMode() != null) {
                hwParameters.setFocusMode(parameters.getFocusMode());
            }
            this.hwCamera.setParameters(hwParameters);
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not set " + parameters + " to the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_SET_PARAMETERS_FAILED);
        }
    }

    @Override
    public final void setFlashTorchMode(boolean torchTurnOn) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting flash torch [" + torchTurnOn + "] to the camera: " + this.cameraId));
        }
        try {
            Camera.Parameters hwParameters = this.hwCamera.getParameters();
            hwParameters.setFlashMode(torchTurnOn ? "torch" : "off");
            this.hwCamera.setParameters(hwParameters);
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not set flash torch [" + torchTurnOn + "] to the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_SET_PARAMETERS_FAILED);
        }
    }

    @Override
    public final void setPreviewDisplay(Object display) throws CaptureException {
        block7: {
            try {
                if (display == null) {
                    this.hwCamera.setPreviewDisplay(null);
                    this.hwCamera.setPreviewTexture(null);
                    break block7;
                }
                if (display instanceof SurfaceHolder) {
                    this.hwCamera.setPreviewDisplay((SurfaceHolder)display);
                    break block7;
                }
                if (display instanceof SurfaceTexture) {
                    this.hwCamera.setPreviewTexture((SurfaceTexture)display);
                    break block7;
                }
                throw new CaptureException(display.getClass().getCanonicalName() + " is not supported", ErrorCode.ANDROID_CAMERA_UNSUPPORTED_PREVIEW_DISPLAY);
            }
            catch (IOException e) {
                throw new CaptureException("Could not set preview display to " + display + " for the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_SET_PREVIEW_DISPLAY_FAILED);
            }
            catch (RuntimeException e) {
                throw new CaptureException("Could not set preview display to " + display + " for the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_SET_PREVIEW_DISPLAY_FAILED);
            }
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Preview display is set to " + display + " for the camera " + this.cameraId));
        }
    }

    @Override
    public final void setDisplayOrientation(int degrees) throws CaptureException {
        try {
            this.hwCamera.setDisplayOrientation(degrees);
            this.degrees = degrees;
            if (this.isFaceDetectionEnabled) {
                this.initFaceMatrix();
            }
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not set display orientation to " + degrees + " degrees for the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_SET_PREVIEW_DISPLAY_ORIENTATION_FAILED);
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Display orientation is set to " + degrees + " degrees for the camera " + this.cameraId));
        }
    }

    @Override
    public final void addCallbackBuffer(byte[] callbackBuffer) throws CaptureException {
        try {
            this.hwCamera.addCallbackBuffer(callbackBuffer);
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not add callback buffer for the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_ADD_CALLBACK_BUFFER_FAILED);
        }
    }

    @Override
    public final void setCallback(CameraCallback cb, boolean usingBufferMode) throws CaptureException {
        try {
            CallbackHandler handler;
            CallbackHandler callbackHandler = handler = cb != null ? new CallbackHandler(cb, this) : null;
            if (usingBufferMode) {
                this.hwCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)handler);
            }
            this.hwCamera.setErrorCallback((Camera.ErrorCallback)handler);
            this.hwCamera.setFaceDetectionListener((Camera.FaceDetectionListener)handler);
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not set preview callback for the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_SET_CALLBACK_FAILED);
        }
    }

    @Override
    public final void startPreview() throws CaptureException {
        try {
            this.hwCamera.startPreview();
            this.isPreviewStarted = true;
            if (this.isFaceDetectionEnabled) {
                this.startFaceDetection();
            }
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not start preview from the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_START_PREVIEW_FAILED);
        }
    }

    @Override
    public final void stopPreview() throws CaptureException {
        try {
            this.hwCamera.stopPreview();
            this.isPreviewStarted = false;
            if (this.isFaceDetectionEnabled) {
                this.hwCamera.stopFaceDetection();
            }
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not stop preview from the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_STOP_PREVIEW_FAILED);
        }
    }

    @Override
    public void enableFaceDetection(boolean faceDetectionEnabled) throws CaptureException {
        if (this.isFaceDetectionEnabled == faceDetectionEnabled) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Camera already under isFaceDetectionEnabled = " + this.isFaceDetectionEnabled + " status!"));
            }
            return;
        }
        if (faceDetectionEnabled) {
            this.initFaceMatrix();
        }
        if (this.isPreviewStarted) {
            if (faceDetectionEnabled) {
                this.startFaceDetection();
            } else {
                this.hwCamera.stopFaceDetection();
            }
        } else if (Log.isLoggable((String)"Video", (int)5)) {
            Log.w((String)"Video", (String)("EnableFaceDetection with status " + faceDetectionEnabled + " but camera not started!"));
        }
        this.isFaceDetectionEnabled = faceDetectionEnabled;
    }

    @Override
    public final Matrix getFaceTransferMatrix() {
        return this.matrix;
    }

    private void initFaceMatrix() throws CaptureException {
        StaticCameraCapabilities cameraCapabilities = CameraManagerSingleton.getInstance().getStaticCameraCapabilities(this.cameraId);
        if (cameraCapabilities == null) {
            return;
        }
        Rect arraySize = cameraCapabilities.getCameraArraySize().toRect();
        if (arraySize == null) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Got empty camera array size");
            }
            return;
        }
        this.matrix = new Matrix();
        boolean isFrontCamera = cameraCapabilities.getFacing().ordinal() == CameraCapabilities.Facing.FRONT.ordinal();
        int cameraOrientation = 360 - cameraCapabilities.getOrientation();
        float arraySizeWidth = arraySize.width();
        float arraySizeHeight = arraySize.height();
        int surfaceOrientation = CaptureWorker.displayOrientationToSurfaceOrientation(this.degrees);
        if (isFrontCamera) {
            this.matrix.setRotate((float)(cameraOrientation + surfaceOrientation * 90));
        } else {
            this.matrix.setRotate((float)(cameraOrientation - surfaceOrientation * 90));
        }
        float scaleX = 1.0f / arraySizeWidth;
        float scaleY = 1.0f / arraySizeHeight;
        this.matrix.postScale(scaleX, scaleY);
        this.matrix.postTranslate(0.5f, 0.5f);
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera face matrix config { isFrontCamera: " + isFrontCamera + ", camera orientation: " + cameraOrientation + ", displayOrientation: " + this.degrees + ", arraySizeWidth: " + arraySizeWidth + ", arraySizeHeight: " + arraySizeHeight + " }"));
        }
    }

    private void startFaceDetection() throws CaptureException {
        try {
            this.hwCamera.startFaceDetection();
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not start detect face from the camera " + this.cameraId, e, ErrorCode.ANDROID_CAMERA_START_DETECT_FACE_FAILED);
        }
    }

    private static class CallbackHandler
    implements Camera.PreviewCallback,
    Camera.ErrorCallback,
    Camera.FaceDetectionListener {
        private final CameraCallback cb;
        private final Camera camera;

        public CallbackHandler(CameraCallback cb, Camera camera) {
            this.cb = cb;
            this.camera = camera;
        }

        public void onPreviewFrame(byte[] data, android.hardware.Camera hwCamera) {
            this.cb.onCpuFrameCaptured(data, this.camera);
        }

        public void onError(int error, android.hardware.Camera hwCamera) {
            this.cb.onError(new CaptureException("Camera error", ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE, String.valueOf(error)));
        }

        public void onFaceDetection(Camera.Face[] faces, android.hardware.Camera camera) {
            if (this.cb == null) {
                return;
            }
            Rect[] faceRects = null;
            if (faces != null && faces.length > 0) {
                faceRects = new Rect[faces.length];
                for (int i = 0; i < faces.length; ++i) {
                    faceRects[i] = faces[i].rect;
                }
            }
            this.cb.onFaceDetected(faceRects);
        }
    }
}

