/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CameraManager;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import java.util.ArrayList;
import java.util.List;

public final class DeviceManager {
    private static DeviceManager instance;
    private final String simpleClassName = this.getClass().getSimpleName();
    private final List<CameraInfo> cameras = new ArrayList<CameraInfo>();
    private final long nativeContext;

    public static native void notifyNativeDeviceChanged(long var0, boolean var2);

    private DeviceManager(long nativeContext) throws CaptureException {
        this.nativeContext = nativeContext;
        CameraManager cameraManager = CameraManagerSingleton.getInstance();
        for (String cameraId : cameraManager.getCameraIds()) {
            StaticCameraCapabilities caps = cameraManager.getStaticCameraCapabilities(cameraId);
            this.cameras.add(new CameraInfo("/" + caps.getFacing().name() + "/" + cameraId, caps));
        }
    }

    public static synchronized void reset() {
        instance = null;
    }

    public static synchronized DeviceManager getInstance() throws CaptureException {
        if (instance == null) {
            throw new CaptureException("DeviceManager not initialized.", ErrorCode.ANDROID_CAMERA_MANAGER_NOT_SET);
        }
        return instance;
    }

    public static synchronized DeviceManager getInstance(long nativeContext) {
        if (instance == null) {
            try {
                instance = new DeviceManager(nativeContext);
            }
            catch (CaptureException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"Could not instantiate DeviceManager", (Throwable)e);
                }
                return null;
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
                }
                return null;
            }
        }
        return instance;
    }

    public int getNumCameras() {
        try {
            return this.cameras.size();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public int getCameraFacing(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getFacing().ordinal();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return -1;
        }
    }

    public String getCameraName(int index) {
        try {
            return this.cameras.get(index).getName();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return null;
        }
    }

    public int getCameraOrientation(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getOrientation();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return -1;
        }
    }

    public String getCameraId(int index) {
        try {
            return this.cameras.get(index).getStaticCameraCapabilities().getCameraId();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return null;
        }
    }

    public synchronized boolean isDeviceListed(String cameraId) {
        for (CameraInfo info : this.cameras) {
            if (!info.getStaticCameraCapabilities().getCameraId().equals(cameraId)) continue;
            return true;
        }
        return false;
    }

    public synchronized void notifyDeviceChanged(String cameraId, boolean available) {
        try {
            CameraManager cameraManager = CameraManagerSingleton.getInstance();
            StaticCameraCapabilities caps = cameraManager.getStaticCameraCapabilities(cameraId);
            this.cameras.add(new CameraInfo("/" + caps.getFacing().name() + "/" + cameraId, caps));
            Log.log((int)5, (String)"Video", (String)("DeviceManager notifyDeviceChanged for camera: " + cameraId + ", available: " + available));
            DeviceManager.notifyNativeDeviceChanged(this.nativeContext, available);
        }
        catch (CaptureException | RuntimeException exception) {
            Log.log((int)6, (String)"Video", (String)"ERROR: DeviceManager notifyDeviceChanged() got error.", (Throwable)exception);
        }
    }

    public String toString() {
        return this.simpleClassName + " [cameras=" + this.cameras + "]";
    }

    private static class CameraInfo {
        private final String name;
        private final StaticCameraCapabilities staticCapabilities;
        private final String simpleClassName = this.getClass().getSimpleName();

        public CameraInfo(String name, StaticCameraCapabilities staticCapabilities) {
            this.name = name;
            this.staticCapabilities = staticCapabilities;
        }

        public String getName() {
            return this.name;
        }

        public StaticCameraCapabilities getStaticCameraCapabilities() {
            return this.staticCapabilities;
        }

        public String toString() {
            return this.simpleClassName + " [staticCapabilities=" + this.staticCapabilities + ", name=" + this.name + "]";
        }
    }
}

