/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CameraManagerFactory;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.impl.real.RealCameraManagerImpl;
import com.microsoft.dl.video.capture.impl2.RealCamera2ManagerImpl;

public final class VideoPlatform {
    private VideoPlatform() {
    }

    public static synchronized void initialize(boolean useCamera2APIs) {
        block5: {
            try {
                String str = VideoPlatform.getCameraManagerFactoryName();
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)("VideoPlatform::intialize with camera2: " + useCamera2APIs));
                }
                if (useCamera2APIs) {
                    CameraManagerSingleton.setFactory(VideoPlatform.getCameraManagerFactory(CameraManagerFactoryType.valueOf("REAL_CAMERAv2")));
                } else {
                    CameraManagerSingleton.setFactory(VideoPlatform.getCameraManagerFactory(CameraManagerFactoryType.valueOf("REAL_CAMERAv1")));
                }
            }
            catch (CaptureException | RuntimeException e) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block5;
                Log.e((String)"Video", (String)"Exception caught ", (Throwable)e);
            }
        }
    }

    private static CameraManagerFactory getCameraManagerFactory(CameraManagerFactoryType type) throws CaptureException {
        switch (type) {
            case REAL_CAMERAv1: {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)"CameraManagerFactory: REAL_CAMERAv1");
                }
                return new RealCameraManagerImpl.Factory();
            }
            case REAL_CAMERAv2: {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)"CameraManagerFactory: REAL_CAMERAv2");
                }
                return new RealCamera2ManagerImpl.Factory();
            }
        }
        throw new CaptureException("Unknown CameraManagerFactoryType " + (Object)((Object)type), ErrorCode.ANDROID_CAMERA_MANAGER_INVALID_TYPE);
    }

    private static native String getCameraManagerFactoryName();

    private static enum CameraManagerFactoryType {
        REAL_CAMERAv1,
        REAL_CAMERAv2;

    }
}

