/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.audio;

import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import com.microsoft.dl.utils.Log;

public class AudioHwOffload {
    public int recorderID = 0;
    private static AcousticEchoCanceler aec;
    private static NoiseSuppressor ns;
    private static AutomaticGainControl agc;
    private static final int OFFLOAD_AEC = 1;
    private static final int OFFLOAD_AGC = 2;
    private static final int OFFLOAD_NS = 4;
    private static final int OFFLOAD_SP = 8;
    private int getAudioRecordSessionIDRetryNum = 3;

    public AudioHwOffload() {
        if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"AudioHwOffload class instantiated");
        }
    }

    private int getFakeAudioRecordSessionID(int rate, int channelConfig, int audioSource) {
        int id = 0;
        int bufSize = AudioRecord.getMinBufferSize((int)rate, (int)16, (int)2);
        if (bufSize < 0) {
            if (bufSize == -2) {
                Log.log((int)6, (String)"DLAudioJava", (String)"Get AudioRecord failed, sample rate not supported.");
            } else if (bufSize == -1) {
                Log.log((int)6, (String)"DLAudioJava", (String)"Get AudioRecord failed, device is busy.");
            } else {
                Log.log((int)6, (String)"DLAudioJava", (String)"Get AudioRecord failed, unknown error.");
            }
            return 0;
        }
        if (Build.VERSION.SDK_INT < 16) {
            if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                Log.d((String)"DLAudioJava", (String)"AudioRecord.getAudioSessionId not available in this version of OS");
            }
            return 0;
        }
        try {
            AudioRecord audioRecord = new AudioRecord(audioSource, rate, 16, 2, bufSize);
            if (audioRecord.getState() == 1) {
                id = audioRecord.getAudioSessionId();
            } else {
                Log.log((int)6, (String)"DLAudioJava", (String)"AudioRecorder failed to initialize, no audio session ID!");
            }
            audioRecord.release();
            audioRecord = null;
        }
        catch (RuntimeException e) {
            Log.log((int)6, (String)"DLAudioJava", (String)"Exception occured in new AudioRecord(): ", (Throwable)e);
        }
        return id;
    }

    public int getAudioRecordSessionID(int rate, int channelConfig, boolean useVoiceComm) {
        int id1 = 0;
        int id2 = 0;
        int step = 0;
        int audioSource = useVoiceComm ? 7 : 0;
        int ret = 0;
        id1 = this.getFakeAudioRecordSessionID(rate, channelConfig, audioSource);
        id2 = this.getFakeAudioRecordSessionID(rate, channelConfig, audioSource);
        if (id1 != 0 && id2 != 0 && id1 != id2) {
            step = id2 - id1;
            this.recorderID = id2 + step;
            id1 = this.getFakeAudioRecordSessionID(rate, channelConfig, audioSource);
            if (id1 == this.recorderID) {
                this.recorderID += step;
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)("Successfully got record sessionID=" + this.recorderID));
                }
                this.getAudioRecordSessionIDRetryNum = 3;
                return this.recorderID;
            }
            if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                Log.d((String)"DLAudioJava", (String)("record sessionID not reliable, ignoring it. Got (" + id1 + ") expected (" + this.recorderID + "). And will retry."));
            }
            if (this.getAudioRecordSessionIDRetryNum-- > 0) {
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)("Retry to get sessionID for the " + (3 - this.getAudioRecordSessionIDRetryNum) + " time."));
                }
                ret = this.getAudioRecordSessionID(rate, channelConfig, useVoiceComm);
            } else {
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)"Have tried to get record sessionID 3 times, and will give it up.");
                }
                this.getAudioRecordSessionIDRetryNum = 3;
                return 0;
            }
        }
        return ret;
    }

    public int getDefaultBuiltinEffect(int captureSessionID) {
        int audioOffloadCapabilityMask = 0;
        if (Build.VERSION.SDK_INT < 16) {
            if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                Log.d((String)"DLAudioJava", (String)"Offload API not available in this version of OS");
            }
            return 0;
        }
        if (AcousticEchoCanceler.isAvailable()) {
            aec = AcousticEchoCanceler.create((int)captureSessionID);
            if (aec != null) {
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)("AEC offload isAvailable: isEnabledDefault()=" + aec.getEnabled() + " isControlling=" + aec.hasControl()));
                }
                aec.release();
                aec = null;
                audioOffloadCapabilityMask |= 1;
            } else {
                Log.log((int)5, (String)"DLAudioJava", (String)"AcousticEchoCanceler.create() returned null");
            }
        } else if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"AEC offload is NOT available");
        }
        if (NoiseSuppressor.isAvailable()) {
            ns = NoiseSuppressor.create((int)captureSessionID);
            if (ns != null) {
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)("NS offload isAvailable: isEnabledDefault()=" + ns.getEnabled() + " isControlling=" + ns.hasControl()));
                }
                ns.release();
                ns = null;
                audioOffloadCapabilityMask |= 4;
            } else {
                Log.log((int)5, (String)"DLAudioJava", (String)"NoiseSuppressor.create() returned null");
            }
        } else if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"NS offload is NOT available");
        }
        if (AutomaticGainControl.isAvailable()) {
            agc = AutomaticGainControl.create((int)captureSessionID);
            if (agc != null) {
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)("AEC offload isAvailable: isEnabledDefault()=" + agc.getEnabled() + " isControlling=" + agc.hasControl()));
                }
                agc.release();
                agc = null;
                audioOffloadCapabilityMask |= 2;
            } else {
                Log.log((int)5, (String)"DLAudioJava", (String)"AutomaticGainControl.create() returned null");
            }
        } else if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"AGC offload is NOT available");
        }
        return audioOffloadCapabilityMask;
    }

    public int enableAudioEffects(int captureSessionID, int hwOffload) {
        boolean enableEffect = false;
        int retValue = 1;
        if (Build.VERSION.SDK_INT < 16) {
            if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                Log.d((String)"DLAudioJava", (String)"OS version too old for enabling HW offloads");
            }
            return 0;
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)("EnableAudioEffect ID(" + captureSessionID + ") Offload(" + hwOffload + ")"));
        }
        if (AcousticEchoCanceler.isAvailable()) {
            if (aec != null) {
                aec.release();
                aec = null;
            }
            if ((aec = AcousticEchoCanceler.create((int)captureSessionID)) != null) {
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)("AEC offload isAvailable: isEnabledDefault()=" + aec.getEnabled() + " isControlling=" + aec.hasControl()));
                }
                try {
                    enableEffect = (hwOffload & 1) != 0;
                    aec.setEnabled(enableEffect);
                    if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                        Log.d((String)"DLAudioJava", (String)("AEC has been set to " + enableEffect + " - status IsEnabled(): " + aec.getEnabled()));
                    }
                }
                catch (RuntimeException e) {
                    Log.log((int)6, (String)"DLAudioJava", (String)("Exception occured in AEC.setEnabled(" + enableEffect + "): "), (Throwable)e);
                    retValue = 0;
                }
            } else {
                Log.log((int)5, (String)"DLAudioJava", (String)"AcousticEchoCanceler.create() returned null");
            }
        } else if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"AEC is NOT available");
        }
        if (NoiseSuppressor.isAvailable()) {
            if (ns != null) {
                ns.release();
                ns = null;
            }
            if ((ns = NoiseSuppressor.create((int)captureSessionID)) != null) {
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)("NS offload isAvailable: isEnabledDefault()=" + ns.getEnabled() + " isControlling=" + ns.hasControl()));
                }
                try {
                    enableEffect = (hwOffload & 4) != 0;
                    ns.setEnabled(enableEffect);
                    if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                        Log.d((String)"DLAudioJava", (String)("NS has been set to " + enableEffect + " - status IsEnabled(): " + ns.getEnabled()));
                    }
                }
                catch (RuntimeException e) {
                    Log.log((int)6, (String)"DLAudioJava", (String)("Exception occured in NS.setEnabled(" + enableEffect + "): "), (Throwable)e);
                    retValue = 0;
                }
            } else {
                Log.log((int)5, (String)"DLAudioJava", (String)"NoiseSuppressor.create() returned null");
            }
        } else if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"NS is NOT available");
        }
        if (AutomaticGainControl.isAvailable()) {
            if (agc != null) {
                agc.release();
                agc = null;
            }
            if ((agc = AutomaticGainControl.create((int)captureSessionID)) != null) {
                if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                    Log.d((String)"DLAudioJava", (String)("AGC offload isAvailable: isEnabledDefault()=" + agc.getEnabled() + " isControlling=" + agc.hasControl()));
                }
                try {
                    enableEffect = (hwOffload & 2) != 0;
                    agc.setEnabled(enableEffect);
                    if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                        Log.d((String)"DLAudioJava", (String)("AGC has been set to " + enableEffect + " - status IsEnabled(): " + agc.getEnabled()));
                    }
                }
                catch (RuntimeException e) {
                    Log.log((int)6, (String)"DLAudioJava", (String)("Exception occured in AGC.setEnabled(" + enableEffect + "): "), (Throwable)e);
                    retValue = 0;
                }
            } else {
                Log.log((int)5, (String)"DLAudioJava", (String)"AutomaticGainControl.create() returned null");
            }
        } else if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"AGC is NOT available");
        }
        return retValue;
    }
}

