/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.Nullable;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.RemoteVideoStream;
import com.skype.android.video.render.BindingRenderer;
import com.skype.android.video.render.GLESBindingRenderer;
import com.skype.android.video.render.GLTextureView;
import java.util.Locale;

class VideoRenderer
implements BindingRenderer.Callback {
    private static final String TAG = "VideoRenderer";
    private final Object lock = new Object();
    private Callback mCb;
    @Nullable
    private GLTextureView mView;
    @Nullable
    private BindingRenderer mBindingRenderer;
    @Nullable
    private RemoteVideoStream mVideo;
    @Nullable
    private RemoteVideoStream videoToReleaseBinding;
    @Nullable
    private RemoteVideoStream videoToCreateBinding;
    private boolean isViewAcquired;
    private boolean isBindingFailed;
    private long binding;
    private int bindingType;
    private long bindingEvent;
    private int mVideoObjectId;

    public VideoRenderer(Callback cb, int videoObjectId) {
        this.mCb = cb;
        this.mVideoObjectId = videoObjectId;
    }

    public void updateCallback(Callback cb) {
        this.mCb = cb;
        if (this.binding != 0L) {
            this.mCb.onBindingAttached();
        }
    }

    private String tag() {
        return String.format(Locale.US, "%s[%d:%d:%b]", TAG, this.mVideoObjectId, this.binding, this.isViewAcquired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GLTextureView createView(Context context, GLTextureView.SurfaceTextureAvailableListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mView == null) {
                this.mView = new GLTextureView(context, null, false, listener);
                Log.debug1(this.tag(), "createView create new view %d", System.identityHashCode(this.mView));
            }
            Log.debug1(this.tag(), "createView view %d", System.identityHashCode(this.mView));
            this.isViewAcquired = true;
            return this.mView;
        }
    }

    @Nullable
    public GLTextureView getView() {
        return this.mView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseView() {
        Object object = this.lock;
        synchronized (object) {
            Log.debug1(this.tag(), "releaseView view %d", System.identityHashCode(this.mView));
            this.isViewAcquired = false;
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startVideo(RemoteVideoStream video) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isViewAcquired) {
                Log.debug1(this.tag(), "startVideo videoObjId %d called with no view attached", video.getId());
                return false;
            }
            Log.debug1(this.tag(), "startVideo videoObjId %d view %d", video.getId(), System.identityHashCode(this.mView));
            if (this.mVideo != null) {
                return this.mVideo.getId() == video.getId();
            }
            if (this.mBindingRenderer == null) {
                Log.debug1(this.tag(), "startVideo create new bindingRenderer for view %d", System.identityHashCode(this.mView));
                this.mBindingRenderer = new GLESBindingRenderer((BindingRenderer.Callback)this);
                this.bindingType = this.mBindingRenderer.getNativeBindingType();
                this.bindingEvent = this.mBindingRenderer.getNativeBindingEvent();
            }
            video.start();
            this.mVideo = video;
            if (this.binding != 0L) {
                if (this.videoToReleaseBinding == video) {
                    this.videoToReleaseBinding = null;
                } else {
                    this.videoToCreateBinding = video;
                }
            } else if (this.videoToReleaseBinding == video) {
                this.videoToReleaseBinding = null;
            } else {
                this.videoToCreateBinding = video;
                if (this.videoToReleaseBinding == null) {
                    this.registerViewAndCreateBinding();
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopVideo(RemoteVideoStream video) {
        Object object = this.lock;
        synchronized (object) {
            boolean isOurVideo = this.mBindingRenderer != null && this.mVideo != null && this.mVideo.getId() == video.getId();
            Log.debug1(this.tag(), "stopVideo videoObjId %d view %d will stop %b", video.getId(), System.identityHashCode(this.mView), isOurVideo);
            if (!isOurVideo) {
                return false;
            }
            this.mVideo = null;
            if (this.isBindingFailed) {
                this.dispose();
                return true;
            }
            if (this.binding == 0L) {
                if (this.videoToCreateBinding == video) {
                    this.videoToCreateBinding = null;
                } else {
                    this.videoToReleaseBinding = video;
                }
            } else if (this.videoToCreateBinding == video) {
                this.videoToCreateBinding = null;
            } else {
                this.videoToReleaseBinding = video;
                if (this.videoToCreateBinding == null) {
                    this.unregisterViewAndReleaseBinding();
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap captureFrame(int causeId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mBindingRenderer == null) {
                Log.error(TAG, "captureFrame: no GLES renderer, causeId: 0x%08x", causeId);
                return null;
            }
            return this.mBindingRenderer.captureFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBindingCreated(long bindingRef) {
        Object object = this.lock;
        synchronized (object) {
            Log.debug1(this.tag(), "onBindingCreated binding %d view %d", bindingRef, System.identityHashCode(this.mView));
            this.binding = bindingRef;
            this.unregisterViewAndReleaseBinding();
            this.mCb.onBindingAttached();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBindingReleased() {
        Object object = this.lock;
        synchronized (object) {
            Log.debug1(this.tag(), "onBindingReleased binding %d view %d", this.binding, System.identityHashCode(this.mView));
            this.binding = 0L;
            this.registerViewAndCreateBinding();
            this.dispose();
            this.mCb.onBindingDetached();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBindingFailed() {
        Object object = this.lock;
        synchronized (object) {
            Log.debug1(this.tag(), "onBindingFailed view %d", System.identityHashCode(this.mView));
            this.videoToReleaseBinding = null;
            if (!this.registerViewAndCreateBinding()) {
                this.isBindingFailed = true;
            }
            this.dispose();
            this.mCb.onBindingFailed();
        }
    }

    public void onSizeChanged(int w, int h) {
        Log.debug1(this.tag(), "onSizeChanged wxh: %d x %d view %d", w, h, System.identityHashCode(this.mView));
        this.mCb.onSizeChanged((View)this.mView, w, h);
    }

    public void onRoiChanged(float roiXOffset, float roiYOffset, float roiWidth, float roiHeight) {
    }

    public void onFirstFrameRendered() {
        Log.debug1(this.tag(), "onFirstFrameRendered view %d", System.identityHashCode(this.mView));
        this.mCb.onFirstFrameRendered((View)this.mView);
    }

    private void dispose() {
        boolean isBindingRendererNeeded;
        boolean bl = isBindingRendererNeeded = this.binding != 0L || this.mVideo != null || this.videoToCreateBinding != null || this.videoToReleaseBinding != null;
        if (!isBindingRendererNeeded && this.mBindingRenderer != null) {
            Log.debug1(this.tag(), "dispose bindingRenderer for view %d", System.identityHashCode(this.mView));
            this.mBindingRenderer.dispose();
            this.mBindingRenderer = null;
            this.isBindingFailed = false;
            this.bindingType = 0;
            this.bindingEvent = 0L;
        }
        if (!this.isViewAcquired && this.mBindingRenderer == null) {
            Log.debug1(this.tag(), "dispose view %d", System.identityHashCode(this.mView));
            this.mCb.onRendererDisposed(this, (View)this.mView);
            if (this.mView != null) {
                this.mView.dispose();
                this.mView = null;
            }
        }
    }

    private boolean registerViewAndCreateBinding() {
        if (this.videoToCreateBinding != null) {
            Log.debug1(this.tag(), "RegisterViewAndCreateBinding videoObjId %d view %d", this.videoToCreateBinding.getId(), System.identityHashCode(this.mView));
            if (this.mBindingRenderer != null) {
                this.mBindingRenderer.registerView((Object)this.mView);
            }
            this.videoToCreateBinding.createBinding(this.bindingType, this.bindingEvent);
            this.videoToCreateBinding = null;
            return true;
        }
        return false;
    }

    private boolean unregisterViewAndReleaseBinding() {
        if (this.videoToReleaseBinding != null) {
            Log.debug1(this.tag(), "UnregisterViewAndReleaseBinding binding %d videoObjId %d view %d", this.binding, this.videoToReleaseBinding.getId(), System.identityHashCode(this.mView));
            if (this.mBindingRenderer != null) {
                this.mBindingRenderer.unregisterView((Object)this.mView);
            }
            this.videoToReleaseBinding.releaseBinding(this.binding);
            this.videoToReleaseBinding = null;
            return true;
        }
        return false;
    }

    public static interface Callback {
        public void onBindingAttached();

        public void onBindingDetached();

        public void onBindingFailed();

        public void onSizeChanged(View var1, int var2, int var3);

        public void onFirstFrameRendered(View var1);

        public void onRendererDisposed(VideoRenderer var1, View var2);
    }
}

