/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CameraFacing;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.VideoDeviceType;

public final class VideoDeviceInfo {
    long handle;

    VideoDeviceInfo(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_video_device_info_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_device_info_release(this.handle));
        this.handle = 0L;
    }

    public String getName() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_device_info_get_name(this.handle, result));
        return (String)result.value;
    }

    public String getId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_device_info_get_id(this.handle, result));
        return (String)result.value;
    }

    public CameraFacing getCameraFacing() {
        Out<CameraFacing> result = new Out<CameraFacing>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_device_info_get_camera_facing(this.handle, result));
        return (CameraFacing)((Object)result.value);
    }

    public VideoDeviceType getDeviceType() {
        Out<VideoDeviceType> result = new Out<VideoDeviceType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_device_info_get_device_type(this.handle, result));
        return (VideoDeviceType)((Object)result.value);
    }
}

