/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import java.util.ArrayList;
import java.util.List;

public final class TranscriptionCallFeature
extends CallFeature {
    private List<PropertyChangedListener> OnIsTranscriptionActiveChangedListeners = new ArrayList<PropertyChangedListener>();

    TranscriptionCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    TranscriptionCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public boolean isTranscriptionActive() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_transcription_call_feature_get_is_transcription_active(this.handle, result));
        return (Boolean)result.value;
    }

    private static void OnIsTranscriptionActiveChangedStaticHandler(long cookie, long args) {
        TranscriptionCallFeature instance = TranscriptionCallFeature.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? ProjectedObjectCache.getOrCreate(args, ModelClass.PropertyChangedEvent, PropertyChangedEvent.class, false) : null;
            for (PropertyChangedListener listener : instance.OnIsTranscriptionActiveChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnIsTranscriptionActiveChangedListener(PropertyChangedListener listener) {
        this.OnIsTranscriptionActiveChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsTranscriptionActiveChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_transcription_call_feature_set_on_is_transcription_active_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsTranscriptionActiveChangedListener(PropertyChangedListener listener) {
        this.OnIsTranscriptionActiveChangedListeners.remove(listener);
        ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsTranscriptionActiveChanged", listener);
    }

    private static TranscriptionCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TranscriptionCallFeature, TranscriptionCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsTranscriptionActiveChanged")) {
            this.addOnIsTranscriptionActiveChangedListener((PropertyChangedListener)eventListener);
        }
    }
}

