/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import java.util.ArrayList;
import java.util.List;

public final class RecordingCallFeature
extends CallFeature {
    private List<PropertyChangedListener> OnIsRecordingActiveChangedListeners = new ArrayList<PropertyChangedListener>();

    RecordingCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    RecordingCallFeature(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public boolean isRecordingActive() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_recording_call_feature_get_is_recording_active(this.handle, result));
        return (Boolean)result.value;
    }

    private static void OnIsRecordingActiveChangedStaticHandler(long cookie, long args) {
        RecordingCallFeature instance = RecordingCallFeature.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? ProjectedObjectCache.getOrCreate(args, ModelClass.PropertyChangedEvent, PropertyChangedEvent.class, false) : null;
            for (PropertyChangedListener listener : instance.OnIsRecordingActiveChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnIsRecordingActiveChangedListener(PropertyChangedListener listener) {
        this.OnIsRecordingActiveChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIsRecordingActiveChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_recording_call_feature_set_on_is_recording_active_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnIsRecordingActiveChangedListener(PropertyChangedListener listener) {
        this.OnIsRecordingActiveChangedListeners.remove(listener);
        ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIsRecordingActiveChanged", listener);
    }

    private static RecordingCallFeature getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RecordingCallFeature, RecordingCallFeature.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIsRecordingActiveChanged")) {
            this.addOnIsRecordingActiveChangedListener((PropertyChangedListener)eventListener);
        }
    }
}

