/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import com.azure.android.communication.calling.IInternalPreviewRenderer;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.VideoStreamRenderer;
import com.skype.android.video.capture.UiPreviewBinding;
import java.util.concurrent.atomic.AtomicBoolean;

final class InternalPreviewRenderer
implements IInternalPreviewRenderer,
UiPreviewBinding.Callback {
    private static final String TAG = "InternalPreviewRenderer";
    private VideoStreamRenderer renderer;
    private UiPreviewBinding previewBinding;
    private AtomicBoolean previewBindingCreated;
    private final Object previewBindingLock = new Object();
    private SurfaceTexture currentSurfaceTexture;

    public InternalPreviewRenderer(VideoStreamRenderer renderer) {
        this.renderer = renderer;
        this.previewBindingCreated = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createBinding(LocalVideoStream stream) {
        Log.debug1(TAG, "startPreview videoObjId @%016x", stream.getHandle());
        Object object = this.previewBindingLock;
        synchronized (object) {
            if (this.previewBindingCreated.compareAndSet(false, true)) {
                if (this.previewBinding == null) {
                    this.previewBinding = new UiPreviewBinding(new Handler(Looper.getMainLooper()), (UiPreviewBinding.Callback)this);
                }
                UiPreviewBinding.BindingParams params = this.previewBinding.setup();
                stream.createBinding(params.type, params.event);
                if (this.currentSurfaceTexture != null) {
                    this.previewBinding.setSurface(this.currentSurfaceTexture);
                }
                return true;
            }
        }
        Log.debug1(TAG, "Not creating binding, already created", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseBinding(LocalVideoStream stream) {
        Log.debug1(TAG, "stopPreview videoObjId @%016x", stream.getHandle());
        Object object = this.previewBindingLock;
        synchronized (object) {
            if (this.previewBindingCreated.compareAndSet(true, false)) {
                UiPreviewBinding.BindingParams params = this.previewBinding.destroy();
                stream.releaseBinding(params.type, params.event);
                this.previewBinding = null;
                return true;
            }
        }
        Log.warn(TAG, "Trying to stopPreview, binding wasn't created: @%016x", stream.getHandle());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachSurface(SurfaceTexture surfaceTexture) {
        Log.debug1(TAG, "attachSurface: @%016x", System.identityHashCode(surfaceTexture));
        Object object = this.previewBindingLock;
        synchronized (object) {
            this.currentSurfaceTexture = surfaceTexture;
            if (this.previewBinding != null) {
                this.previewBinding.setSurface(this.currentSurfaceTexture);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachSurface(SurfaceTexture surfaceTexture) {
        Log.debug1(TAG, "detachSurface @%016x", System.identityHashCode(surfaceTexture));
        Object object = this.previewBindingLock;
        synchronized (object) {
            this.currentSurfaceTexture = null;
            if (this.previewBinding != null) {
                this.previewBinding.setSurface(null);
            }
        }
    }

    public void onFrameSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        Log.debug1(TAG, "onFrameSizeChanged width: %d, height: %d, surfaceTexture: @%016x", width, height, System.identityHashCode(surfaceTexture));
        this.renderer.onFrameSizeChanged(surfaceTexture, width, height);
    }

    public void onPreviewSurfaceUnset(SurfaceTexture surfaceTexture) {
        Log.debug1(TAG, "onPreviewSurfaceUnset @%016x", System.identityHashCode(surfaceTexture));
        this.renderer.onPreviewSurfaceUnset(surfaceTexture);
    }

    public void onBindingFailed() {
        Log.debug1(TAG, "onBindingFailed", new Object[0]);
        this.renderer.onBindingFailed();
    }
}

