/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.common.CommunicationCloudEnvironment;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.communication.common.CommunicationUserIdentifier;
import com.azure.android.communication.common.MicrosoftTeamsUserIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;
import com.azure.android.communication.common.UnknownIdentifier;
import java.util.ArrayList;
import java.util.List;

class IdentifierHelpers {
    IdentifierHelpers() {
    }

    static String[] convertIdentifiersToMris(Iterable<CommunicationIdentifier> iterableIdentifiers) {
        ArrayList<String> identifiersList = new ArrayList<String>();
        for (CommunicationIdentifier communicationIdentifier : iterableIdentifiers) {
            identifiersList.add(IdentifierHelpers.toMRI(communicationIdentifier));
        }
        String[] identifiers = new String[identifiersList.size()];
        return identifiersList.toArray(identifiers);
    }

    static List<CommunicationIdentifier> convertMrisToIdentifiers(String[] mris) {
        ArrayList<CommunicationIdentifier> identifiersList = new ArrayList<CommunicationIdentifier>();
        for (String mri : mris) {
            identifiersList.add(IdentifierHelpers.from(mri));
        }
        return identifiersList;
    }

    static CommunicationIdentifier from(String mri) {
        if (mri.startsWith("4:")) {
            return new PhoneNumberIdentifier(mri.substring(2));
        }
        if (mri.startsWith("8:orgid")) {
            return new MicrosoftTeamsUserIdentifier(mri, false).setCloudEnvironment(CommunicationCloudEnvironment.PUBLIC);
        }
        if (mri.startsWith("8:dod")) {
            return new MicrosoftTeamsUserIdentifier(mri, false).setCloudEnvironment(CommunicationCloudEnvironment.DOD);
        }
        if (mri.startsWith("8:gcch")) {
            return new MicrosoftTeamsUserIdentifier(mri, false).setCloudEnvironment(CommunicationCloudEnvironment.GCCH);
        }
        if (mri.startsWith("8:teamsvisitor")) {
            return new MicrosoftTeamsUserIdentifier(mri, false);
        }
        if (mri.startsWith("8:")) {
            return new CommunicationUserIdentifier(mri);
        }
        return new UnknownIdentifier(mri);
    }

    static String toMRI(CommunicationIdentifier identifier) {
        if (identifier instanceof CommunicationUserIdentifier) {
            return ((CommunicationUserIdentifier)identifier).getId();
        }
        if (identifier instanceof PhoneNumberIdentifier) {
            return "4:" + ((PhoneNumberIdentifier)identifier).getPhoneNumber();
        }
        if (identifier instanceof MicrosoftTeamsUserIdentifier) {
            return ((MicrosoftTeamsUserIdentifier)identifier).getUserId();
        }
        return ((UnknownIdentifier)identifier).getId();
    }
}

