/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.status;

public final class EmergencyCallOptions {
    long handle;

    EmergencyCallOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_emergency_call_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public EmergencyCallOptions() {
        Out<Long> result_handle = new Out<Long>();
        status resultStatus = NativeLibrary.sam_emergency_call_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_emergency_call_options_release(this.handle));
        this.handle = 0L;
    }

    public String getCountryCode() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_emergency_call_options_get_country_code(this.handle, result));
        return (String)result.value;
    }

    public EmergencyCallOptions setCountryCode(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_emergency_call_options_set_country_code(this.handle, value));
        return this;
    }
}

