/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.AudioOptions;
import com.azure.android.communication.calling.Call;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.CallsUpdatedEvent;
import com.azure.android.communication.calling.CallsUpdatedListener;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.IncomingCall;
import com.azure.android.communication.calling.IncomingCallListener;
import com.azure.android.communication.calling.JoinCallOptions;
import com.azure.android.communication.calling.JoinMeetingLocator;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PushNotificationInfo;
import com.azure.android.communication.calling.StartCallOptions;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class CallAgent {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;
    private List<CallsUpdatedListener> OnCallsUpdatedListeners = new ArrayList<CallsUpdatedListener>();
    private List<IncomingCallListener> OnIncomingCallListeners = new ArrayList<IncomingCallListener>();

    CallAgent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_agent_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    CallAgent(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_release(this.handle));
        this.handle = 0L;
    }

    public List<Call> getCalls() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_get_calls(this.handle, result, result_length));
        ArrayList<Call> resultList = new ArrayList<Call>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ProjectedObjectCache.getOrCreate(resultArray[i], ModelClass.Call, Call.class, true));
        }
        List<Call> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private static void OnCallsUpdatedStaticHandler(long cookie, long args) {
        CallAgent instance = CallAgent.getInstance(cookie);
        if (instance != null) {
            CallsUpdatedEvent args_converted = args != 0L ? ProjectedObjectCache.getOrCreate(args, ModelClass.CallsUpdatedEvent, CallsUpdatedEvent.class, false) : null;
            for (CallsUpdatedListener listener : instance.OnCallsUpdatedListeners) {
                listener.onCallsUpdated(args_converted);
            }
        }
    }

    public void addOnCallsUpdatedListener(CallsUpdatedListener listener) {
        this.OnCallsUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCallsUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_set_on_calls_updated(this.handle, this.getHandle(), this));
    }

    public void removeOnCallsUpdatedListener(CallsUpdatedListener listener) {
        this.OnCallsUpdatedListeners.remove(listener);
        ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCallsUpdated", listener);
    }

    private static void OnIncomingCallStaticHandler(long cookie, long incomingCall) {
        CallAgent instance = CallAgent.getInstance(cookie);
        if (instance != null) {
            IncomingCall incomingCall_converted = incomingCall != 0L ? ProjectedObjectCache.getOrCreate(incomingCall, ModelClass.IncomingCall, IncomingCall.class, false) : null;
            for (IncomingCallListener listener : instance.OnIncomingCallListeners) {
                listener.onIncomingCall(incomingCall_converted);
            }
        }
    }

    public void addOnIncomingCallListener(IncomingCallListener listener) {
        this.OnIncomingCallListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnIncomingCall", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_set_on_incoming_call(this.handle, this.getHandle(), this));
    }

    public void removeOnIncomingCallListener(IncomingCallListener listener) {
        this.OnIncomingCallListeners.remove(listener);
        ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnIncomingCall", listener);
    }

    public void dispose() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_dispose(this.handle));
    }

    private Call startCallWithContext(Context context, String[] participants, StartCallOptions options) {
        long options_converted = options != null ? options.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_start_call_with_context(this.handle, context, participants, participants.length, options_converted, result_handle));
        Call result_object = (Long)result_handle.value != 0L ? ProjectedObjectCache.getOrCreate((Long)result_handle.value, ModelClass.Call, Call.class, true) : null;
        return result_object;
    }

    private CompletableFuture<Void> registerPushNotificationInternal(final String deviceToken) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_agent_register_push_notification_internal(handle, deviceToken));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> handlePushNotification(final PushNotificationInfo notification) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long notification_converted = notification != null ? notification.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_agent_handle_push_notification(handle, notification_converted));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> unregisterPushNotification() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_agent_unregister_push_notification(handle));
            }
        }, (Executor)executor);
    }

    private Call joinInternal(JoinMeetingLocator meetingLocator, JoinCallOptions joinCallOptions) {
        long meetingLocator_converted = meetingLocator != null ? meetingLocator.getHandle() : 0L;
        long joinCallOptions_converted = joinCallOptions != null ? joinCallOptions.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_agent_join_internal(this.handle, meetingLocator_converted, joinCallOptions_converted, result_handle));
        Call result_object = (Long)result_handle.value != 0L ? ProjectedObjectCache.getOrCreate((Long)result_handle.value, ModelClass.Call, Call.class, true) : null;
        return result_object;
    }

    private static CallAgent getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallAgent, CallAgent.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCallsUpdated")) {
            this.addOnCallsUpdatedListener((CallsUpdatedListener)eventListener);
        }
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnIncomingCall")) {
            this.addOnIncomingCallListener((IncomingCallListener)eventListener);
        }
    }

    public Call startCall(Context context, Iterable<CommunicationIdentifier> participants, StartCallOptions startCallOptions) {
        String[] participantsStrings = IdentifierHelpers.convertIdentifiersToMris(participants);
        PermissionUtility.throwIfNotAppropriatePermissions(context, startCallOptions != null ? startCallOptions.getVideoOptions() : null, startCallOptions != null ? startCallOptions.getAudioOptions() : null);
        return this.startCallWithContext(context, participantsStrings, startCallOptions);
    }

    public Call startCall(Context context, Iterable<CommunicationIdentifier> participants) {
        String[] participantsStrings = IdentifierHelpers.convertIdentifiersToMris(participants);
        StartCallOptions callWithAudioOnly = new StartCallOptions();
        AudioOptions audioOptions = new AudioOptions();
        audioOptions.setMuted(false);
        callWithAudioOnly.setAudioOptions(audioOptions);
        PermissionUtility.throwIfNotAppropriatePermissions(context, null, audioOptions);
        return this.startCallWithContext(context, participantsStrings, callWithAudioOnly);
    }

    public Call join(Context context, JoinMeetingLocator meetingLocator, JoinCallOptions joinCallOptions) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, joinCallOptions != null ? joinCallOptions.getVideoOptions() : null, joinCallOptions != null ? joinCallOptions.getAudioOptions() : null);
        return this.joinInternal(meetingLocator, joinCallOptions);
    }

    public CompletableFuture<Void> registerPushNotification(String deviceRegistrationToken) {
        if (deviceRegistrationToken == null || deviceRegistrationToken.trim().length() == 0) {
            throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN);
        }
        return this.registerPushNotificationInternal(deviceRegistrationToken);
    }
}

