/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

abstract class BasePrivateDictionary<TKey, TValue>
implements Map<TKey, TValue> {
    BasePrivateDictionary() {
    }

    abstract int InternalGetCount();

    abstract TKey InternalGetKey(int var1);

    abstract TValue InternalGetItem(TKey var1);

    abstract void InternalSetItem(TKey var1, TValue var2);

    abstract void InternalRemoveKey(TKey var1);

    @Override
    public void clear() {
        while (this.size() > 0) {
            TKey key = this.InternalGetKey(0);
            this.InternalRemoveKey(key);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.InternalGetItem(key);
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.InternalGetCount(); ++i) {
            TKey key = this.InternalGetKey(i);
            if (!key.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<TKey, TValue>> entrySet() {
        TreeSet<Map.Entry<TKey, TValue>> set = new TreeSet<Map.Entry<TKey, TValue>>();
        for (int i = 0; i < this.InternalGetCount(); ++i) {
            TKey key = this.InternalGetKey(i);
            TValue value = this.InternalGetItem(key);
            set.add(new Entry(key, value));
        }
        return set;
    }

    @Override
    public TValue get(Object key) {
        return this.InternalGetItem(key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    @Override
    public Set<TKey> keySet() {
        TreeSet<TKey> set = new TreeSet<TKey>();
        for (int i = 0; i < this.InternalGetCount(); ++i) {
            TKey key = this.InternalGetKey(i);
            set.add(key);
        }
        return set;
    }

    @Override
    public TValue put(TKey key, TValue value) {
        this.InternalSetItem(key, value);
        return value;
    }

    @Override
    public void putAll(Map<? extends TKey, ? extends TValue> m) {
        for (TKey key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public TValue remove(Object key) {
        TValue value = this.get(key);
        if (value != null) {
            this.InternalRemoveKey(key);
        }
        return value;
    }

    @Override
    public int size() {
        return this.InternalGetCount();
    }

    @Override
    public Collection<TValue> values() {
        TreeSet<TValue> set = new TreeSet<TValue>();
        for (Map.Entry<TKey, TValue> entry : this.entrySet()) {
            set.add(entry.getValue());
        }
        return set;
    }

    private class Entry
    implements Map.Entry<TKey, TValue> {
        private final TKey key;
        private TValue value;

        Entry(TKey key, TValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public TKey getKey() {
            return this.key;
        }

        @Override
        public TValue getValue() {
            return this.value;
        }

        @Override
        public TValue setValue(TValue value) {
            Object old = this.value;
            this.value = value;
            return old;
        }
    }
}

