/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.loading;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ayvytr.customview.R;
import com.ayvytr.customview.loading.StatusView;

public class StatusView
extends RelativeLayout {
    public static final int LOADING = 0;
    public static final int ERROR = 1;
    public static final int EMPTY = 2;
    public static final int CONTENT = -1;
    private RelativeLayout.LayoutParams defaultLp;
    private int mStatus = -1;
    private View loadingView;
    private View errorView;
    private View emptyView;
    private View.OnClickListener onLoadingClickListener;
    private View.OnClickListener onErrorClickListener;
    private View.OnClickListener onEmptyClickListener;
    private OnStatusClickListener onStatusClickListener;

    public StatusView(Context context) {
        this(context, null);
    }

    public StatusView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(attrs, defStyleAttr, R.style.LoadingViewDefaultStyle);
    }

    @RequiresApi(api=21)
    public StatusView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(attrs, defStyleAttr, defStyleRes);
    }

    private void initView(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.getDefaultLayoutParams();
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.StatusView, defStyleAttr, defStyleRes);
        int loadingLayoutId = ta.getResourceId(R.styleable.StatusView_loadingView, R.layout.layout_loading);
        this.loadingView = LayoutInflater.from((Context)this.getContext()).inflate(loadingLayoutId, (ViewGroup)this, false);
        this.addView(this.loadingView, 0, (ViewGroup.LayoutParams)this.defaultLp);
        this.loadingView.setVisibility(8);
        int errorLayoutId = ta.getResourceId(R.styleable.StatusView_errorView, R.layout.layout_error);
        this.errorView = LayoutInflater.from((Context)this.getContext()).inflate(errorLayoutId, (ViewGroup)this, false);
        this.addView(this.errorView, 1, (ViewGroup.LayoutParams)this.defaultLp);
        this.errorView.setVisibility(8);
        int emptyLayoutId = ta.getResourceId(R.styleable.StatusView_emptyView, R.layout.layout_empty);
        this.emptyView = LayoutInflater.from((Context)this.getContext()).inflate(emptyLayoutId, (ViewGroup)this, false);
        this.addView(this.emptyView, 2, (ViewGroup.LayoutParams)this.defaultLp);
        this.emptyView.setVisibility(8);
        this.mStatus = ta.getInt(R.styleable.StatusView_status, -1);
        ta.recycle();
        this.initStatus();
        this.resetDefaultMsg();
        this.initListener();
        this.attachLoadingClickListener();
        this.attachErrorClickListener();
        this.attachEmptyClickListener();
    }

    private void initStatus() {
        switch (this.mStatus) {
            case 0: {
                this.showLoading();
                break;
            }
            case 1: {
                this.showError();
                break;
            }
            case 2: {
                this.showEmpty();
                break;
            }
            case -1: {
                this.showContent();
                break;
            }
        }
    }

    private RelativeLayout.LayoutParams getDefaultLayoutParams() {
        if (this.defaultLp == null) {
            this.defaultLp = new RelativeLayout.LayoutParams(-1, -1);
            this.defaultLp.addRule(13);
        }
        return this.defaultLp;
    }

    private void attachEmptyClickListener() {
        this.emptyView.setOnClickListener(this.onEmptyClickListener);
    }

    private void attachErrorClickListener() {
        this.errorView.setOnClickListener(this.onErrorClickListener);
    }

    private void attachLoadingClickListener() {
        this.loadingView.setOnClickListener(this.onLoadingClickListener);
    }

    private void initListener() {
        this.onLoadingClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (StatusView.this.onStatusClickListener != null) {
                    StatusView.this.onStatusClickListener.onLoading(StatusView.this);
                }
            }
        };
        this.onErrorClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (StatusView.this.onStatusClickListener != null) {
                    StatusView.this.onStatusClickListener.onError(StatusView.this);
                }
            }
        };
        this.onEmptyClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (StatusView.this.onStatusClickListener != null) {
                    StatusView.this.onStatusClickListener.onEmpty(StatusView.this);
                }
            }
        };
    }

    private void setMsgByTargetView(@Nullable String msg, @NonNull View targetView) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        TextView tvMsg = (TextView)targetView.findViewById(R.id.tv_msg);
        if (tvMsg != null) {
            tvMsg.setText((CharSequence)msg);
        }
    }

    public void showLoading() {
        this.showLoading(null);
    }

    public View getLoadingView() {
        return this.loadingView;
    }

    public View getErrorView() {
        return this.errorView;
    }

    public View getEmptyView() {
        return this.emptyView;
    }

    public void showLoading(@Nullable String msg) {
        Log.e((String)"tag", (String)"showLoading");
        this.setMsgByTargetView(msg, this.loadingView);
        if (this.mStatus != 0) {
            this.mStatus = 0;
            this.getEmptyView().setVisibility(8);
            this.getErrorView().setVisibility(8);
            if (this.loadingView.getVisibility() != 0) {
                this.loadingView.setVisibility(0);
            }
            this.hideContentView();
        }
    }

    private void showContentView() {
        for (int i = 3; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 0) continue;
            child.setVisibility(0);
        }
    }

    private void hideContentView() {
        for (int i = 3; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.setVisibility(8);
        }
    }

    public void showError() {
        this.showError(null);
    }

    public void showError(@Nullable String msg) {
        this.setMsgByTargetView(msg, this.errorView);
        if (this.mStatus != 1) {
            this.mStatus = 1;
            this.getLoadingView().setVisibility(8);
            this.getEmptyView().setVisibility(8);
            if (this.errorView.getVisibility() != 0) {
                this.errorView.setVisibility(0);
            }
            this.hideContentView();
        }
    }

    public void showEmpty() {
        this.showEmpty(null);
    }

    public void showEmpty(@Nullable String msg) {
        this.setMsgByTargetView(msg, this.emptyView);
        if (this.mStatus != 2) {
            this.mStatus = 2;
            this.getLoadingView().setVisibility(8);
            this.getErrorView().setVisibility(8);
            if (this.emptyView.getVisibility() != 0) {
                this.emptyView.setVisibility(0);
            }
            this.hideContentView();
        }
    }

    @Status
    public int getCurrentStatus() {
        return this.mStatus;
    }

    public void showContent() {
        if (this.mStatus != -1) {
            this.mStatus = -1;
            this.getLoadingView().setVisibility(8);
            this.getErrorView().setVisibility(8);
            this.getEmptyView().setVisibility(8);
            this.showContentView();
        }
    }

    public void resetDefaultMsg() {
        this.setMsgByTargetView(this.getContext().getString(R.string.loading_loading), this.loadingView);
        this.setMsgByTargetView(this.getContext().getString(R.string.loading_error), this.errorView);
        this.setMsgByTargetView(this.getContext().getString(R.string.loading_empty), this.emptyView);
    }

    private View inflateView(int layoutId) {
        return LayoutInflater.from((Context)this.getContext()).inflate(layoutId, (ViewGroup)this, false);
    }

    public void setLoadingView(@LayoutRes int layoutId) {
        this.setLoadingView(this.inflateView(layoutId));
    }

    public void setLoadingView(@NonNull View loadingView) {
        this.removeView(this.loadingView);
        this.loadingView = loadingView;
        if (this.mStatus != 0) {
            this.loadingView.setVisibility(8);
        }
        this.addView(this.loadingView, 0, (ViewGroup.LayoutParams)this.getDefaultLayoutParams());
        this.attachLoadingClickListener();
    }

    public void setErrorView(@LayoutRes int layoutId) {
        this.setErrorView(this.inflateView(layoutId));
    }

    public void setErrorView(@NonNull View errorView) {
        this.removeView(this.errorView);
        this.errorView = errorView;
        if (this.mStatus != 1) {
            this.errorView.setVisibility(8);
        }
        this.addView(this.errorView, 1, (ViewGroup.LayoutParams)this.getDefaultLayoutParams());
        this.attachErrorClickListener();
    }

    public void setEmptyView(@LayoutRes int layoutId) {
        this.setEmptyView(this.inflateView(layoutId));
    }

    public void setEmptyView(@NonNull View emptyView) {
        this.removeView(this.emptyView);
        this.emptyView = emptyView;
        if (this.mStatus != 2) {
            this.emptyView.setVisibility(8);
        }
        this.addView(this.emptyView, 2, (ViewGroup.LayoutParams)this.getDefaultLayoutParams());
        this.attachEmptyClickListener();
    }

    public void setOnStatusClickListener(OnStatusClickListener onStatusClickListener) {
        this.onStatusClickListener = onStatusClickListener;
    }

    public static interface OnStatusClickListener {
        public void onLoading(StatusView var1);

        public void onError(StatusView var1);

        public void onEmpty(StatusView var1);
    }
}

