/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.custom.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.ayvytr.customview.R;
import com.ayvytr.customview.util.DensityUtil;

public class VerificationCodeEditText
extends AppCompatEditText
implements TextWatcher {
    public static final String DEFAULT_PASSWORD_TEXT = "*";
    private int mMaxLength;
    private int mTextBgMargin;
    private int mTextBgSelectedColor;
    private int mTextBgColor;
    private float mTextBgStrokeWidth;
    private OnVerificationCodeChangedListener onCodeChangedListener;
    private int mCurrentPosition = 0;
    private int mEachRectLength = 0;
    private Paint mBottomSelectedPaint;
    private Paint mBottomNormalPaint;
    private int mSelectedTextColor;
    private boolean mIsPassword;
    private String mPasswordText = "*";
    private TextBgType mTextBgType;

    public VerificationCodeEditText(Context context) {
        this(context, null);
    }

    public VerificationCodeEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerificationCodeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
        this.initPaint();
        this.setFocusableInTouchMode(true);
        super.addTextChangedListener((TextWatcher)this);
    }

    private void initPaint() {
        this.mBottomSelectedPaint = new Paint();
        this.mBottomNormalPaint = new Paint();
        this.mBottomSelectedPaint.setColor(this.mTextBgSelectedColor);
        this.mBottomNormalPaint.setColor(this.mTextBgColor);
        if (this.mTextBgType == TextBgType.STROKE) {
            this.mBottomNormalPaint.setStyle(Paint.Style.STROKE);
            this.mBottomSelectedPaint.setStyle(Paint.Style.STROKE);
            this.mBottomSelectedPaint.setStrokeWidth(this.mTextBgStrokeWidth);
            this.mBottomNormalPaint.setStrokeWidth(this.mTextBgStrokeWidth);
        } else if (this.mTextBgType == TextBgType.FILL) {
            this.mBottomNormalPaint.setStyle(Paint.Style.FILL);
            this.mBottomSelectedPaint.setStyle(Paint.Style.FILL);
            this.mBottomSelectedPaint.setStrokeWidth(0.0f);
            this.mBottomNormalPaint.setStrokeWidth(0.0f);
        } else {
            this.mBottomSelectedPaint.setStrokeWidth(this.mTextBgStrokeWidth);
            this.mBottomNormalPaint.setStrokeWidth(this.mTextBgStrokeWidth);
            this.mBottomNormalPaint.setStyle(Paint.Style.STROKE);
            this.mBottomSelectedPaint.setStyle(Paint.Style.STROKE);
        }
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.VerificationCodeEditText);
        this.mMaxLength = ta.getInteger(R.styleable.VerificationCodeEditText_android_maxLength, 6);
        if (this.mMaxLength <= 0) {
            this.mMaxLength = 6;
        }
        this.mTextBgMargin = ta.getDimensionPixelSize(R.styleable.VerificationCodeEditText_textBgMargin, DensityUtil.dp2px(this.getContext(), 10));
        this.mTextBgSelectedColor = ta.getColor(R.styleable.VerificationCodeEditText_textBgSelectedColor, this.getCurrentTextColor());
        this.mTextBgColor = ta.getColor(R.styleable.VerificationCodeEditText_textBgColor, this.getColor(0x1060000));
        this.mTextBgStrokeWidth = ta.getDimension(R.styleable.VerificationCodeEditText_textBgStrokeWidth, (float)DensityUtil.dp2px(this.getContext(), 5));
        this.mSelectedTextColor = ta.getColor(R.styleable.VerificationCodeEditText_selectedTextColor, this.getCurrentTextColor());
        int inputType = ta.getInt(R.styleable.VerificationCodeEditText_android_inputType, 2);
        this.setInputType(inputType);
        String passwordText = ta.getString(R.styleable.VerificationCodeEditText_passwordText);
        this.setPasswordText(passwordText);
        Drawable drawable2 = ta.getDrawable(R.styleable.VerificationCodeEditText_android_background);
        if (drawable2 == null) {
            this.setBackgroundDrawable(null);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
        this.mTextBgType = TextBgType.valueOf(ta.getInt(R.styleable.VerificationCodeEditText_textBgType, 0));
        ta.recycle();
        this.setCursorVisible(false);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setLayoutDirection(0);
        }
    }

    private void setPasswordText(String passwordText) {
        if (TextUtils.isEmpty((CharSequence)passwordText) || this.mPasswordText.equals(passwordText) || passwordText.length() > 1) {
            return;
        }
        this.mPasswordText = passwordText;
        this.postInvalidate();
    }

    public void setInputType(int type) {
        this.setPasswordMode((type & 0x10) != 0);
    }

    private void setPasswordMode(boolean isPassword) {
        this.mIsPassword = isPassword;
        if (isPassword) {
            super.setInputType(18);
        } else {
            super.setInputType(2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = widthMode == 0 ? this.getSuggestedMinimumWidth() : View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.mEachRectLength = (widthSize - this.mTextBgMargin * (this.mMaxLength - 1)) / this.mMaxLength;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else {
            int dp50 = DensityUtil.dp2px(this.getContext(), 50);
            heightSize = (int)Math.max((double)this.getTextSize() * 1.5, (double)dp50);
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.requestFocus();
            this.setSelection(this.getText().length());
            this.showKeyBoard(this.getContext());
            return false;
        }
        return super.onTouchEvent(event);
    }

    protected void onDraw(Canvas canvas) {
        int start;
        int length = this.getText().length();
        this.mCurrentPosition = length > 0 ? length - 1 : 0;
        int width = this.mEachRectLength;
        int height = this.getMeasuredHeight();
        for (int i = 0; i < this.mMaxLength; ++i) {
            canvas.save();
            float lineY = (float)height - this.mTextBgStrokeWidth / 2.0f;
            start = width * i + i * this.mTextBgMargin;
            int end = width + start;
            if (i == this.mCurrentPosition) {
                if (this.mTextBgType == TextBgType.UNDERLINE) {
                    canvas.drawLine((float)start, lineY, (float)end, lineY, this.mBottomSelectedPaint);
                } else {
                    canvas.drawRect((float)start, 0.0f, (float)end, (float)height, this.mBottomSelectedPaint);
                }
            } else if (this.mTextBgType == TextBgType.UNDERLINE) {
                canvas.drawLine((float)start, lineY, (float)end, lineY, this.mBottomNormalPaint);
            } else {
                canvas.drawRect((float)start, 0.0f, (float)end, (float)height, this.mBottomNormalPaint);
            }
            canvas.restore();
        }
        String value = this.getText().toString();
        for (int i = 0; i < value.length(); ++i) {
            float baseline;
            canvas.save();
            start = width * i + i * this.mTextBgMargin;
            float x = start + width / 2;
            TextPaint paint = this.getPaint();
            paint.setTextAlign(Paint.Align.CENTER);
            paint.setColor(i == this.mCurrentPosition ? this.mSelectedTextColor : this.getCurrentTextColor());
            Paint.FontMetrics fontMetrics = paint.getFontMetrics();
            if (this.mIsPassword) {
                baseline = fontMetrics.bottom - fontMetrics.ascent;
                canvas.drawText(this.mPasswordText, x, baseline, (Paint)paint);
            } else {
                baseline = ((float)height - fontMetrics.bottom + fontMetrics.top) / 2.0f - fontMetrics.top;
                canvas.drawText(String.valueOf(value.charAt(i)), x, baseline, (Paint)paint);
            }
            canvas.restore();
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.postInvalidate();
        if (this.onCodeChangedListener != null) {
            this.onCodeChangedListener.onTextChanged((CharSequence)this.getText(), start, before, count);
        }
    }

    public void afterTextChanged(Editable s) {
        if (this.getText().length() == this.mMaxLength) {
            if (this.onCodeChangedListener != null) {
                this.onCodeChangedListener.onCompleted((CharSequence)this.getText());
            }
        } else if (this.getText().length() > this.mMaxLength) {
            this.getText().delete(this.mMaxLength, this.getText().length());
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.setSelection(this.getText().length());
        }
    }

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
        this.postInvalidate();
    }

    public void setBottomLineMargin(int margin) {
        if (margin >= 0 && this.mTextBgMargin != margin) {
            this.mTextBgMargin = margin;
            this.postInvalidate();
        }
    }

    public void setBottomSelectedColor(@ColorRes int bottomSelectedColor) {
        this.mTextBgSelectedColor = this.getColor(bottomSelectedColor);
        this.postInvalidate();
    }

    public void setBottomNormalColor(@ColorRes int bottomNormalColor) {
        this.mTextBgSelectedColor = this.getColor(bottomNormalColor);
        this.postInvalidate();
    }

    public void setBottomLineHeight(int bottomLineHeight) {
        this.mTextBgStrokeWidth = bottomLineHeight;
        this.postInvalidate();
    }

    public void setOnVerificationTextChangedListener(OnVerificationCodeChangedListener listener) {
        this.onCodeChangedListener = listener;
    }

    private int getColor(@ColorRes int color2) {
        return ContextCompat.getColor((Context)this.getContext(), (int)color2);
    }

    public void showKeyBoard(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.showSoftInput((View)this, 2);
    }

    public void setTextBgType(TextBgType type) {
        this.mTextBgType = type;
        this.initPaint();
        this.postInvalidate();
    }

    public static interface OnVerificationCodeChangedListener {
        public void onTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void onCompleted(CharSequence var1);
    }

    public static enum TextBgType {
        UNDERLINE,
        STROKE,
        FILL;


        public static TextBgType valueOf(int i) {
            switch (i) {
                case 1: {
                    return STROKE;
                }
                case 2: {
                    return FILL;
                }
            }
            return UNDERLINE;
        }
    }
}

