/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.util.inputfilter;

import android.text.InputFilter;
import android.text.Spanned;

public class DecimalDigitsInputFilter
implements InputFilter {
    private int decimalDigits;
    public static final int DEFAULT_DECIMAL_DIGITS = 2;

    public DecimalDigitsInputFilter() {
        this(2);
    }

    public DecimalDigitsInputFilter(int decimalDigits) {
        this.setDecimalDigits(decimalDigits);
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits > 0 ? decimalDigits : 2;
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        String dotValue;
        int diff;
        if ("".equals(source.toString())) {
            return null;
        }
        String dValue = dest.toString();
        String[] splitArray = dValue.split("\\.");
        if (splitArray.length > 1 && (diff = (dotValue = splitArray[1]).length() + 1 - this.decimalDigits) > 0) {
            return source.subSequence(start, end - diff);
        }
        return null;
    }
}

