/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtil {
    private BitmapUtil() {
        throw new UnsupportedOperationException();
    }

    private static Bitmap toBitmap1(Drawable drawable2) {
        BitmapDrawable bd = (BitmapDrawable)drawable2;
        return bd.getBitmap();
    }

    private static Bitmap toBitmap2(Drawable drawable2) {
        int w = drawable2.getIntrinsicWidth();
        int h = drawable2.getIntrinsicHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, w, h);
        drawable2.draw(canvas);
        return bitmap;
    }

    public static Bitmap toBitmap(Drawable drawable2) {
        try {
            return BitmapUtil.toBitmap1(drawable2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BitmapUtil.toBitmap2(drawable2);
        }
    }

    public static Bitmap toBitmap(byte[] bytes) {
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static byte[] toByteArray(Drawable drawable2) {
        return BitmapUtil.toByteArray(BitmapUtil.toBitmap(drawable2));
    }

    public static byte[] toByteArray(Bitmap bitmap) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)b);
        byte[] bytes = b.toByteArray();
        try {
            b.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }
}

