/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.custom.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.ayvytr.customview.R;
import com.ayvytr.customview.util.DensityUtil;
import com.ayvytr.customview.util.DrawableUtil;
import com.ayvytr.customview.util.ResUtil;

public class PasswordEditText
extends AppCompatEditText {
    private int defaultPwdDrawableArea;
    private boolean isDrawableShowing;
    private boolean isShowingPwd;
    private Drawable showPasswordDrawable;
    private Drawable hidePasswordDrawable;
    private boolean handlingHoverEvent;
    private boolean clickMode;
    private boolean showDrawableNoFocus;

    public PasswordEditText(Context context) {
        this(context, null);
    }

    public PasswordEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.editTextStyle);
    }

    public PasswordEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.defaultPwdDrawableArea = DensityUtil.dp2px(this.getContext(), 32);
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.PasswordEditText);
        this.showPasswordDrawable = ta.getDrawable(R.styleable.PasswordEditText_showPasswordDrawable);
        if (this.showPasswordDrawable == null) {
            this.showPasswordDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_show_password);
        }
        DrawableUtil.setBounds(this.showPasswordDrawable);
        this.hidePasswordDrawable = ta.getDrawable(R.styleable.PasswordEditText_hidePasswordDrawable);
        if (this.hidePasswordDrawable == null) {
            this.hidePasswordDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_hide_password);
        }
        DrawableUtil.setBounds(this.hidePasswordDrawable);
        this.clickMode = ta.getBoolean(R.styleable.PasswordEditText_clickMode, false);
        this.showDrawableNoFocus = ta.getBoolean(R.styleable.PasswordEditText_showDrawableNoFocus, false);
        ta.recycle();
        if (!PasswordEditText.isPasswordInputType(this.getInputType())) {
            this.setInputType(129);
        }
        int defaultRightPadding = DensityUtil.dp2px(this.getContext(), 5);
        if (this.getPaddingRight() < defaultRightPadding) {
            this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), defaultRightPadding, this.getPaddingBottom());
        }
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PasswordEditText.this.onPasswordDrawableChanged();
            }
        });
        this.onPasswordDrawableChanged();
    }

    public Drawable getShowPasswordDrawable() {
        return this.showPasswordDrawable;
    }

    public Drawable getHidePasswordDrawable() {
        return this.hidePasswordDrawable;
    }

    public void setShowPasswordDrawable(@NonNull Drawable showPasswordDrawable) {
        if (showPasswordDrawable == null || this.showPasswordDrawable == showPasswordDrawable) {
            return;
        }
        this.showPasswordDrawable = showPasswordDrawable;
        DrawableUtil.setBounds(showPasswordDrawable);
        this.onPasswordDrawableChanged();
    }

    public void setShowPasswordDrawable(@DrawableRes int showPasswordDrawableId) {
        this.setShowPasswordDrawable(ResUtil.getDrawable(this.getContext(), showPasswordDrawableId));
    }

    public void setHidePasswordDrawable(Drawable hidePasswordDrawable) {
        if (hidePasswordDrawable == null || this.hidePasswordDrawable == hidePasswordDrawable) {
            return;
        }
        this.hidePasswordDrawable = hidePasswordDrawable;
        DrawableUtil.setBounds(hidePasswordDrawable);
        this.onPasswordDrawableChanged();
    }

    public void setHidePasswordDrawable(@DrawableRes int hidePasswordDrawableId) {
        this.setHidePasswordDrawable(ResUtil.getDrawable(this.getContext(), hidePasswordDrawableId));
    }

    public void setClickMode(boolean clickMode) {
        if (this.clickMode != clickMode) {
            this.clickMode = clickMode;
        }
    }

    public void setShowDrawableNoFocus(boolean showDrawableNoFocus) {
        if (this.showDrawableNoFocus != showDrawableNoFocus) {
            this.showDrawableNoFocus = showDrawableNoFocus;
            this.onPasswordDrawableChanged();
        }
    }

    public boolean isShowDrawableNoFocus() {
        return this.showDrawableNoFocus;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int iconXRect = this.getWidth() - this.getPaddingRight() - this.defaultPwdDrawableArea;
        if (!this.isDrawableShowing || x < iconXRect) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                if (this.clickMode) break;
                event.setAction(3);
                this.handlingHoverEvent = true;
                this.handlePasswordVisibility();
                break;
            }
            case 1: {
                if (!this.clickMode) {
                    if (!this.handlingHoverEvent) break;
                    event.setAction(3);
                    this.handlingHoverEvent = false;
                    this.handlePasswordVisibility();
                    break;
                }
                this.handlePasswordVisibility();
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        this.onPasswordDrawableChanged();
    }

    private void handlePasswordVisibility() {
        this.isShowingPwd = !this.isShowingPwd;
        this.onPasswordDrawableChanged();
        this.setTransformationMethod((TransformationMethod)(this.isShowingPwd ? null : PasswordTransformationMethod.getInstance()));
        this.setSelection(this.getText().length());
    }

    public static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    private void onPasswordDrawableChanged() {
        boolean isNotEmpty = !this.getText().toString().isEmpty();
        this.isDrawableShowing = isNotEmpty && (this.showDrawableNoFocus || this.hasFocus());
        Drawable[] cs = this.getCompoundDrawables();
        if (this.isDrawableShowing) {
            this.setCompoundDrawables(cs[0], cs[1], this.isShowingPwd ? this.showPasswordDrawable : this.hidePasswordDrawable, cs[3]);
        } else {
            this.setCompoundDrawables(cs[0], cs[1], null, cs[3]);
        }
    }
}

