/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.custom.index;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.ayvytr.customview.R;
import com.ayvytr.customview.util.DensityUtil;
import com.ayvytr.customview.util.ResUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QuickIndexView
extends View {
    private static final int DEFAULT_WIDTH_DP = 50;
    private Paint paint;
    @ColorInt
    private int textColor;
    private int textSize;
    private List<String> indexList;
    private OnLetterChangeListener onLetterChangeListener;
    private int gravity;
    private int bottomTextY;
    private int topTextY;
    private int lineSpacing;

    public QuickIndexView(Context context) {
        this(context, null);
    }

    public QuickIndexView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QuickIndexView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTextAlign(Paint.Align.CENTER);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.QuickIndexView);
        this.textColor = typedArray.getColor(R.styleable.QuickIndexView_android_textColor, -1979711488);
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.QuickIndexView_android_textSize, -1);
        this.setBackgroundDrawable(typedArray.getDrawable(R.styleable.QuickIndexView_android_background));
        this.gravity = typedArray.getInt(R.styleable.QuickIndexView_android_gravity, 17);
        this.lineSpacing = typedArray.getDimensionPixelSize(R.styleable.QuickIndexView_android_lineSpacingExtra, 0);
        CharSequence[] textArray = typedArray.getTextArray(R.styleable.QuickIndexView_indexArray);
        if (textArray != null) {
            this.indexList = new ArrayList<String>();
            for (CharSequence charSequence : textArray) {
                this.indexList.add(charSequence.toString());
            }
        } else {
            this.setIndexArray(ResUtil.getStringArray(this.getContext(), R.array.defaultQuickIndexViewLetters));
        }
        typedArray.recycle();
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        if (this.textSize == textSize || textSize < 0) {
            return;
        }
        this.textSize = textSize;
        this.invalidate();
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int gravity) {
        if (gravity != this.gravity && (gravity == 48 || gravity == 17 || gravity == 16)) {
            this.gravity = gravity;
            this.invalidate();
        }
    }

    public List<String> getIndexList() {
        return this.indexList;
    }

    public void setIndexList(List<String> indexList) {
        if (indexList != null) {
            this.indexList = indexList;
            this.invalidate();
        }
    }

    public void clearIndexList() {
        this.indexList.clear();
        this.invalidate();
    }

    public void setIndexArray(String[] letterArray) {
        if (letterArray == null || letterArray.length == 0) {
            return;
        }
        this.indexList.clear();
        this.indexList.addAll(Arrays.asList(letterArray));
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (widthMode == Integer.MIN_VALUE) {
            width = DensityUtil.dp2px(this.getContext(), 50);
        }
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.calcMaxTextSize();
        this.calcMaxLineSpacing();
        this.paint.setColor(this.textColor);
        this.paint.setTextSize((float)this.textSize);
        int y = this.getPaddingTop();
        int x = this.getWidth() >> 1;
        int size = this.indexList.size();
        if (this.gravity == 17 || this.gravity == 16) {
            y = this.getHeight() - this.getPaddingTop() - size * (this.textSize + this.lineSpacing) >> 1 + this.getPaddingTop();
        }
        this.topTextY = y;
        y += this.lineSpacing >> 1;
        Paint.FontMetrics fontMetrics = this.paint.getFontMetrics();
        int halfLetterLength = this.textSize >> 1;
        int fontY = (int)((float)halfLetterLength - fontMetrics.top / 2.0f - fontMetrics.bottom / 2.0f);
        for (int i = 0; i < size; ++i) {
            canvas.drawText(this.indexList.get(i), (float)x, (float)(y + fontY), this.paint);
            y += this.textSize;
            if (i == size - 1) {
                y += this.lineSpacing >> 1;
                continue;
            }
            y += this.lineSpacing;
        }
        this.bottomTextY = y;
    }

    private void calcMaxLineSpacing() {
        if (this.indexList.isEmpty()) {
            return;
        }
        int maxLineSpacing = (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.textSize * this.indexList.size()) / this.indexList.size();
        if (this.lineSpacing > maxLineSpacing) {
            this.lineSpacing = maxLineSpacing;
        }
    }

    private void calcMaxTextSize() {
        int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int letterCount = this.getIndexList().size();
        if (letterCount == 0) {
            return;
        }
        int maxTextSize = Math.min(width, (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / letterCount);
        if (this.textSize == -1) {
            this.textSize = maxTextSize;
        }
        if (this.textSize > maxTextSize) {
            this.textSize = maxTextSize;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getY() < (float)this.topTextY || event.getY() > (float)this.bottomTextY) {
            return true;
        }
        switch (event.getAction()) {
            case 0: 
            case 2: {
                int index = (int)((event.getY() - (float)this.topTextY) / (float)(this.textSize + this.lineSpacing));
                if (this.onLetterChangeListener == null) break;
                this.onLetterChangeListener.onLetterChange(index, this.indexList.get(index), this);
                break;
            }
            case 1: {
                break;
            }
        }
        return true;
    }

    protected void onDetachedFromWindow() {
        this.paint = null;
        super.onDetachedFromWindow();
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int lineSpacing) {
        if (lineSpacing >= 0) {
            this.lineSpacing = lineSpacing;
            this.invalidate();
        }
    }

    public void setOnLetterChangeListener(OnLetterChangeListener onLetterChangeListener) {
        this.onLetterChangeListener = onLetterChangeListener;
    }

    public static interface OnLetterChangeListener {
        public void onLetterChange(int var1, String var2, QuickIndexView var3);
    }
}

