/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.custom.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.ayvytr.customview.R;
import com.ayvytr.customview.util.DensityUtil;
import com.ayvytr.customview.util.ResUtil;

public class ClearableEditText
extends AppCompatEditText
implements View.OnTouchListener,
TextWatcher {
    private Drawable clearTextDrawable;
    private View.OnTouchListener mOnTouchListener;
    private boolean showClearDrawableNoFocus;

    public ClearableEditText(Context context) {
        this(context, null);
    }

    public ClearableEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.editTextStyle);
    }

    public ClearableEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.mOnTouchListener = onTouchListener;
    }

    private void init(AttributeSet attrs) {
        Drawable[] cd = this.getCompoundDrawables();
        this.clearTextDrawable = cd[2] == null ? DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_text_clear_light)) : cd[2];
        DrawableCompat.setTint((Drawable)this.clearTextDrawable, (int)this.getCurrentHintTextColor());
        this.clearTextDrawable.setBounds(0, 0, this.clearTextDrawable.getIntrinsicHeight(), this.clearTextDrawable.getIntrinsicHeight());
        super.setOnTouchListener((View.OnTouchListener)this);
        this.addTextChangedListener(this);
        int padding = DensityUtil.dp2px(this.getContext(), 5);
        if (this.getCompoundDrawablePadding() <= 0) {
            this.setCompoundDrawablePadding(padding);
        }
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ClearableEditText);
        this.showClearDrawableNoFocus = a.getBoolean(R.styleable.ClearableEditText_showClearDrawableNoFocus, false);
        a.recycle();
        this.onClearIconVisibleChanged();
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        this.onClearIconVisibleChanged();
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int x = (int)motionEvent.getX();
        if (this.clearTextDrawable.isVisible() && x > this.getWidth() - this.getPaddingRight() - this.clearTextDrawable.getIntrinsicWidth()) {
            if (motionEvent.getAction() == 1) {
                this.setError(null);
                this.setText("");
            }
            return true;
        }
        return this.mOnTouchListener != null && this.mOnTouchListener.onTouch(view, motionEvent);
    }

    public final void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
        this.onClearIconVisibleChanged();
    }

    private void onClearIconVisibleChanged() {
        boolean visible = this.showClearDrawableNoFocus ? this.getText().length() > 0 : this.isFocused() && this.getText().length() > 0;
        this.clearTextDrawable.setVisible(visible, false);
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        this.setCompoundDrawables(compoundDrawables[0], compoundDrawables[1], visible ? this.clearTextDrawable : null, compoundDrawables[3]);
    }

    public Drawable getClearTextDrawable() {
        return this.clearTextDrawable;
    }

    public void setClearTextDrawable(@NonNull Drawable clearTextDrawable) {
        if (clearTextDrawable == null || this.clearTextDrawable == clearTextDrawable) {
            return;
        }
        this.clearTextDrawable = clearTextDrawable;
        clearTextDrawable.setBounds(0, 0, clearTextDrawable.getIntrinsicHeight(), clearTextDrawable.getIntrinsicHeight());
        this.onClearIconVisibleChanged();
    }

    public void setClearTextDrawable(@DrawableRes int drawableId) {
        this.clearTextDrawable = ResUtil.getDrawable(this.getContext(), drawableId);
        this.clearTextDrawable.setBounds(0, 0, this.clearTextDrawable.getIntrinsicHeight(), this.clearTextDrawable.getIntrinsicHeight());
        this.onClearIconVisibleChanged();
    }

    public boolean isShowClearDrawableNoFocus() {
        return this.showClearDrawableNoFocus;
    }

    public void setShowClearDrawableNoFocus(boolean showClearDrawableNoFocus) {
        if (this.showClearDrawableNoFocus != showClearDrawableNoFocus) {
            this.showClearDrawableNoFocus = showClearDrawableNoFocus;
            this.onClearIconVisibleChanged();
        }
    }
}

