/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.custom.text;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.KeyListener;
import android.text.method.NumberKeyListener;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.ayvytr.customview.R;
import com.ayvytr.customview.util.DensityUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuperEditText
extends LinearLayout {
    private EditText etInput;
    private ImageView ivClear;
    private ImageButton ibEye;
    private TextWatcher filterChineseWatcher;
    private boolean showClearIcon;

    public SuperEditText(Context context) {
        this(context, null);
    }

    public SuperEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuperEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        View.inflate((Context)this.getContext(), (int)R.layout.layout_clearable_edittext, (ViewGroup)this);
        this.etInput = (EditText)this.findViewById(R.id.et_input);
        this.ivClear = (ImageView)this.findViewById(R.id.iv_clear);
        this.ibEye = (ImageButton)this.findViewById(R.id.ib_eye_pwd);
        this.ivClear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SuperEditText.this.etInput.setText(null);
            }
        });
        if (attrs != null) {
            int paddingRight;
            int paddingTop;
            int maxLength;
            Drawable drawable2;
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.SuperEditText);
            this.setEnabled(ta.getBoolean(R.styleable.SuperEditText_android_enabled, true));
            this.etInput.setText((CharSequence)ta.getString(R.styleable.SuperEditText_android_text));
            int inputType = ta.getInt(R.styleable.SuperEditText_android_inputType, 1);
            this.etInput.setInputType(inputType);
            boolean showEyeIcon = ta.getBoolean(R.styleable.SuperEditText_switchShowPassword, false);
            this.showEyeIcon(showEyeIcon);
            this.etInput.setHint((CharSequence)ta.getString(R.styleable.SuperEditText_android_hint));
            int color = ta.getColor(R.styleable.SuperEditText_android_textColor, -1);
            if (color != -1) {
                this.etInput.setTextColor(color);
            }
            if ((color = ta.getColor(R.styleable.SuperEditText_android_textColorHint, -1)) != -1) {
                this.etInput.setHintTextColor(color);
            }
            if ((drawable2 = ta.getDrawable(R.styleable.SuperEditText_android_background)) != null) {
                this.etInput.setBackgroundDrawable(drawable2);
            }
            if ((maxLength = ta.getInt(R.styleable.SuperEditText_android_maxLength, -1)) > 0) {
                this.etInput.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
            }
            int paddingLeft = 0;
            int tempPadding = ta.getDimensionPixelSize(R.styleable.SuperEditText_textPadding, DensityUtil.dp2px(this.getContext(), -1));
            if (tempPadding != -1) {
                paddingRight = paddingTop = tempPadding;
                paddingLeft = paddingTop;
                int n = paddingTop;
            }
            if ((tempPadding = ta.getDimensionPixelSize(R.styleable.SuperEditText_textPaddingLeft, -1)) != -1) {
                paddingLeft = tempPadding;
            }
            paddingRight = ta.getDimensionPixelSize(R.styleable.SuperEditText_textPaddingRight, -1);
            if (tempPadding != -1) {
                paddingRight = tempPadding;
            }
            paddingTop = ta.getDimensionPixelSize(R.styleable.SuperEditText_textPaddingTop, -1);
            if (tempPadding != -1) {
                paddingTop = tempPadding;
            }
            int paddingBottom = ta.getDimensionPixelSize(R.styleable.SuperEditText_textPaddingBottom, -1);
            if (tempPadding != -1) {
                paddingBottom = tempPadding;
            }
            this.etInput.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            final String digits = ta.getString(R.styleable.SuperEditText_android_digits);
            if (digits != null) {
                this.etInput.setKeyListener((KeyListener)new NumberKeyListener(){

                    @NonNull
                    protected char[] getAcceptedChars() {
                        return digits.toCharArray();
                    }

                    public int getInputType() {
                        return 144;
                    }
                });
            }
            this.showClearIcon = ta.getBoolean(R.styleable.SuperEditText_showClearIcon, true);
            this.addClearTextWatcher();
            boolean filterChinese = ta.getBoolean(R.styleable.SuperEditText_filterChinese, false);
            if (filterChinese) {
                this.addChineseTextWatcher();
            }
            if ((drawable2 = ta.getDrawable(R.styleable.SuperEditText_clearIcon)) != null) {
                this.ivClear.setImageDrawable(drawable2);
            }
            ta.recycle();
            this.etInput.setEnabled(this.isEnabled());
            this.ivClear.setEnabled(this.isEnabled());
            this.ibEye.setEnabled(this.isEnabled());
        }
    }

    private void addClearTextWatcher() {
        TextWatcher textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (SuperEditText.this.showClearIcon) {
                    boolean isEmpty = s.toString().isEmpty();
                    SuperEditText.this.ivClear.setVisibility(isEmpty ? 8 : 0);
                }
            }
        };
        this.etInput.addTextChangedListener(textWatcher);
    }

    public void setFocusChangeListener(View.OnFocusChangeListener l) {
        this.etInput.setOnFocusChangeListener(l);
    }

    private void showEyeIcon(boolean showEyeIcon) {
        if (showEyeIcon) {
            this.ibEye.setVisibility(0);
            this.ibEye.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperEditText.this.ibEye.setSelected(!SuperEditText.this.ibEye.isSelected());
                    SuperEditText.this.etInput.setTransformationMethod((TransformationMethod)(SuperEditText.this.ibEye.isSelected() ? HideReturnsTransformationMethod.getInstance() : PasswordTransformationMethod.getInstance()));
                    SuperEditText.this.etInput.setSelection(SuperEditText.this.etInput.getText().length());
                }
            });
        } else {
            this.ibEye.setVisibility(8);
        }
    }

    private void addChineseTextWatcher() {
        if (this.filterChineseWatcher == null) {
            this.filterChineseWatcher = new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    String str;
                    String editable = SuperEditText.this.etInput.getText().toString();
                    if (!editable.equals(str = SuperEditText.this.filterChinese(editable))) {
                        SuperEditText.this.etInput.setText((CharSequence)str);
                        SuperEditText.this.etInput.setSelection(str.length());
                    }
                }

                public void afterTextChanged(Editable s) {
                    SuperEditText.this.ivClear.setVisibility(s.toString().isEmpty() ? 8 : 0);
                }
            };
        }
        this.etInput.removeTextChangedListener(this.filterChineseWatcher);
        this.etInput.addTextChangedListener(this.filterChineseWatcher);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.etInput.setEnabled(this.isEnabled());
        this.ivClear.setEnabled(this.isEnabled());
        this.ibEye.setEnabled(this.isEnabled());
    }

    public String getText() {
        return this.etInput.getText().toString();
    }

    public void setText(String text) {
        this.etInput.setText((CharSequence)text);
    }

    public void setText(@StringRes int id2) {
        this.etInput.setText(id2);
    }

    public void setHint(String hint) {
        this.etInput.setHint((CharSequence)hint);
    }

    public void setHint(@StringRes int id2) {
        this.etInput.setHint(id2);
    }

    public void setClearIcon(Drawable drawable2) {
        this.ivClear.setImageDrawable(drawable2);
    }

    public void setClearIcon(@DrawableRes int id2) {
        this.ivClear.setImageResource(id2);
    }

    public void addTextChangedListener(TextWatcher watcher) {
        this.etInput.addTextChangedListener(watcher);
    }

    public void setSelection(int index) {
        this.etInput.setSelection(index);
    }

    public void setKeyListener(KeyListener keyListener) {
        this.etInput.setKeyListener(keyListener);
    }

    protected String filterChinese(String str) {
        try {
            String regEx = "[^\u4e00-\u9fa5]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(str);
            return m.replaceAll("").trim();
        }
        catch (Exception e) {
            return str;
        }
    }
}

