/*
 * Decompiled with CFR 0.152.
 */
package com.ayvytr.customview.loading;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ayvytr.customview.R;
import com.ayvytr.customview.loading.StatusView;

public class StatusView
extends RelativeLayout {
    public static final int NONE = -1;
    public static final int CONTENT = 0;
    public static final int LOADING = 1;
    public static final int ERROR = 2;
    public static final int EMPTY = 3;
    private RelativeLayout.LayoutParams defaultLp;
    private int mStatus = -1;
    private View loadingView;
    private View errorView;
    private View emptyView;
    private View contentView;
    private View.OnClickListener onLoadingClickListener;
    private View.OnClickListener onErrorClickListener;
    private View.OnClickListener onEmptyClickListener;
    private OnStatusClickListener onStatusClickListener;

    public StatusView(Context context) {
        this(context, null);
    }

    public StatusView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(attrs, defStyleAttr, R.style.LoadingViewDefaultStyle);
    }

    @RequiresApi(api=21)
    public StatusView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(attrs, defStyleAttr, 0);
    }

    private void initView(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.getDefaultLayoutParams();
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.StatusView, defStyleAttr, defStyleRes);
        int loadingLayoutId = ta.getResourceId(R.styleable.StatusView_loadingView, R.layout.layout_loading);
        this.loadingView = LayoutInflater.from((Context)this.getContext()).inflate(loadingLayoutId, null);
        this.addView(this.loadingView, (ViewGroup.LayoutParams)this.defaultLp);
        int errorLayoutId = ta.getResourceId(R.styleable.StatusView_errorView, R.layout.layout_error);
        this.errorView = LayoutInflater.from((Context)this.getContext()).inflate(errorLayoutId, null);
        this.addView(this.errorView, (ViewGroup.LayoutParams)this.defaultLp);
        int emptyLayoutId = ta.getResourceId(R.styleable.StatusView_emptyView, R.layout.layout_empty);
        this.emptyView = LayoutInflater.from((Context)this.getContext()).inflate(emptyLayoutId, null);
        this.addView(this.emptyView, (ViewGroup.LayoutParams)this.defaultLp);
        int contentLayoutId = ta.getResourceId(R.styleable.StatusView_contentView, R.layout.layout_default_content);
        this.contentView = LayoutInflater.from((Context)this.getContext()).inflate(contentLayoutId, null);
        RelativeLayout.LayoutParams contentLp = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(this.contentView, (ViewGroup.LayoutParams)contentLp);
        int status = ta.getInt(R.styleable.StatusView_status, 1);
        this.setCurrentStatus(status);
        this.resetDefaultMsg();
        this.initListener();
        this.attachLoadingClickListener();
        this.attachErrorClickListener();
        this.attachEmptyClickListener();
        ta.recycle();
        this.hideAllViews();
        this.showLoading();
    }

    private RelativeLayout.LayoutParams getDefaultLayoutParams() {
        if (this.defaultLp == null) {
            this.defaultLp = new RelativeLayout.LayoutParams(-2, -2);
            this.defaultLp.addRule(13);
        }
        return this.defaultLp;
    }

    private void attachEmptyClickListener() {
        this.emptyView.setOnClickListener(this.onEmptyClickListener);
    }

    private void attachErrorClickListener() {
        this.errorView.setOnClickListener(this.onErrorClickListener);
    }

    private void attachLoadingClickListener() {
        this.loadingView.setOnClickListener(this.onLoadingClickListener);
    }

    private void initListener() {
        this.onLoadingClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (StatusView.this.onStatusClickListener != null) {
                    StatusView.this.onStatusClickListener.onLoading(StatusView.this);
                }
            }
        };
        this.onErrorClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (StatusView.this.onStatusClickListener != null) {
                    StatusView.this.onStatusClickListener.onError(StatusView.this);
                }
            }
        };
        this.onEmptyClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (StatusView.this.onStatusClickListener != null) {
                    StatusView.this.onStatusClickListener.onEmpty(StatusView.this);
                }
            }
        };
    }

    private void hideAllViews() {
        this.errorView.setVisibility(8);
        this.emptyView.setVisibility(8);
        this.loadingView.setVisibility(8);
        this.contentView.setVisibility(8);
        this.mStatus = -1;
    }

    private void setMsgByTargetView(@Nullable String msg, @NonNull View targetView) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        TextView tvMsg = (TextView)targetView.findViewById(R.id.tvMsg);
        if (tvMsg != null) {
            tvMsg.setText((CharSequence)msg);
        }
    }

    public void showLoading() {
        this.showLoading(null);
    }

    public void showLoading(@Nullable String msg) {
        this.setMsgByTargetView(msg, this.loadingView);
        if (this.mStatus == 1) {
            return;
        }
        this.hideAllViews();
        this.loadingView.setVisibility(0);
        this.mStatus = 1;
    }

    public void showError() {
        this.showError(null);
    }

    public void showError(@Nullable String msg) {
        this.setMsgByTargetView(msg, this.errorView);
        if (this.mStatus == 2) {
            return;
        }
        this.hideAllViews();
        this.errorView.setVisibility(0);
        this.mStatus = 2;
    }

    public void showEmpty() {
        this.showEmpty(null);
    }

    public void showEmpty(@Nullable String msg) {
        this.setMsgByTargetView(msg, this.emptyView);
        if (this.mStatus == 3) {
            return;
        }
        this.hideAllViews();
        this.emptyView.setVisibility(0);
        this.mStatus = 3;
    }

    @Status
    public int getCurrentStatus() {
        return this.mStatus;
    }

    public void setCurrentStatus(@Status int status) {
        switch (status) {
            case -1: {
                this.hideAllViews();
                break;
            }
            case 1: {
                this.showLoading();
                break;
            }
            case 2: {
                this.showError();
                break;
            }
            case 3: {
                this.showEmpty();
                break;
            }
            case 0: {
                this.showContent();
                break;
            }
        }
    }

    public void showContent() {
        if (this.mStatus == 0) {
            return;
        }
        this.hideAllViews();
        this.contentView.setVisibility(0);
        this.mStatus = 0;
    }

    public void resetDefaultMsg() {
        this.setMsgByTargetView(this.getContext().getString(R.string.loading_loading), this.loadingView);
        this.setMsgByTargetView(this.getContext().getString(R.string.loading_error), this.errorView);
        this.setMsgByTargetView(this.getContext().getString(R.string.loading_empty), this.emptyView);
    }

    public void setLoadingView(@NonNull View loadingView) {
        if (loadingView != null) {
            this.removeView(this.loadingView);
            this.loadingView = loadingView;
            if (this.mStatus != 1) {
                this.loadingView.setVisibility(8);
            }
            this.addView(this.loadingView, (ViewGroup.LayoutParams)this.getDefaultLayoutParams());
            this.attachLoadingClickListener();
        }
    }

    public void setErrorView(@NonNull View errorView) {
        if (errorView != null) {
            this.removeView(this.errorView);
            this.errorView = errorView;
            if (this.mStatus != 2) {
                this.errorView.setVisibility(8);
            }
            this.addView(this.errorView, (ViewGroup.LayoutParams)this.getDefaultLayoutParams());
            this.attachErrorClickListener();
        }
    }

    public void setEmptyView(@NonNull View emptyView) {
        if (emptyView != null) {
            this.removeView(this.emptyView);
            this.emptyView = emptyView;
            if (this.mStatus != 3) {
                this.emptyView.setVisibility(8);
            }
            this.addView(this.emptyView, (ViewGroup.LayoutParams)this.getDefaultLayoutParams());
            this.attachEmptyClickListener();
        }
    }

    public void setContentView(@NonNull View contentView) {
        if (contentView != null) {
            this.removeView(this.contentView);
            this.contentView = contentView;
            if (this.mStatus != 0) {
                this.contentView.setVisibility(8);
            }
            RelativeLayout.LayoutParams contentLp = new RelativeLayout.LayoutParams(-1, -1);
            this.addView(this.contentView, (ViewGroup.LayoutParams)contentLp);
        }
    }

    public void setOnStatusClickListener(OnStatusClickListener onStatusClickListener) {
        this.onStatusClickListener = onStatusClickListener;
    }

    public static interface OnStatusClickListener {
        public void onLoading(StatusView var1);

        public void onError(StatusView var1);

        public void onEmpty(StatusView var1);
    }
}

