/*
 * Decompiled with CFR 0.152.
 */
package com.aykuttasil.callrecord.helper;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class PrefsHelper {
    private static final String DEFAULT_STRING_VALUE = null;
    private static final int DEFAULT_INT_VALUE = 0;
    private static final boolean DEFAULT_BOOLEAN_VALUE = false;
    private Context mContext;
    private SharedPreferences mPref;

    public PrefsHelper(Context context, String pref_name) {
        this.mPref = context.getSharedPreferences(pref_name, 0);
    }

    public PrefsHelper(Context context) {
        this.mPref = PrefsHelper.getDefaultPreference(context);
    }

    public static SharedPreferences getDefaultPreference(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public static void writePrefString(Context context, String key, String value) {
        new PrefsHelper(context).getPrefEditor().putString(key, value).commit();
    }

    public static String readPrefString(Context context, String key) {
        return new PrefsHelper(context).getPreference().getString(key, DEFAULT_STRING_VALUE);
    }

    public static void writePrefInt(Context context, String key, int value) {
        new PrefsHelper(context).getPrefEditor().putInt(key, value).commit();
    }

    public static int readPrefInt(Context context, String key) {
        return new PrefsHelper(context).getPreference().getInt(key, 0);
    }

    public static void writePrefBool(Context context, String key, boolean value) {
        new PrefsHelper(context).getPrefEditor().putBoolean(key, value).commit();
    }

    public static boolean readPrefBool(Context context, String key) {
        return new PrefsHelper(context).getPreference().getBoolean(key, false);
    }

    public static void clearPreference(Context context) {
        new PrefsHelper(context).getPreference().edit().clear().apply();
    }

    public SharedPreferences getPreference() {
        return this.mPref;
    }

    public SharedPreferences.Editor getPrefEditor() {
        return this.getPreference().edit();
    }

    public class BooleanPreference {
        private final SharedPreferences preferences;
        private final String key;
        private final boolean defaultValue;

        public BooleanPreference(@NonNull SharedPreferences preferences, String key) {
            this(preferences, key, false);
        }

        public BooleanPreference(@NonNull SharedPreferences preferences, String key, boolean defaultValue) {
            this.preferences = preferences;
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public boolean get() {
            return this.preferences.getBoolean(this.key, this.defaultValue);
        }

        public boolean isSet() {
            return this.preferences.contains(this.key);
        }

        public void set(boolean value) {
            this.preferences.edit().putBoolean(this.key, value).apply();
        }

        public void delete() {
            this.preferences.edit().remove(this.key).apply();
        }
    }

    public class IntPreference {
        private final SharedPreferences preferences;
        private final String key;
        private final int defaultValue;

        public IntPreference(@NonNull SharedPreferences preferences, String key) {
            this(preferences, key, 0);
        }

        public IntPreference(@NonNull SharedPreferences preferences, String key, int defaultValue) {
            this.preferences = preferences;
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public int get() {
            return this.preferences.getInt(this.key, this.defaultValue);
        }

        public boolean isSet() {
            return this.preferences.contains(this.key);
        }

        public void set(int value) {
            this.preferences.edit().putInt(this.key, value).apply();
        }

        public void delete() {
            this.preferences.edit().remove(this.key).apply();
        }
    }

    public class StringPreference {
        private final SharedPreferences preferences;
        private final String key;
        private final String defaultValue;

        public StringPreference(@NonNull SharedPreferences preferences, String key) {
            this(preferences, key, null);
        }

        public StringPreference(@NonNull SharedPreferences preferences, @Nullable String key, String defaultValue) {
            this.preferences = preferences;
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Nullable
        public String get() {
            return this.preferences.getString(this.key, this.defaultValue);
        }

        public boolean isSet() {
            return this.preferences.contains(this.key);
        }

        public void set(@Nullable String value) {
            this.preferences.edit().putString(this.key, value).apply();
        }

        public void delete() {
            this.preferences.edit().remove(this.key).apply();
        }
    }

    public static class EnumPreference<E extends Enum<E>> {
        private final SharedPreferences preferences;
        private final Class<E> clazz;
        private final String key;
        private final E defaultValue;
        final /* synthetic */ PrefsHelper this$0;

        public EnumPreference(@NonNull SharedPreferences preferences, @NonNull Class<E> clazz, @NonNull String key, E defaultValue) {
            this.this$0 = this$0;
            this.preferences = preferences;
            this.clazz = clazz;
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @NonNull
        public E get() {
            String string = this.preferences.getString(this.key, null);
            return string != null ? Enum.valueOf(this.clazz, string) : this.defaultValue;
        }

        public boolean isSet() {
            return this.preferences.contains(this.key);
        }

        public void set(@Nullable E value) {
            this.preferences.edit().putString(this.key, value != null ? ((Enum)value).name() : null).apply();
        }

        public void delete() {
            this.preferences.edit().remove(this.key).apply();
        }
    }
}

