/*
 * Decompiled with CFR 0.152.
 */
package com.aykuttasil.callrecord.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import java.util.Date;

public abstract class PhoneCallReceiver
extends BroadcastReceiver {
    private static int lastState = 0;
    private static Date callStartTime;
    private static boolean isIncoming;
    private static String savedNumber;

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.NEW_OUTGOING_CALL")) {
            savedNumber = intent.getExtras().getString("android.intent.extra.PHONE_NUMBER");
        } else {
            String number;
            String stateStr = intent.getExtras().getString("state");
            savedNumber = number = intent.getExtras().getString("incoming_number");
            int state = 0;
            if (stateStr.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                state = 0;
            } else if (stateStr.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                state = 2;
            } else if (stateStr.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                state = 1;
            }
            this.onCallStateChanged(context, state, number);
        }
    }

    protected abstract void onIncomingCallReceived(Context var1, String var2, Date var3);

    protected abstract void onIncomingCallAnswered(Context var1, String var2, Date var3);

    protected abstract void onIncomingCallEnded(Context var1, String var2, Date var3, Date var4);

    protected abstract void onOutgoingCallStarted(Context var1, String var2, Date var3);

    protected abstract void onOutgoingCallEnded(Context var1, String var2, Date var3, Date var4);

    protected abstract void onMissedCall(Context var1, String var2, Date var3);

    public void onCallStateChanged(Context context, int state, String number) {
        if (lastState == state) {
            return;
        }
        switch (state) {
            case 1: {
                isIncoming = true;
                callStartTime = new Date();
                savedNumber = number;
                this.onIncomingCallReceived(context, number, callStartTime);
                break;
            }
            case 2: {
                if (lastState != 1) {
                    isIncoming = false;
                    callStartTime = new Date();
                    this.onOutgoingCallStarted(context, savedNumber, callStartTime);
                    break;
                }
                isIncoming = true;
                callStartTime = new Date();
                this.onIncomingCallAnswered(context, savedNumber, callStartTime);
                break;
            }
            case 0: {
                if (lastState == 1) {
                    this.onMissedCall(context, savedNumber, callStartTime);
                    break;
                }
                if (isIncoming) {
                    this.onIncomingCallEnded(context, savedNumber, callStartTime, new Date());
                    break;
                }
                this.onOutgoingCallEnded(context, savedNumber, callStartTime, new Date());
            }
        }
        lastState = state;
    }
}

