/*
 * Decompiled with CFR 0.152.
 */
package com.aykuttasil.callrecord.receiver;

import android.content.Context;
import android.media.MediaRecorder;
import android.util.Log;
import com.aykuttasil.callrecord.CallRecord;
import com.aykuttasil.callrecord.helper.PrefsHelper;
import com.aykuttasil.callrecord.receiver.PhoneCallReceiver;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class CallRecordReceiver
extends PhoneCallReceiver {
    private static final String TAG = CallRecordReceiver.class.getSimpleName();
    public static final String ACTION_IN = "android.intent.action.PHONE_STATE";
    public static final String ACTION_OUT = "android.intent.action.NEW_OUTGOING_CALL";
    public static final String EXTRA_PHONE_NUMBER = "android.intent.extra.PHONE_NUMBER";
    private static MediaRecorder recorder;
    private File audiofile;
    private boolean isRecordStarted = false;

    public CallRecordReceiver(CallRecord callRecord) {
        super(callRecord);
    }

    @Override
    protected void onIncomingCallReceived(Context ctx, CallRecord callRecord, String number, Date start) {
    }

    @Override
    protected void onIncomingCallAnswered(Context ctx, CallRecord callRecord, String number, Date start) {
        this.startRecord(ctx, "incoming", number);
    }

    @Override
    protected void onIncomingCallEnded(Context ctx, CallRecord callRecord, String number, Date start, Date end) {
        if (recorder != null && this.isRecordStarted) {
            recorder.stop();
            recorder.reset();
            recorder.release();
            this.isRecordStarted = false;
            Log.i((String)TAG, (String)"record stop");
        }
    }

    @Override
    protected void onOutgoingCallStarted(Context ctx, CallRecord callRecord, String number, Date start) {
        this.startRecord(ctx, "outgoing", number);
    }

    @Override
    protected void onOutgoingCallEnded(Context ctx, CallRecord callRecord, String number, Date start, Date end) {
        if (recorder != null && this.isRecordStarted) {
            recorder.stop();
            recorder.reset();
            recorder.release();
            this.isRecordStarted = false;
            Log.i((String)TAG, (String)"record stop");
        }
    }

    @Override
    protected void onMissedCall(Context ctx, CallRecord callRecord, String number, Date start) {
    }

    private void startRecord(Context context, String seed, String phoneNumber) {
        try {
            boolean isSaveFile = PrefsHelper.readPrefBool(context, "PrefSaveFile");
            Log.i((String)TAG, (String)("isSaveFile: " + isSaveFile));
            if (!isSaveFile) {
                return;
            }
            String file_name = PrefsHelper.readPrefString(context, "PrefFileName");
            String dir_path = PrefsHelper.readPrefString(context, "PrefDirPath");
            String dir_name = PrefsHelper.readPrefString(context, "PrefDirName");
            boolean show_seed = PrefsHelper.readPrefBool(context, "PrefShowSeed");
            boolean show_phone_number = PrefsHelper.readPrefBool(context, "PrefShowPhoneNumber");
            int output_format = PrefsHelper.readPrefInt(context, "PrefOutputFormat");
            int audio_source = PrefsHelper.readPrefInt(context, "PrefAudioSource");
            int audio_encoder = PrefsHelper.readPrefInt(context, "PrefAudioEncoder");
            File sampleDir = new File(dir_path + "/" + dir_name);
            if (!sampleDir.exists()) {
                sampleDir.mkdirs();
            }
            StringBuilder fileNameBuilder = new StringBuilder();
            fileNameBuilder.append(file_name);
            fileNameBuilder.append("_");
            if (show_seed) {
                fileNameBuilder.append(seed);
                fileNameBuilder.append("_");
            }
            if (show_phone_number) {
                fileNameBuilder.append(phoneNumber);
                fileNameBuilder.append("_");
            }
            file_name = fileNameBuilder.toString();
            String suffix = "";
            switch (output_format) {
                case 3: {
                    suffix = ".amr";
                    break;
                }
                case 4: {
                    suffix = ".amr";
                    break;
                }
                case 2: {
                    suffix = ".mp4";
                    break;
                }
                case 1: {
                    suffix = ".3gp";
                    break;
                }
                default: {
                    suffix = ".amr";
                }
            }
            this.audiofile = File.createTempFile(file_name, suffix, sampleDir);
            recorder = new MediaRecorder();
            recorder.setAudioSource(audio_source);
            recorder.setOutputFormat(output_format);
            recorder.setAudioEncoder(audio_encoder);
            recorder.setOutputFile(this.audiofile.getAbsolutePath());
            recorder.prepare();
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
        }
        recorder.start();
        this.isRecordStarted = true;
        Log.i((String)TAG, (String)"record start");
    }
}

