/*
 * Decompiled with CFR 0.152.
 */
package com.aykuttasil.callrecord;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;
import android.util.Log;
import com.aykuttasil.callrecord.helper.PrefsHelper;
import com.aykuttasil.callrecord.receiver.CallRecordReceiver;
import com.aykuttasil.callrecord.service.CallRecordService;

public class CallRecord {
    private static final String TAG = CallRecord.class.getSimpleName();
    public static final String PREF_SAVE_FILE = "PrefSaveFile";
    public static final String PREF_FILE_NAME = "PrefFileName";
    public static final String PREF_DIR_NAME = "PrefDirName";
    public static final String PREF_DIR_PATH = "PrefDirPath";
    public static final String PREF_SHOW_SEED = "PrefShowSeed";
    public static final String PREF_AUDIO_SOURCE = "PrefAudioSource";
    public static final String PREF_AUDIO_ENCODER = "PrefAudioEncoder";
    public static final String PREF_OUTPUT_FORMAT = "PrefOutputFormat";
    private Context mContext;
    private CallRecordReceiver mCallRecordReceiver;

    private CallRecord(Context context) {
        this.mContext = context;
        this.mCallRecordReceiver = new CallRecordReceiver();
    }

    public static CallRecord initReceiver(Context context) {
        CallRecord callRecord = new Builder(context).build();
        callRecord.startCallReceiver();
        return callRecord;
    }

    public static CallRecord initService(Context context) {
        CallRecord callRecord = new Builder(context).build();
        callRecord.startCallRecordService();
        return callRecord;
    }

    public void startCallReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        intentFilter.addAction("android.intent.action.NEW_OUTGOING_CALL");
        this.mContext.registerReceiver((BroadcastReceiver)this.mCallRecordReceiver, intentFilter);
    }

    public void stopCallReceiver() {
        try {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mCallRecordReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCallRecordService() {
        Intent intent = new Intent();
        intent.setClass(this.mContext, CallRecordService.class);
        this.mContext.startService(intent);
        Log.i((String)TAG, (String)"startService()");
    }

    public void enableSaveFile() {
        PrefsHelper.writePrefBool(this.mContext, PREF_SAVE_FILE, true);
        Log.i((String)"CallRecord", (String)"Save file enabled");
    }

    public void disableSaveFile() {
        Log.i((String)"CallRecord", (String)"Save file disabled");
        PrefsHelper.writePrefBool(this.mContext, PREF_SAVE_FILE, false);
    }

    public boolean getStateSaveFile() {
        return PrefsHelper.readPrefBool(this.mContext, PREF_SAVE_FILE);
    }

    public void changeRecordFileName(String newFileName) {
        if (newFileName == null || newFileName.isEmpty()) {
            try {
                throw new Exception("newFileName can not be empty or null");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        PrefsHelper.writePrefString(this.mContext, PREF_FILE_NAME, newFileName);
        Log.i((String)"CallRecord", (String)("New file name: " + newFileName));
    }

    public String getRecordFileName() {
        return PrefsHelper.readPrefString(this.mContext, PREF_FILE_NAME);
    }

    public void changeRecordDirName(String newDirName) {
        if (newDirName == null || newDirName.isEmpty()) {
            try {
                throw new Exception("newDirName can not be empty or null");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        PrefsHelper.writePrefString(this.mContext, PREF_DIR_NAME, newDirName);
        Log.i((String)"CallRecord", (String)("New dir name: " + newDirName));
    }

    public String getRecordDirName() {
        return PrefsHelper.readPrefString(this.mContext, PREF_DIR_NAME);
    }

    public void changeRecordDirPath(String newDirPath) {
        if (newDirPath == null || newDirPath.isEmpty()) {
            try {
                throw new Exception("newDirPath can not be empty or null");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        PrefsHelper.writePrefString(this.mContext, PREF_DIR_PATH, newDirPath);
        Log.i((String)"CallRecord", (String)("New dir path: " + newDirPath));
    }

    public String getRecordDirPath() {
        return PrefsHelper.readPrefString(this.mContext, PREF_DIR_PATH);
    }

    public static class Builder {
        private Context mContext;

        public Builder(Context context) {
            this.mContext = context;
            PrefsHelper.writePrefString(this.mContext, CallRecord.PREF_FILE_NAME, "Record");
            PrefsHelper.writePrefString(this.mContext, CallRecord.PREF_DIR_NAME, "CallRecord");
            PrefsHelper.writePrefString(this.mContext, CallRecord.PREF_DIR_PATH, Environment.getExternalStorageDirectory().getPath());
            PrefsHelper.writePrefInt(this.mContext, CallRecord.PREF_AUDIO_SOURCE, 7);
            PrefsHelper.writePrefInt(this.mContext, CallRecord.PREF_AUDIO_ENCODER, 1);
            PrefsHelper.writePrefInt(this.mContext, CallRecord.PREF_OUTPUT_FORMAT, 3);
            PrefsHelper.writePrefBool(this.mContext, CallRecord.PREF_SHOW_SEED, true);
        }

        public CallRecord build() {
            CallRecord callRecord = new CallRecord(this.mContext);
            callRecord.enableSaveFile();
            return callRecord;
        }

        public CallRecord buildService() {
            Intent intent = new Intent();
            CallRecord callRecord = new CallRecord(this.mContext);
            callRecord.enableSaveFile();
            return callRecord;
        }

        public Builder setRecordFileName(String recordFileName) {
            PrefsHelper.writePrefString(this.mContext, CallRecord.PREF_FILE_NAME, recordFileName);
            return this;
        }

        public String getRecordFileName() {
            return PrefsHelper.readPrefString(this.mContext, CallRecord.PREF_FILE_NAME);
        }

        public Builder setRecordDirName(String recordDirName) {
            PrefsHelper.writePrefString(this.mContext, CallRecord.PREF_DIR_NAME, recordDirName);
            return this;
        }

        public String getRecordDirName() {
            return PrefsHelper.readPrefString(this.mContext, CallRecord.PREF_DIR_NAME);
        }

        public int getAudioSource() {
            return PrefsHelper.readPrefInt(this.mContext, CallRecord.PREF_AUDIO_SOURCE);
        }

        public Builder setAudioSource(int audioSource) {
            PrefsHelper.writePrefInt(this.mContext, CallRecord.PREF_AUDIO_SOURCE, audioSource);
            return this;
        }

        public int getAudioEncoder() {
            return PrefsHelper.readPrefInt(this.mContext, CallRecord.PREF_AUDIO_ENCODER);
        }

        public Builder setAudioEncoder(int audioEncoder) {
            PrefsHelper.writePrefInt(this.mContext, CallRecord.PREF_AUDIO_ENCODER, audioEncoder);
            return this;
        }

        public int getOutputFormat() {
            return PrefsHelper.readPrefInt(this.mContext, CallRecord.PREF_OUTPUT_FORMAT);
        }

        public Builder setOutputFormat(int outputFormat) {
            PrefsHelper.writePrefInt(this.mContext, CallRecord.PREF_OUTPUT_FORMAT, outputFormat);
            return this;
        }

        public boolean isShowSeed() {
            return PrefsHelper.readPrefBool(this.mContext, CallRecord.PREF_SHOW_SEED);
        }

        public Builder setShowSeed(boolean showSeed) {
            PrefsHelper.writePrefBool(this.mContext, CallRecord.PREF_SHOW_SEED, showSeed);
            return this;
        }

        public String getRecordDirPath() {
            return PrefsHelper.readPrefString(this.mContext, CallRecord.PREF_DIR_PATH);
        }

        public Builder setRecordDirPath(String recordDirPath) {
            PrefsHelper.writePrefString(this.mContext, CallRecord.PREF_DIR_PATH, recordDirPath);
            return this;
        }
    }
}

