/*
 * Decompiled with CFR 0.152.
 */
package com.aykuttasil.callrecord.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.aykuttasil.callrecord.CallRecord;
import com.aykuttasil.callrecord.helper.PrefsHelper;
import java.io.File;
import java.io.IOException;

public class CallRecordReceiver
extends BroadcastReceiver {
    private static final String TAG = CallRecordReceiver.class.getSimpleName();
    public static final String ACTION_IN = "android.intent.action.PHONE_STATE";
    public static final String ACTION_OUT = "android.intent.action.NEW_OUTGOING_CALL";
    private static MediaRecorder recorder;
    private static boolean recordstarted;
    private static boolean wasRinging;
    Bundle bundle;
    File audiofile;
    Context mContext;
    private CallRecord.Builder mBuilder;
    private String inCall;
    private String outCall;
    private String state;

    public void setmBuilder(CallRecord.Builder mBuilder) {
        this.mBuilder = mBuilder;
    }

    public void onReceive(Context context, Intent intent) {
        try {
            this.mContext = context;
            this.bundle = intent.getExtras();
            if (this.bundle == null) {
                Log.e((String)TAG, (String)"Intent extras are null");
                return;
            }
            this.state = this.bundle.getString("state");
            Log.i((String)TAG, (String)(this.state == null ? "null" : this.state));
            if (intent.getAction().equals(ACTION_IN)) {
                Log.i((String)TAG, (String)ACTION_IN);
                if (this.state.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                    this.inCall = this.bundle.getString("incoming_number");
                    wasRinging = true;
                } else if (this.state.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                    if (wasRinging && !recordstarted) {
                        this.startRecord("incoming");
                        Log.i((String)TAG, (String)"start record");
                    }
                } else if (this.state.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                    wasRinging = false;
                    Log.i((String)TAG, (String)(recordstarted ? "recordstarted is true" : "recordstarted is false"));
                    if (recordstarted) {
                        recorder.stop();
                        recorder.reset();
                        recorder.release();
                        recordstarted = false;
                        Log.i((String)TAG, (String)"stop record");
                    }
                }
            } else if (intent.getAction().equals(ACTION_OUT)) {
                Log.i((String)TAG, (String)ACTION_OUT);
                this.bundle = intent.getExtras();
                if (this.bundle != null) {
                    this.outCall = intent.getStringExtra("android.intent.extra.PHONE_NUMBER");
                    if (!recordstarted) {
                        this.startRecord("outgoing");
                        Log.i((String)TAG, (String)"start record");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startRecord(String seed) {
        try {
            boolean isSaveFile = PrefsHelper.readPrefBool(this.mContext, "PrefSaveFile");
            Log.i((String)TAG, (String)("isSaveFile: " + isSaveFile));
            if (!isSaveFile) {
                return;
            }
            File sampleDir = new File(this.mBuilder.getRecordDirPath() + "/" + this.mBuilder.getRecordDirName());
            if (!sampleDir.exists()) {
                sampleDir.mkdirs();
            }
            String file_name = "";
            file_name = this.mBuilder.isShowSeed() ? this.mBuilder.getRecordFileName() + "_" + seed + "_" : this.mBuilder.getRecordFileName();
            String suffix = "";
            switch (this.mBuilder.getOutputFormat()) {
                case 3: {
                    suffix = ".amr";
                    break;
                }
                case 4: {
                    suffix = ".amr";
                    break;
                }
                case 2: {
                    suffix = ".mp4";
                    break;
                }
                case 1: {
                    suffix = ".3gp";
                    break;
                }
                default: {
                    suffix = ".amr";
                }
            }
            this.audiofile = File.createTempFile(file_name, suffix, sampleDir);
            recorder = new MediaRecorder();
            recorder.setAudioSource(this.mBuilder.getAudioSource());
            recorder.setOutputFormat(this.mBuilder.getOutputFormat());
            recorder.setAudioEncoder(this.mBuilder.getAudioEncoder());
            recorder.setOutputFile(this.audiofile.getAbsolutePath());
            recorder.prepare();
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
        }
        recorder.start();
        recordstarted = true;
        Log.i((String)TAG, (String)"record start");
    }

    static {
        recordstarted = false;
        wasRinging = false;
    }
}

