/*
 * Decompiled with CFR 0.152.
 */
package com.aykuttasil.callrecord;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;
import android.util.Log;
import com.aykuttasil.callrecord.helper.PrefsHelper;
import com.aykuttasil.callrecord.receiver.CallRecordReceiver;
import com.aykuttasil.callrecord.service.CallRecordService;

public class CallRecord {
    private static final String TAG = CallRecord.class.getSimpleName();
    public static final String PREF_SAVE_FILE = "PrefSaveFile";
    public static String INTENT_FILE_NAME = "CallRecordFileName";
    public static String INTENT_DIR_NAME = "CallRecordDirName";
    public static String INTENT_DIR_PATH = "CallRecordDirPath";
    public static String INTENT_SHOW_SEED = "CallRecordShowSeed";
    public static String INTENT_AUDIO_SOURCE = "CallRecorAudioSource";
    public static String INTENT_AUDIO_ENCODER = "CallRecordAudioEncode";
    public static String INTENT_OUTPUT_FORMAT = "CallRecordOutputSource";
    private Context mContext;
    private CallRecordReceiver mCallRecordReceiver;
    private Builder mBuilder;
    private Intent intent;

    private CallRecord(Context context, Builder builder) {
        this.mContext = context;
        this.mCallRecordReceiver = new CallRecordReceiver();
        this.mBuilder = builder;
    }

    private CallRecord(Context context, Intent intent) {
        this.mContext = context;
        this.intent = intent;
        this.mCallRecordReceiver = new CallRecordReceiver();
    }

    public static CallRecord initReceiver(Context context) {
        CallRecord callRecord = new Builder(context).build();
        callRecord.startCallReceiver();
        return callRecord;
    }

    public static CallRecord initService(Context context) {
        CallRecord callRecord = new Builder(context).buildService();
        callRecord.startCallRecordService();
        return callRecord;
    }

    public void startCallReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        intentFilter.addAction("android.intent.action.NEW_OUTGOING_CALL");
        this.mCallRecordReceiver.setmBuilder(this.mBuilder);
        this.mContext.registerReceiver((BroadcastReceiver)this.mCallRecordReceiver, intentFilter);
    }

    public void stopCallReceiver() {
        try {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mCallRecordReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCallRecordService() {
        if (this.intent == null) {
            try {
                throw new Exception("Intent nesnesi bo\u015f. L\u00fctfen buildService() i \u00e7al\u0131\u015ft\u0131rd\u0131\u011f\u0131n\u0131zdan emin olun.");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.intent.setClass(this.mContext, CallRecordService.class);
        Log.i((String)TAG, (String)"startService()");
        this.mContext.startService(this.intent);
    }

    public void enableSaveFile() {
        PrefsHelper.writePrefBool(this.mContext, PREF_SAVE_FILE, true);
    }

    public void disableSaveFile() {
        PrefsHelper.writePrefBool(this.mContext, PREF_SAVE_FILE, false);
    }

    public static class Builder {
        private Context context;
        private String recordFileName;
        private String recordDirName;
        private String recordDirPath;
        private int audioSource;
        private int audioEncoder;
        private int outputFormat;
        private boolean showSeed;

        public Builder(Context context) {
            this.context = context;
            this.recordFileName = "Record";
            this.recordDirName = "CallRecord";
            this.recordDirPath = Environment.getExternalStorageDirectory().getPath();
            this.audioSource = 7;
            this.audioEncoder = 1;
            this.outputFormat = 3;
            this.showSeed = true;
        }

        public CallRecord build() {
            CallRecord callRecord = new CallRecord(this.context, this);
            callRecord.enableSaveFile();
            return callRecord;
        }

        public CallRecord buildService() {
            Intent intent = new Intent();
            intent.putExtra(INTENT_FILE_NAME, this.getRecordFileName());
            intent.putExtra(INTENT_DIR_NAME, this.getRecordDirName());
            intent.putExtra(INTENT_DIR_PATH, this.getRecordDirPath());
            intent.putExtra(INTENT_AUDIO_ENCODER, this.getAudioEncoder());
            intent.putExtra(INTENT_AUDIO_SOURCE, this.getAudioSource());
            intent.putExtra(INTENT_OUTPUT_FORMAT, this.getOutputFormat());
            intent.putExtra(INTENT_SHOW_SEED, this.isShowSeed());
            CallRecord callRecord = new CallRecord(this.context, intent);
            callRecord.enableSaveFile();
            return callRecord;
        }

        public Builder setRecordFileName(String recordFileName) {
            this.recordFileName = recordFileName;
            return this;
        }

        public String getRecordFileName() {
            return this.recordFileName;
        }

        public Builder setRecordDirName(String recordDirName) {
            this.recordDirName = recordDirName;
            return this;
        }

        public String getRecordDirName() {
            return this.recordDirName;
        }

        public int getAudioSource() {
            return this.audioSource;
        }

        public Builder setAudioSource(int audioSource) {
            this.audioSource = audioSource;
            return this;
        }

        public int getAudioEncoder() {
            return this.audioEncoder;
        }

        public Builder setAudioEncoder(int audioEncoder) {
            this.audioEncoder = audioEncoder;
            return this;
        }

        public int getOutputFormat() {
            return this.outputFormat;
        }

        public Builder setOutputFormat(int outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public boolean isShowSeed() {
            return this.showSeed;
        }

        public Builder setShowSeed(boolean showSeed) {
            this.showSeed = showSeed;
            return this;
        }

        public String getRecordDirPath() {
            return this.recordDirPath;
        }

        public Builder setRecordDirPath(String recordDirPath) {
            this.recordDirPath = recordDirPath;
            return this;
        }
    }
}

