/*
 * Decompiled with CFR 0.152.
 */
package com.aykuttasil.callrecord.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CallRecordReceiver
extends BroadcastReceiver {
    private static final String TAG = CallRecordReceiver.class.getSimpleName();
    public static final String ACTION_IN = "android.intent.action.PHONE_STATE";
    public static final String ACTION_OUT = "android.intent.action.NEW_OUTGOING_CALL";
    private static MediaRecorder recorder;
    private static boolean recordstarted;
    private static boolean wasRinging;
    Bundle bundle;
    File audiofile;
    private String inCall;
    private String outCall;
    private String state;
    private String fileName;
    private String dirName;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void onReceive(Context context, Intent intent) {
        try {
            this.bundle = intent.getExtras();
            if (this.bundle == null) {
                Log.e((String)TAG, (String)"Intent extras are null");
                return;
            }
            this.state = this.bundle.getString("state");
            Log.i((String)TAG, (String)(this.state == null ? "null" : this.state));
            if (intent.getAction().equals(ACTION_IN)) {
                Log.i((String)TAG, (String)ACTION_IN);
                if (this.state.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                    this.inCall = this.bundle.getString("incoming_number");
                    wasRinging = true;
                } else if (this.state.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                    if (wasRinging && !recordstarted) {
                        this.startRecord("incoming");
                        Log.i((String)TAG, (String)"start record");
                    }
                } else if (this.state.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                    wasRinging = false;
                    Log.i((String)TAG, (String)(recordstarted ? "recordstarted is true" : "recordstarted is false"));
                    if (recordstarted) {
                        recorder.stop();
                        recorder.reset();
                        recorder.release();
                        recordstarted = false;
                        Log.i((String)TAG, (String)"stop record");
                    }
                }
            } else if (intent.getAction().equals(ACTION_OUT)) {
                Log.i((String)TAG, (String)ACTION_OUT);
                this.bundle = intent.getExtras();
                if (this.bundle != null) {
                    this.outCall = intent.getStringExtra("android.intent.extra.PHONE_NUMBER");
                    if (!recordstarted) {
                        this.startRecord("outgoing");
                        Log.i((String)TAG, (String)"start record");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startRecord(String seed) {
        try {
            String dateString = new SimpleDateFormat("dd-MM-yyyy HH-mm-ss", Locale.US).format(new Date());
            File sampleDir = new File(Environment.getExternalStorageDirectory(), "/" + this.getDirName());
            if (!sampleDir.exists()) {
                sampleDir.mkdirs();
            }
            String file_name = this.getFileName() + "_" + seed + "_" + dateString;
            this.audiofile = File.createTempFile(file_name, ".amr", sampleDir);
            recorder = new MediaRecorder();
            recorder.setAudioSource(7);
            recorder.setOutputFormat(3);
            recorder.setAudioEncoder(1);
            recorder.setOutputFile(this.audiofile.getAbsolutePath());
            recorder.prepare();
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
        }
        recorder.start();
        recordstarted = true;
        Log.i((String)TAG, (String)"record start");
    }

    static {
        recordstarted = false;
        wasRinging = false;
    }
}

