/*
 * Decompiled with CFR 0.152.
 */
package com.aykuttasil.callrecord;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.aykuttasil.callrecord.receiver.CallRecordReceiver;
import com.aykuttasil.callrecord.service.CallRecordService;

public class CallRecord {
    private static final String TAG = CallRecord.class.getSimpleName();
    public static String INTENT_FILE_NAME = "RecordFileName";
    public static String INTENT_DIR_NAME = "RecordDirName";
    private Context mContext;
    private CallRecordReceiver mCallRecordReceiver;
    private Intent intent;
    private String fileName;
    private String dirName;

    private CallRecord(Context context) {
        this.mContext = context;
        this.mCallRecordReceiver = new CallRecordReceiver();
    }

    private CallRecord(Context context, Intent intent) {
        this.mContext = context;
        this.intent = intent;
        this.mCallRecordReceiver = new CallRecordReceiver();
    }

    public static CallRecord initReceiver(Context context) {
        CallRecord callRecord = new Builder(context).build();
        callRecord.startCallReceiver();
        return callRecord;
    }

    public static CallRecord initService(Context context) {
        CallRecord callRecord = new Builder(context).buildService();
        callRecord.startCallRecordService();
        return callRecord;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private String getFileName() {
        return this.fileName;
    }

    private void setDirName(String dirName) {
        this.dirName = dirName;
    }

    private String getDirName() {
        return this.dirName;
    }

    private void setIntent(Intent intent) {
        this.intent = intent;
    }

    private Intent getIntent() {
        return this.intent;
    }

    public void startCallReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        intentFilter.addAction("android.intent.action.NEW_OUTGOING_CALL");
        this.mCallRecordReceiver.setFileName(this.getFileName());
        this.mCallRecordReceiver.setDirName(this.getDirName());
        this.mContext.registerReceiver((BroadcastReceiver)this.mCallRecordReceiver, intentFilter);
    }

    public void stopCallReceiver() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mCallRecordReceiver);
    }

    public void startCallRecordService() {
        if (this.intent == null) {
            try {
                throw new Exception("Intent nesnesi bo\u015f. L\u00fctfen buildService() i \u00e7al\u0131\u015ft\u0131rd\u0131\u011f\u0131n\u0131zdan emin olun.");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.intent.setClass(this.mContext, CallRecordService.class);
        Log.i((String)TAG, (String)"startService()");
        this.mContext.startService(this.intent);
    }

    public static class Builder {
        private Context context;
        private String recordFileName = "Record";
        private String recordDirName = "CallRecord";

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setRecordFileName(String recordFileName) {
            this.recordFileName = recordFileName;
            return this;
        }

        private String getRecordFileName() {
            return this.recordFileName;
        }

        public Builder setRecordDirName(String recordDirName) {
            this.recordDirName = recordDirName;
            return this;
        }

        private String getRecordDirName() {
            return this.recordDirName;
        }

        public CallRecord build() {
            CallRecord callRecord = new CallRecord(this.context);
            callRecord.setFileName(this.getRecordFileName());
            callRecord.setDirName(this.getRecordDirName());
            return callRecord;
        }

        public CallRecord buildService() {
            Intent intent = new Intent();
            intent.putExtra(INTENT_FILE_NAME, this.getRecordFileName());
            intent.putExtra(INTENT_DIR_NAME, this.getRecordDirName());
            return new CallRecord(this.context, intent);
        }
    }
}

