/*
 * Decompiled with CFR 0.152.
 */
package com.axis.system.jenkins.plugins.downstream.yabv;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class NameNormalizer<T> {
    private static String NAME_SEPARATOR = "/";
    private static String ROOT_NAME = "";
    Set<String> blacklist;
    NameFunction<T> nameFunc;
    ParentFunction<T> parentFunc;

    public NameNormalizer(Set<T> items, NameFunction<T> nameFunc, ParentFunction<T> parentFunc) {
        this.nameFunc = nameFunc;
        this.parentFunc = parentFunc;
        this.blacklist = NameNormalizer.generateBlacklist(items, nameFunc, parentFunc);
    }

    private static <T> Set<String> generateBlacklist(Set<T> items, NameFunction<T> nameFunc, ParentFunction<T> parentFunc) {
        HashSet<String> blacklist = new HashSet<String>();
        HashSet<String> reserved = new HashSet<String>();
        block0: for (T item : items) {
            ArrayList<String> nameSegments = new ArrayList<String>();
            while (item != null) {
                nameSegments.add(0, parentFunc.parent(item) != null ? nameFunc.name(item) : ROOT_NAME);
                String formattedName = String.join((CharSequence)NAME_SEPARATOR, nameSegments);
                if (reserved.add(formattedName)) continue block0;
                blacklist.add(formattedName);
                item = parentFunc.parent(item);
            }
        }
        return blacklist;
    }

    public String getNormalizedName(T item) {
        ArrayList<String> nameSegments = new ArrayList<String>();
        while (item != null) {
            nameSegments.add(0, this.parentFunc.parent(item) != null ? this.nameFunc.name(item) : ROOT_NAME);
            String formattedName = String.join((CharSequence)NAME_SEPARATOR, nameSegments);
            if (!this.blacklist.contains(formattedName)) {
                return formattedName;
            }
            item = this.parentFunc.parent(item);
        }
        return String.join((CharSequence)NAME_SEPARATOR, nameSegments);
    }

    @FunctionalInterface
    public static interface ParentFunction<T> {
        public T parent(T var1);
    }

    @FunctionalInterface
    public static interface NameFunction<T> {
        public String name(T var1);
    }
}

